/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui.ui.date;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.metal.MetalTextFieldUI;
import se.ericsson.cello.support.gui.gengui.ui.date.TimeParser;

public class TimeField
extends JTextField
implements ItemSelectable {
    private static final long serialVersionUID = 8188135723416955152L;
    private Date time;
    private Calendar calendar;
    private AmPmWindow ampmWindow;
    private Locale locale;
    private int timeStyle;
    private DateFormatSymbols dfs;
    private DateFormat sdf;
    private BasicArrowButton arrowButton;
    private int hour;
    private int minute;
    private int second;
    private TimeParser parser;

    public TimeField() {
        this(Locale.getDefault(), 3);
    }

    public TimeField(Locale loc, int style) {
        this.locale = loc;
        this.timeStyle = style;
        this.parser = new TimeParser(this.locale, this.timeStyle);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.sdf = new SimpleDateFormat();
        this.setTimeStyle(this.timeStyle);
        this.calendar = new GregorianCalendar(this.locale);
        this.arrowButton = new BasicArrowButton(5);
        this.ampmWindow = new AmPmWindow(this.arrowButton, this.dfs.getAmPmStrings()[0], this.dfs.getAmPmStrings()[1]);
        this.setTime(this.calendar.getTime());
        this.registerListeners();
        this.layoutComponents();
    }

    public void setTime(Date time) {
        this.calendar.setTime(time);
        this.hour = this.calendar.get(11);
        this.minute = this.calendar.get(12);
        this.second = this.calendar.get(13);
        this.setTime(this.hour, this.minute, this.second);
    }

    public void setTime() {
        this.calendar.setTime(new Date());
        this.hour = this.calendar.get(11);
        this.minute = this.calendar.get(12);
        this.second = this.calendar.get(13);
        this.setTime(this.hour, this.minute, this.second);
    }

    public void setTime(int h, int m, int s) {
        if (h > 23) {
            h -= 24;
        } else if (h < 0) {
            h += 24;
        }
        this.calendar.set(1970, 0, 1, h, m, s);
        this.hour = h;
        this.minute = m;
        this.second = s;
        if (this.ampmWindow != null) {
            if (this.hour >= 12) {
                this.ampmWindow.pmButton.setSelected(true);
            } else {
                this.ampmWindow.amButton.setSelected(true);
            }
        }
        this.fireItemStateChanged(new ItemEvent(this, 701, this.getTime(), 1));
    }

    public Date getTime() {
        return this.calendar.getTime();
    }

    public String getTimeToString() {
        return this.sdf.format(this.calendar.getTime());
    }

    public void setTimeStyle(int style) {
        this.parser = new TimeParser(this.locale, style);
        this.timeStyle = style;
        this.sdf = DateFormat.getTimeInstance(this.timeStyle, this.locale);
        this.dfs = new DateFormatSymbols(this.locale);
        if (this.ampmWindow != null) {
            this.ampmWindow.amButton.setText(this.dfs.getAmPmStrings()[0]);
            this.ampmWindow.pmButton.setText(this.dfs.getAmPmStrings()[1]);
        }
    }

    public void setAmPmWindowEnabled(boolean enabled) {
        if (!enabled) {
            this.ampmWindow.setVisible(false);
            this.arrowButton.setVisible(false);
            this.arrowButton.setEnabled(false);
        } else {
            this.arrowButton.setVisible(true);
            this.arrowButton.setEnabled(this.isEnabled());
        }
    }

    public boolean isAmPmWindowEnabled() {
        return this.arrowButton.isVisible();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.isAmPmWindowEnabled()) {
            if (!enabled) {
                this.ampmWindow.setVisible(false);
            }
            this.arrowButton.setEnabled(enabled);
        }
    }

    public int getTimeStyle() {
        return this.timeStyle;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
        this.setTimeStyle(this.timeStyle);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void copyTime() {
        this.setTime(this.hour, this.minute, this.second);
        this.setText(this.sdf.format(this.calendar.getTime()));
    }

    public void hidePopup() {
        if (this.ampmWindow != null && this.ampmWindow.isVisible()) {
            this.ampmWindow.setVisible(false);
        }
    }

    public void showPopup() {
        Toolkit tool = Toolkit.getDefaultToolkit();
        Point thisPoint = this.getLocationOnScreen();
        int x = thisPoint.x + this.getBounds().width - this.ampmWindow.getBounds().width;
        if (x < 0) {
            x = 0;
        }
        if (x + this.ampmWindow.getBounds().width > tool.getScreenSize().width) {
            x = tool.getScreenSize().width - this.ampmWindow.getBounds().width;
        }
        int y = thisPoint.y + this.getBounds().height + this.ampmWindow.getBounds().height > tool.getScreenSize().height ? thisPoint.y - this.ampmWindow.getBounds().height : thisPoint.y + this.getBounds().height;
        Rectangle dwRect = new Rectangle(x, y, this.ampmWindow.getBounds().width, this.ampmWindow.getBounds().height);
        this.ampmWindow.setBounds(dwRect);
        this.ampmWindow.show();
        this.ampmWindow.requestFocus();
        if (this.ampmWindow.amButton.isSelected()) {
            this.ampmWindow.amButton.requestFocus();
        } else {
            this.ampmWindow.pmButton.requestFocus();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.ampmWindow != null) {
            SwingUtilities.updateComponentTreeUI(this.ampmWindow);
        }
        if (this.arrowButton != null) {
            this.layoutComponents();
        }
    }

    public void addItemListener(ItemListener aListener) {
        this.listenerList.add(ItemListener.class, aListener);
    }

    public void removeItemListener(ItemListener aListener) {
        this.listenerList.remove(ItemListener.class, aListener);
    }

    public Object[] getSelectedObjects() {
        Date selectedObject = this.getTime();
        if (selectedObject == null) {
            return new Object[0];
        }
        Object[] result = new Object[]{selectedObject};
        return result;
    }

    protected void fireItemStateChanged(ItemEvent event) {
        Object[] l = this.listenerList.getListenerList();
        for (int k = l.length - 2; k >= 0; k -= 2) {
            if (l[k] != ItemListener.class) continue;
            ((ItemListener)l[k + 1]).itemStateChanged(event);
        }
    }

    private void registerListeners() {
        MyActionListener actionListener = new MyActionListener();
        MyKeyListener keyListener = new MyKeyListener();
        this.arrowButton.addActionListener(actionListener);
        this.addKeyListener(keyListener);
    }

    private void layoutComponents() {
        this.removeAll();
        this.setPreferredSize(new Dimension(this.ampmWindow.getPreferredSize().width, this.getPreferredSize().height));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gridbag);
        gbc.gridwidth = -1;
        if (this.arrowButton != null) {
            Insets insets;
            int top = -this.getMargin().top;
            int bottom = -this.getMargin().bottom;
            int left = -(this.getMargin().left + 1);
            int right = -(this.getMargin().right + 1);
            gbc.anchor = 18;
            if (this.getUI() instanceof MetalTextFieldUI) {
                --top;
                --bottom;
            }
            gbc.insets = insets = new Insets(top, left, bottom, right);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            gbc.fill = 1;
            JLabel dummy = new JLabel("dummy"){
                private static final long serialVersionUID = -1436900365357183819L;

                public void paint(Graphics g) {
                }
            };
            this.gridBagAdd(this, dummy, gridbag, gbc);
            gbc.gridwidth = 0;
            gbc.weighty = 1.0;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.insets = insets = new Insets(top, 0, bottom, right);
            gbc.fill = 3;
            gbc.ipadx = 2;
            this.gridBagAdd(this, this.arrowButton, gridbag, gbc);
            this.setVisible(true);
        }
    }

    private void gridBagAdd(JComponent dest, JComponent comp, GridBagLayout gb, GridBagConstraints gbc) {
        dest.add(comp);
        gb.setConstraints(comp, gbc);
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                TimeField.this.ampmWindow.setVisible(false);
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            Date tempDate;
            String parseString = TimeField.this.getText();
            if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                if (e.getModifiers() != 8) {
                    int modification = 0;
                    int caretPosition = TimeField.this.getCaretPosition();
                    if (e.getKeyCode() == 38) {
                        modification = 1;
                    }
                    if (e.getKeyCode() == 40) {
                        modification = -1;
                    }
                    if (TimeField.this.parser.isHourField(parseString, caretPosition)) {
                        TimeField.this.hour += modification;
                    } else if (TimeField.this.parser.isMinuteField(parseString, caretPosition)) {
                        TimeField.this.minute += modification;
                    } else if (TimeField.this.parser.isSecondField(parseString, caretPosition)) {
                        TimeField.this.second += modification;
                    } else if (TimeField.this.parser.isAmPmField(parseString, caretPosition)) {
                        if (((TimeField)TimeField.this).ampmWindow.amButton.isSelected()) {
                            ((TimeField)TimeField.this).ampmWindow.pmButton.doClick();
                        } else {
                            ((TimeField)TimeField.this).ampmWindow.amButton.doClick();
                        }
                    }
                    if (e.getModifiers() == 0 && caretPosition >= 0 && caretPosition <= parseString.length()) {
                        TimeField.this.copyTime();
                        if (TimeField.this.getText().length() < caretPosition) {
                            caretPosition = TimeField.this.getText().length();
                        }
                        TimeField.this.setCaretPosition(caretPosition);
                    }
                } else {
                    if (e.getKeyCode() == 38) {
                        TimeField.this.ampmWindow.setVisible(false);
                    } else if (!TimeField.this.ampmWindow.isVisible()) {
                        TimeField.this.arrowButton.doClick();
                    }
                    e.setKeyChar('\uffff');
                }
            } else if (TimeField.this.parser != null && !Character.isIdentifierIgnorable(e.getKeyChar()) && (tempDate = TimeField.this.parser.parseDate(parseString)) != null) {
                TimeField.this.setTime(tempDate);
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (TimeField.this.ampmWindow.isVisible()) {
                TimeField.this.hidePopup();
            } else {
                TimeField.this.showPopup();
            }
        }
    }

    private class AmPmWindow
    extends JWindow
    implements ActionListener {
        private static final long serialVersionUID = -4598643713373897981L;
        public JPanel buttonPanel;
        public JRadioButton amButton;
        public JRadioButton pmButton;
        private boolean buttonFlag;

        public AmPmWindow(BasicArrowButton connectedButton, String AmString, String PmString) {
            this.getContentPane().setLayout(new BorderLayout());
            ButtonGroup group = new ButtonGroup();
            this.amButton = new JRadioButton(AmString);
            this.amButton.setActionCommand("am");
            this.amButton.addActionListener(this);
            this.pmButton = new JRadioButton(PmString);
            this.pmButton.setActionCommand("pm");
            this.pmButton.addActionListener(this);
            group.add(this.amButton);
            group.add(this.pmButton);
            this.getContentPane().add((Component)this.amButton, "West");
            this.getContentPane().add((Component)this.pmButton, "East");
            BevelBorder border = new BevelBorder(1, Color.lightGray, Color.gray, Color.darkGray, Color.lightGray);
            this.getRootPane().setBorder(border);
            this.pack();
            this.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (!AmPmWindow.this.buttonFlag) {
                        AmPmWindow.this.setVisible(false);
                    }
                }
            });
            connectedButton.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    AmPmWindow.this.buttonFlag = true;
                }

                public void mouseExited(MouseEvent e) {
                    AmPmWindow.this.buttonFlag = false;
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("am")) {
                if (TimeField.this.hour >= 12) {
                    TimeField.this.hour = TimeField.this.hour - 12;
                }
            } else if (TimeField.this.hour < 12) {
                TimeField.this.hour = TimeField.this.hour + 12;
            }
            this.setVisible(false);
            TimeField.this.copyTime();
        }
    }
}

