/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui.ui.general;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicArrowButton;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class SpinBox
extends JTextField
implements ItemSelectable,
ActionListener,
KeyListener {
    private static final long serialVersionUID = -1290242018302286920L;
    private JTextField textField;
    private BasicArrowButton arrowButtonUp = new BasicArrowButton(1);
    private BasicArrowButton arrowButtonDown = new BasicArrowButton(5);
    private long step = 1L;
    private Vector listVector = null;
    private int listIndex;

    public SpinBox() {
        this("", 0, true);
    }

    public SpinBox(String text) {
        this(text, 0, true);
    }

    public SpinBox(int columns) {
        this("", columns, true);
    }

    public SpinBox(String text, int columns) {
        this(text, columns, true);
    }

    public SpinBox(Vector v) {
        this(v, 0, false);
    }

    public SpinBox(Vector v, int columns) {
        this(v, columns, false);
    }

    public SpinBox(Vector v, int columns, boolean edit) {
        this(v.elementAt(0).toString(), columns, edit);
        this.listVector = v;
        this.listIndex = 0;
    }

    public SpinBox(String text, int columns, boolean edit) {
        super(text, columns);
        this.setEditable(edit);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.layoutComponents();
        this.registerListeners();
    }

    public void addItemListener(ItemListener aListener) {
        this.listenerList.add(ItemListener.class, aListener);
    }

    public void removeItemListener(ItemListener aListener) {
        this.listenerList.remove(ItemListener.class, aListener);
    }

    public Object[] getSelectedObjects() {
        String selectedObject = this.getText();
        if (selectedObject == null) {
            return new Object[0];
        }
        Object[] result = new Object[]{selectedObject};
        return result;
    }

    protected void fireItemStateChanged(ItemEvent event) {
        Object[] l = this.listenerList.getListenerList();
        for (int k = l.length - 2; k >= 0; k -= 2) {
            if (l[k] != ItemListener.class) continue;
            ((ItemListener)l[k + 1]).itemStateChanged(event);
        }
    }

    public void setVector(Vector v) {
        this.listVector = v;
        this.listIndex = 0;
        this.setText(this.listVector.elementAt(0).toString());
    }

    public Vector getVector() {
        return this.listVector;
    }

    public void updateUI() {
        super.updateUI();
        if (this.arrowButtonUp != null && this.arrowButtonDown != null) {
            this.layoutComponents();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width + this.arrowButtonUp.getPreferredSize().width, super.getPreferredSize().height);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.listVector == null) {
            long valueInBox = 0L;
            try {
                valueInBox = Long.valueOf(this.getText());
                if (e.getActionCommand().equals("up")) {
                    this.setText(String.valueOf(valueInBox + this.step));
                } else if (e.getActionCommand().equals("down")) {
                    this.setText(String.valueOf(valueInBox - this.step));
                }
                this.fireItemStateChanged(new ItemEvent(this, 701, this.getText(), 1));
            }
            catch (Exception exc) {
                Log.trace(exc + " : only numeric values allowed in the SpinBox.");
            }
        } else {
            if (e.getActionCommand().equals("up")) {
                ++this.listIndex;
                if (this.listIndex > this.listVector.size() - 1) {
                    this.listIndex = 0;
                }
                this.setText(this.listVector.elementAt(this.listIndex).toString());
            } else if (e.getActionCommand().equals("down")) {
                --this.listIndex;
                if (this.listIndex < 0) {
                    this.listIndex = this.listVector.size() - 1;
                }
                this.setText(this.listVector.elementAt(this.listIndex).toString());
            }
            this.fireItemStateChanged(new ItemEvent(this, 701, this.getText(), 1));
        }
        this.selectAll();
        this.requestFocus();
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 10) {
            if (e.getKeyCode() == 38) {
                this.actionPerformed(new ActionEvent(this, 1001, "up"));
            } else if (e.getKeyCode() == 40) {
                this.actionPerformed(new ActionEvent(this, 1001, "down"));
            } else {
                this.actionPerformed(new ActionEvent(this, 1001, "enter"));
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void layoutComponents() {
        Insets insets;
        this.removeAll();
        int top = -(this.getMargin().top + 1);
        int bottom = -(this.getMargin().bottom + 1);
        int left = -(this.getMargin().left + 1);
        int right = -(this.getMargin().right + 1);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        this.setLayout(gridbag);
        gbc.insets = insets = new Insets(top, left, bottom, right);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        JLabel dummy = new JLabel("dummy"){
            private static final long serialVersionUID = -4625209991146508742L;

            public void paint(Graphics g) {
            }
        };
        this.gridBagAdd(this, dummy, gridbag, gbc);
        gbc.gridwidth = 0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.insets = insets = new Insets(top + 1, 0, 0, right);
        gbc.fill = 3;
        gbc.ipadx = 12;
        this.gridBagAdd(this, this.arrowButtonUp, gridbag, gbc);
        gbc.weighty = 1.0;
        gbc.weightx = 0.0;
        if (this.getPreferredSize().height % 2 == 0) {
            ++bottom;
        }
        gbc.insets = insets = new Insets(0, 0, bottom, right);
        gbc.ipadx = 12;
        this.gridBagAdd(this, this.arrowButtonDown, gridbag, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gridbag.setConstraints(this, gbc);
        this.setVisible(true);
    }

    private void registerListeners() {
        MyFocusListener focusListener = new MyFocusListener();
        this.arrowButtonUp.addActionListener(this);
        this.arrowButtonUp.setActionCommand("up");
        this.arrowButtonDown.addActionListener(this);
        this.arrowButtonDown.setActionCommand("down");
        this.addFocusListener(focusListener);
        this.addKeyListener(this);
    }

    private void gridBagAdd(JComponent dest, JComponent comp, GridBagLayout gb, GridBagConstraints gbc) {
        gb.setConstraints(comp, gbc);
        dest.add(comp);
    }

    private class MyFocusListener
    implements FocusListener {
        private MyFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            SpinBox.this.selectAll();
        }

        public void focusLost(FocusEvent e) {
            SpinBox.this.select(0, 0);
        }
    }
}

