/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.comp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JPanel;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class ButtonPanel
extends JPanel {
    private static final long serialVersionUID = -6423436085322775187L;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int NORTHWEST = 18;
    public static final int WEST = 17;
    public static final int SOUTHWEST = 16;
    public static final int NORTH = 11;
    public static final int CENTER = 10;
    public static final int SOUTH = 15;
    public static final int NORTHEAST = 12;
    public static final int EAST = 13;
    public static final int SOUTHEAST = 14;
    private static final int GAP = 10;
    private int alignment = 0;
    private int orientation = 14;
    private JPanel buttonPanel = new JPanel();

    public ButtonPanel() {
        this.setLayout(new GridBagLayout());
    }

    public ButtonPanel(int alignment, int orientation) {
        this();
        this.alignment = alignment;
        this.orientation = orientation;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.updateLayout();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.updateLayout();
    }

    public void addButton(JButton button) {
        Component[] addedComponents = this.buttonPanel.getComponents();
        int length = addedComponents.length;
        Component[] components = new Component[length + 1];
        System.arraycopy(addedComponents, 0, components, 0, length);
        components[length] = button;
        this.updateLayout(components);
    }

    private void updateLayout() {
        this.updateLayout(this.buttonPanel.getComponents());
    }

    private void updateLayout(Component[] components) {
        this.removeAll();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        int x = 0;
        int y = 0;
        int top = 0;
        int left = 0;
        int fill = 0;
        if (this.alignment == 1) {
            fill = 2;
        }
        for (int i = 0; i < components.length; ++i) {
            this.buttonPanel.add(components[i], new GridBagConstraints(x, y, 1, 1, 1.0, 1.0, 10, fill, new Insets(top, left, 0, 0), 0, 0));
            if (this.alignment == 0) {
                x = i + 1;
                left = 10;
                continue;
            }
            y = i + 1;
            top = 10;
        }
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, this.orientation, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.revalidate();
        this.repaint();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        Log.assertion(comp == this.buttonPanel, "Buttons can only be added to a ButtonPanel with addButton(JButton)");
        super.addImpl(comp, constraints, index);
    }
}

