/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractRequest;

public abstract class AbstractCorbaRequest
extends AbstractRequest {
    protected final void handleException(Exception exception) {
        if (this.handleAllExceptions(exception)) {
            if (exception instanceof UserException) {
                this.handleUserExceptionDefault((UserException)exception);
            } else if (exception instanceof UNKNOWN) {
                this.handleUnknownServerExceptionDefault((UNKNOWN)exception);
            } else if (exception instanceof NO_PERMISSION) {
                this.handleSecurityExceptionDefault((NO_PERMISSION)exception);
            } else if (exception instanceof SystemException) {
                this.handleSystemExceptionDefault((SystemException)exception);
            } else {
                this.handleUnknownClientExceptionDefault(exception);
            }
        }
    }

    private void handleUserExceptionDefault(UserException ue) {
        if (this.handleUserException(ue)) {
            Log.logError("AbstractCorbaRequest Exception: ", (Throwable)ue);
            this.showDefaultErrorDialog("GSL_USER_EXCEPTION_ERROR");
        }
    }

    private void handleUnknownServerExceptionDefault(UNKNOWN u) {
        if (this.handleUnknownServerException(u)) {
            Log.logError("AbstractCorbaRequest Exception: ", (Throwable)u);
            this.showDefaultErrorDialog("GSL_UNKNOWN_SERVER_ERROR");
        }
    }

    private void handleSecurityExceptionDefault(NO_PERMISSION sec) {
        if (this.handleSecurityException(sec)) {
            Log.logError("AbstractCorbaRequest Exception: ", (Throwable)sec);
            this.showDefaultErrorDialog("GSL_UNKNOWN_SECURITY_ERROR");
        }
    }

    private void handleSystemExceptionDefault(SystemException se) {
        if (this.handleSystemException(se)) {
            Log.logError("AbstractCorbaRequest Exception: ", (Throwable)se);
            if (se instanceof BAD_PARAM) {
                this.showDefaultErrorDialog("GSL_BAD_PARAM_ERROR");
            }
        }
    }

    private void handleUnknownClientExceptionDefault(Exception e) {
        if (this.handleUnknownClientException(e)) {
            Log.logError("AbstractCorbaRequest Exception: ", e);
            this.showDefaultErrorDialog("GSL_UNKNOWN_CLIENT_ERROR");
        }
    }

    private void showDefaultErrorDialog(String title) {
        int confirm = this.getController().showConfirmDialog(title, null, "GSL_COMMUNICATION_ERROR", null, 2, 0, null);
        if (confirm == 0) {
            this.getController().getApplication().stopApplicationNoCheck();
        }
    }

    protected boolean handleAllExceptions(Exception e) {
        return true;
    }

    protected boolean handleUserException(UserException ue) {
        return true;
    }

    protected boolean handleUnknownServerException(UNKNOWN u) {
        return true;
    }

    protected boolean handleSecurityException(NO_PERMISSION sec) {
        return true;
    }

    protected boolean handleSystemException(SystemException se) {
        return true;
    }

    protected boolean handleUnknownClientException(Exception exception) {
        return true;
    }
}

