/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogView;

class PrintPreviewView
extends AbstractDialogView {
    private static final long serialVersionUID = -1291809744769934203L;
    PreviewContainer previewContainer;
    JPanel buttonPanel = new JPanel();
    JButton printButton = new JButton("GSL_PRINT");
    JButton closeButton = new JButton("GSL_CLOSE");
    JButton refreshButton = new JButton("GSL_REFRESH");
    JComboBox comboScale = new JComboBox();
    JCheckBox resolutionButton = new JCheckBox("GSL_HIGH_RESOLUTION");
    boolean beenVisible = false;

    PrintPreviewView() {
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.previewContainer = new PreviewContainer();
        JScrollPane ps = new JScrollPane(this.previewContainer);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.comboScale, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 10, 5, 0), 10, 0));
        this.buttonPanel.add((Component)this.resolutionButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.buttonPanel.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1000.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.refreshButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.buttonPanel.add((Component)this.printButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.buttonPanel.add((Component)this.closeButton, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.add((Component)ps, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 400);
    }

    public void myPaint() {
        this.beenVisible = true;
        this.paint(this.getGraphics());
    }

    public void paint(Graphics graph) {
        if (this.beenVisible) {
            super.paint(graph);
        }
    }

    static class PreviewContainer
    extends JPanel {
        private static final long serialVersionUID = -4576105552965424059L;
        protected int h_gap = 16;
        protected int v_gap = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int compCounts = this.getComponentCount();
            if (compCounts == 0) {
                return new Dimension(this.h_gap, this.v_gap);
            }
            Component component = this.getComponent(0);
            Dimension dc = component.getPreferredSize();
            int width = dc.width;
            int height = dc.height;
            Dimension size = this.getParent().getSize();
            int col = Math.max((size.width - this.h_gap) / (width + this.h_gap), 1);
            int row = compCounts / col;
            if (row * col < compCounts) {
                ++row;
            }
            int ww = col * (width + this.h_gap) + this.h_gap;
            int hh = row * (height + this.v_gap) + this.v_gap;
            Insets inset = this.getInsets();
            return new Dimension(ww + inset.left + inset.right, hh + inset.top + inset.bottom);
        }

        public void doLayout() {
            Insets inset = this.getInsets();
            int x = inset.left + this.h_gap;
            int y = inset.top + this.v_gap;
            int compCounts = this.getComponentCount();
            if (compCounts == 0) {
                return;
            }
            Component component = this.getComponent(0);
            Dimension dc = component.getPreferredSize();
            int width = dc.width;
            int height = dc.height;
            Dimension size = this.getParent().getSize();
            int col = Math.max((size.width - this.h_gap) / (width + this.h_gap), 1);
            int row = compCounts / col;
            if (row * col < compCounts) {
                ++row;
            }
            int idx = 0;
            for (int k = 0; k < row; ++k) {
                for (int m = 0; m < col; ++m) {
                    if (idx >= compCounts) {
                        return;
                    }
                    component = this.getComponent(idx++);
                    component.setBounds(x, y, width, height);
                    x += width + this.h_gap;
                }
                y += height + this.v_gap;
                x = inset.left + this.h_gap;
            }
        }
    }
}

