/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.io.UnsupportedEncodingException;
import se.ericsson.cello.support.logging.Filter;
import se.ericsson.cello.support.logging.Formatter;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;
import sun.io.CharToByteConverter;

public abstract class Handler {
    private static final int offValu = Level.OFF.intValue();
    private LogManager manage = LogManager.getLogManager();
    private Filter filt;
    private Formatter format;
    private Level logLev = Level.ALL;
    private Exception lastExcep;
    private String encod;
    boolean sealedder = true;

    protected Handler() {
    }

    public abstract void publish(LogRecord var1);

    public abstract void flush();

    public abstract void close() throws SecurityException;

    public void setFormatter(Formatter newFormat) throws SecurityException {
        this.checkAccessRight();
        newFormat.getClass();
        this.format = newFormat;
    }

    public Formatter getFormatter() {
        return this.format;
    }

    public void setEncoding(String encod) throws SecurityException, UnsupportedEncodingException {
        this.checkAccessRight();
        if (encod != null) {
            CharToByteConverter.getConverter((String)encod);
        }
        this.encod = encod;
    }

    public String getEncoding() {
        return this.encod;
    }

    public void setFilter(Filter newFilt) throws SecurityException {
        this.checkAccessRight();
        this.filt = newFilt;
    }

    public Filter getFilter() {
        return this.filt;
    }

    public Exception getException() {
        this.flush();
        return this.lastExcep;
    }

    protected void setException(Exception exception) {
        this.lastExcep = exception;
    }

    public synchronized void setLevel(Level newLev) throws SecurityException {
        if (newLev == null) {
            throw new NullPointerException();
        }
        this.checkAccessRight();
        this.logLev = newLev;
    }

    public synchronized Level getLevel() {
        return this.logLev;
    }

    public boolean isLoggable(LogRecord recorder) {
        int levelValue = this.getLevel().intValue();
        if (recorder.getLevel().intValue() < levelValue || levelValue == offValu) {
            return false;
        }
        Filter filt = this.getFilter();
        if (filt == null) {
            return true;
        }
        return filt.isLoggable(recorder);
    }

    void checkAccessRight() throws SecurityException {
        if (this.sealedder) {
            this.manage.checkAccess();
        }
    }
}

