/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.mgr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.omg.CORBA.TRANSIENT;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.EmasProgressMonitor;
import se.ericsson.cello.support.gui.EmasProperties;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.PropertiesHelper;
import se.ericsson.cello.support.gui.ViewElementCreator;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.ElementMapping;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementInterface;
import se.ericsson.cello.support.mgr.FactoryHelper;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class EmasViewElementCreator
extends ViewElementCreator
implements MOProxy.MOListener {
    protected Hashtable childElements = new Hashtable();
    protected Hashtable parentElements = new Hashtable();
    protected Vector elementMappings = new Vector();
    private EmasProperties properties;
    protected String viewprefix;
    private String myPackagePath;
    static final int TIME_TO_PROGRESS_VIEW_MS = 750;

    public EmasViewElementCreator(Properties p, String packagePath) {
        this.properties = (EmasProperties)p;
        this.myPackagePath = packagePath;
        this.createElements();
    }

    public EmasViewElementCreator(Properties p) {
        this.properties = (EmasProperties)p;
        this.myPackagePath = this.createPackagePath();
        this.createElements();
    }

    private String createPackagePath() {
        try {
            StringTokenizer elements = new StringTokenizer(this.properties.getProperty("elements"), ",");
            String element = elements.nextToken();
            String classPath = this.properties.getProperty("element." + element + ".properties");
            classPath = classPath.replace('/', '.');
            int index = classPath.lastIndexOf(".resources");
            classPath = classPath.substring(1, index);
            index = classPath.lastIndexOf(".");
            return classPath.substring(0, index);
        }
        catch (Exception e) {
            return "";
        }
    }

    private void createElements() {
        String viewprefix = this.getAssertedProperty("viewprefix");
        String creatorprefix = this.getAssertedProperty("creatorprefix");
        String elements = this.properties.getProperty(creatorprefix + "elements");
        if (MainWindowController.PROPS_DEBUG) {
            System.out.println("____________________" + (EmasProperties.isExtended(this.properties, creatorprefix + "elements") ? "EXT.elements = " : "elements = ") + elements);
        }
        if (elements == null) {
            elements = this.properties.getProperty("elements");
        }
        if (elements == null || elements.equals("") || elements.equalsIgnoreCase("null")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(elements, ",");
        while (st.hasMoreTokens()) {
            String tag = st.nextToken();
            String key = "element." + tag;
            String className = this.properties.getProperty(key + ".class");
            if (className == null || className.equals("") || className.equalsIgnoreCase("null")) continue;
            String propName = this.properties.getProperty(key + ".properties");
            Properties pp = propName == null ? this.properties : (propName.equals("null") ? new EmasProperties() : PropertiesHelper.getProperties(propName, this.myPackagePath));
            ((Properties)pp).setProperty("elementprefix", viewprefix + key + ".");
            ElementMapping mapping = new ElementMapping(pp, tag, className, new String[0]);
            String mos = this.properties.getProperty(key + ".mos");
            if (mos != null) {
                StringTokenizer st2 = new StringTokenizer(mos, ",");
                while (st2.hasMoreTokens()) {
                    mapping.addMoType(st2.nextToken());
                }
            }
            String headingsProp = this.properties.getProperty(key + ".tableHeadings");
            if (MainWindowController.PROPS_DEBUG) {
                System.out.println("____________________" + (EmasProperties.isExtended(this.properties, key + ".class") ? "EXT." + key + ".class = " : key + ".class = ") + className);
                System.out.println("____________________" + (EmasProperties.isExtended(this.properties, key + ".properties") ? "EXT." + key + ".properties = " : key + ".properties = ") + propName);
                System.out.println("____________________" + (EmasProperties.isExtended(this.properties, key + ".mos") ? "EXT." + key + ".mos = " : key + ".mos = ") + mos);
                System.out.println("____________________" + (EmasProperties.isExtended(this.properties, key + ".tableHeadings") ? "EXT." + key + ".tableHeadings = " : key + ".tableHeadings = ") + headingsProp);
            }
            if (headingsProp != null) {
                StringTokenizer headingsST = new StringTokenizer(headingsProp, ",");
                ArrayList<String> headings = new ArrayList<String>();
                while (headingsST.hasMoreTokens()) {
                    headings.add(headingsST.nextToken());
                }
                int columnCount = headings.size();
                if (columnCount > 0) {
                    String[] h = headings.toArray(new String[columnCount]);
                    mapping.setTableHeadings(h);
                    h = null;
                }
                headings = null;
            }
            this.addElementMapping(mapping);
        }
    }

    private void addElementMapping(ElementMapping map) {
        this.elementMappings.add(map);
    }

    public EmasViewElementInterface createElement(ElementMapping map, MOProxy mo) {
        EmasViewElementInterface newElement = null;
        MOComposite moc = map.getMOC(mo);
        String className = map.getElementClass();
        if (moc != null) {
            try {
                Object[] args = new Object[]{moc, map.getProperties(), this};
                newElement = (EmasViewElementInterface)FactoryHelper.instantiateClass(className, args);
                String[] headings = map.getTableHeadings();
                newElement.setChildrenAttributes(headings);
                Log.trace("Element " + className + " created for MO=" + mo.getDN());
            }
            catch (Exception e) {
                Log.logError("Element " + className + " could not be created for mo=" + mo.getDN());
                return null;
            }
        }
        return newElement;
    }

    public EmasViewElementInterface createElement(MOProxy mo) {
        EmasViewElementInterface newElement = null;
        Iterator i = this.elementMappings.iterator();
        while (i.hasNext() && newElement == null) {
            ElementMapping map = (ElementMapping)i.next();
            newElement = this.createElement(map, mo);
        }
        return newElement;
    }

    public synchronized boolean addElement(EmasViewElementInterface newElement) {
        boolean elementWasAdded;
        block8: {
            elementWasAdded = false;
            if (newElement != null) {
                Log.trace("addElement " + newElement.getType());
                String dn = newElement.getDN();
                if (!this.childElements.containsKey(dn)) {
                    this.childElements.put(dn, newElement);
                    boolean allMosArePresent = true;
                    Iterator i = newElement.getMOC().iterator();
                    try {
                        while (i.hasNext()) {
                            MOProxy mo = (MOProxy)i.next();
                            Log.trace("addMOListener " + dn);
                            mo.addMOListener(newElement);
                            if (mo.isExisting()) continue;
                            allMosArePresent = false;
                        }
                        if (!allMosArePresent) {
                            this.deleteElement(newElement);
                            break block8;
                        }
                        elementWasAdded = true;
                    }
                    catch (CSException ce) {
                        Log.logWarning("Exception while checking MO existance." + ce);
                        elementWasAdded = false;
                    }
                } else {
                    Log.trace("ALREADY THERE!");
                }
            } else {
                Log.trace("addElement newElement is null!");
            }
        }
        Log.trace("addElement return=" + elementWasAdded);
        return elementWasAdded;
    }

    public synchronized boolean addElementNoCheck(EmasViewElementInterface newElement) {
        boolean elementWasAdded = false;
        if (newElement != null) {
            Log.trace("addElementNoCheck " + newElement.getType());
            String dn = newElement.getDN();
            if (!this.childElements.containsKey(dn)) {
                this.childElements.put(dn, newElement);
                elementWasAdded = true;
                Iterator i = newElement.getMOC().iterator();
                while (i.hasNext()) {
                    MOProxy mo = (MOProxy)i.next();
                    Log.trace("addMOListener " + dn);
                    mo.addMOListener(newElement);
                }
            } else {
                Log.trace("ALREADY THERE!");
            }
        } else {
            Log.trace("addElementNoCheck newElement is null!");
        }
        Log.trace("addElementNoCheck return=" + elementWasAdded);
        return elementWasAdded;
    }

    public synchronized boolean deleteElement(EmasViewElementInterface oldElement) {
        boolean elementWasDeleted = false;
        String dn = oldElement.getDN();
        Log.trace("deleteElement oldElement=" + oldElement.getType() + " dn=" + dn);
        if (this.childElements.containsKey(dn)) {
            Iterator i = oldElement.getMOC().iterator();
            while (i.hasNext()) {
                MOProxy mo = (MOProxy)i.next();
                Log.trace("removeMOListener " + mo.getDN());
                mo.removeMOListener(oldElement);
            }
            Log.trace("remove");
            this.childElements.remove(dn);
            elementWasDeleted = true;
        } else {
            Log.trace("not found!");
        }
        if (!elementWasDeleted) {
            Log.trace("Element was *NOT* deleted!");
        } else {
            Log.trace("Element was deleted!");
        }
        return elementWasDeleted;
    }

    public synchronized boolean deleteElement_dispose(EmasViewElementInterface oldElement) {
        boolean elementWasDeleted = false;
        String dn = oldElement.getDN();
        Log.trace("deleteElement oldElement=" + oldElement.getType() + " dn=" + dn);
        if (this.childElements.containsKey(dn)) {
            Iterator i = oldElement.getMOC().iterator();
            while (i.hasNext()) {
                MOProxy mo = (MOProxy)i.next();
                Log.trace("removeMOListener " + mo.getDN());
                mo.removeMOListener(oldElement);
            }
            Log.trace("remove");
            elementWasDeleted = true;
        } else {
            Log.trace("not found!");
        }
        if (!elementWasDeleted) {
            Log.trace("Element was *NOT* deleted!");
        } else {
            Log.trace("Element was deleted!");
        }
        return elementWasDeleted;
    }

    public synchronized boolean replaceElement(EmasViewElementInterface oldElement, EmasViewElementInterface newElement) {
        boolean elementWasReplaced = false;
        if (this.deleteElement(oldElement) && this.addElement(newElement)) {
            elementWasReplaced = true;
        }
        Log.trace("replaceElement return=" + elementWasReplaced);
        return elementWasReplaced;
    }

    public AbstractViewElement[] createInstances(AbstractViewElement parent) {
        Log.trace("Create instances");
        if (parent == null) {
            Log.trace("create root element");
            EmasViewElementInterface element = null;
            try {
                element = this.createElement(MOProxy.getRoot());
            }
            catch (CSException e) {
                Log.logError("Unable to create root element", e);
            }
            this.addElement(element);
            return new AbstractViewElement[]{(AbstractViewElement)((Object)element)};
        }
        EmasViewElementInterface parentElement = (EmasViewElementInterface)((Object)parent);
        MOProxy parentMO = parentElement.getLastMO();
        String dn = parentMO.getDN();
        Log.trace("parent LDN=" + parentMO.getDN());
        if (this.parentElements.containsKey(dn)) {
            this.parentElements.remove(dn);
        }
        this.parentElements.put(dn, parentElement);
        parentMO.addMOListener(this);
        Log.trace("addMOListener to LDN=" + parentMO.getDN());
        boolean mapIndex = false;
        TreeSet<String> types = new TreeSet<String>();
        for (ElementMapping map : this.elementMappings) {
            String type = map.getFirstMoType();
            types.add(type);
        }
        TreeSet<MOProxy> children = new TreeSet<MOProxy>();
        for (String type : types) {
            try {
                children.addAll(Arrays.asList(parentMO.getChildren(1, type, "")));
            }
            catch (CSException e) {
                Log.logError("cannot get children for mo=" + parentMO.getDN(), e);
            }
            if (!type.equals("")) continue;
            break;
        }
        EmasProgressMonitor pm = new EmasProgressMonitor(null, parent.translate("PROGRESS_BAR_TITLE"), parent.translate("PROGRESS_BAR_MESSAGE"), parent.getName(), 0, children.size());
        Vector<EmasViewElementInterface> newElements = new Vector<EmasViewElementInterface>();
        int progressCount = 0;
        for (MOProxy childMO : children) {
            block12: {
                if (!childMO.equals(parentMO)) {
                    try {
                        EmasViewElementInterface newElement = this.createElement(childMO);
                        if (newElement == null) break block12;
                        this.addElementNoCheck(newElement);
                        newElements.addElement(newElement);
                    }
                    catch (TRANSIENT e) {
                        Log.logError("Connection fault! ", e);
                        e.printStackTrace();
                        break;
                    }
                }
            }
            if (progressCount++ % 10 != 0) continue;
            pm.setProgress(progressCount);
        }
        pm.dialogClose();
        AbstractViewElement[] elements = newElements.toArray(new AbstractViewElement[newElements.size()]);
        return elements;
    }

    public void childCreated(MOProxy child) {
        Log.trace("CREATOR: childCreated " + child.getDN());
        AbstractViewElement parentElement = (AbstractViewElement)this.parentElements.get(child.getParent().getDN());
        EmasViewElementInterface newElement = this.createElement(child);
        if (newElement == null) {
            Log.trace("CREATOR: NOTHING");
        } else if (parentElement == null) {
            Log.trace("CREATOR: NO PARENT");
        } else if (this.addElement(newElement)) {
            Log.trace("CREATOR: ADD CHILD");
            parentElement.addChild((AbstractViewElement)((Object)newElement));
        } else {
            Log.trace("CREATOR: UNABLE TO ADD");
        }
    }

    public void childDeleted(MOProxy child) {
        Log.trace("CREATOR: childDeleted " + child.getDN());
        EmasViewElementInterface oldElement = (EmasViewElementInterface)this.childElements.get(child.getDN());
        if (oldElement == null) {
            Log.trace("CREATOR: NOTHING");
        } else {
            AbstractViewElement parent = oldElement.getParent();
            if (parent == null) {
                Log.trace("CREATOR: NO PARENT");
            } else {
                Log.trace("CREATOR: REMOVE");
                this.deleteElement(oldElement);
                parent.removeChild((AbstractViewElement)((Object)oldElement));
            }
        }
    }

    String getAssertedProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            Log.logError("Property " + key + " not found in EmasViewElementCreator properties");
        }
        return value;
    }

    public void attributesChanged(MOProxy anMO, NameValue[] SomeAttributes) {
    }

    public synchronized void dispose() {
        Log.logNotify("dispose");
        super.dispose();
        int c = 0;
        for (Map.Entry entry : this.childElements.entrySet()) {
            this.deleteElement_dispose((EmasViewElement)entry.getValue());
            ++c;
        }
        for (ElementMapping temp : this.elementMappings) {
            Object var3_3 = null;
        }
        this.childElements.clear();
        this.parentElements.clear();
        this.elementMappings.clear();
    }
}

