/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.mgr;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import se.ericsson.cello.support.gui.EmasProperties;
import se.ericsson.cello.support.gui.PropertiesHelper;
import se.ericsson.cello.support.gui.guilib.comp.Log;

class FactoryHelper {
    static final Class[] EMPTY_CLASS_ARGS = new Class[0];
    static final EmasProperties emasProp = new EmasProperties();
    static final Class emasPropClass = emasProp.getClass();
    static final PropertiesHelper propHelper = new PropertiesHelper("");
    static final Class propHelperClass = propHelper.getClass();

    FactoryHelper() {
    }

    public static Object instantiateClass(String nameOfClass, Object[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class[] argumentClasses;
        Class<?> c = Class.forName(nameOfClass);
        if (args != null) {
            argumentClasses = new Class[args.length];
            for (int i = args.length - 1; i >= 0; --i) {
                argumentClasses[i] = args[i].getClass();
                if (argumentClasses[i] == emasPropClass) {
                    argumentClasses[i] = argumentClasses[i].getSuperclass();
                }
                if (argumentClasses[i] != propHelperClass) continue;
                argumentClasses[i] = Properties.class;
            }
        } else {
            argumentClasses = EMPTY_CLASS_ARGS;
        }
        Constructor<?> constructor = null;
        try {
            constructor = c.getConstructor(argumentClasses);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            Class[] classArr = new Class[argumentClasses.length - 1];
            System.arraycopy(argumentClasses, 0, classArr, 0, classArr.length);
            Object[] objArr = new Object[args.length - 1];
            System.arraycopy(args, 0, objArr, 0, objArr.length);
            constructor = c.getConstructor(classArr);
            return constructor.newInstance(objArr);
        }
    }

    public static Properties getProperties(String fileName) {
        EmasProperties properties = new EmasProperties();
        try {
            InputStream stream = FactoryHelper.class.getResourceAsStream(fileName);
            properties.load(new BufferedInputStream(stream));
        }
        catch (Exception e) {
            Log.logError("Cannot load properties from " + fileName, e);
        }
        return properties;
    }
}

