/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.mgr;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.ErrorDialog;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.mgr.EmasViewElementInterface;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.MOProxy;

public class OEPropertiesAction
extends AbstractAction {
    private static final long serialVersionUID = 3869556847746079190L;
    private static final String OPEN_IN_OE = "OpenInOE";
    private String application;
    private EmasViewElementInterface element;
    private String codebase_jarfile = "OE_Combined_signed.jar";
    private String parameterClass = "se.ericsson.cello.support.gui.DefaultParameterLDN";
    private String application_name = "oe.client.OeLaunch";
    private boolean ldnSpecified = false;
    private String[] ldnArr;

    public OEPropertiesAction(String nameTag, EmasViewElementInterface element) {
        this.element = element;
        this.putValue("Name", element.getProperty(nameTag + ".tag"));
    }

    public OEPropertiesAction(String name, String anLdn) {
        this.putValue("Name", name);
        this.ldnArr = new String[1];
        this.ldnArr[0] = anLdn;
        this.ldnSpecified = true;
    }

    public OEPropertiesAction(String[] anLdnArray) {
        this.ldnArr = anLdnArray;
        this.ldnSpecified = true;
    }

    public OEPropertiesAction(String name, String[] anLdnArray) {
        this.putValue("Name", name);
        this.ldnArr = anLdnArray;
        this.ldnSpecified = true;
    }

    public void actionPerformed(ActionEvent event) {
        Object[] parameters = new Object[1];
        if (this.ldnSpecified) {
            parameters = new Object[this.ldnArr.length];
            System.arraycopy(this.ldnArr, 0, parameters, 0, this.ldnArr.length);
        } else if (null != this.element && null != this.element.getMOC()) {
            MOComposite moc = this.element.getMOC();
            MOProxy[] moArr = moc.getAllMOs();
            int noOfMOs = moArr.length;
            parameters = new Object[noOfMOs];
            for (int i = 0; i < noOfMOs; ++i) {
                parameters[i] = moArr[i].getDN();
            }
        } else {
            ErrorDialog errDia = ErrorDialog.create(EmasGuilibMediator.getReference().getMainWindowReference().getView(), "The properties window could not be opened.\nNo LDN was specified for the MO.", null);
            errDia.setModal(true);
            errDia.show();
            return;
        }
        MainWindowController mainWindow = EmasGuilibMediator.getReference().getMainWindowReference();
        mainWindow.startOE(OPEN_IN_OE, this.codebase_jarfile, this.parameterClass, this.application_name, parameters);
    }

    public void setLDN(String anLdn) {
        if (null != anLdn && !anLdn.trim().equals("")) {
            this.ldnArr = new String[1];
            this.ldnArr[0] = anLdn;
            this.ldnSpecified = true;
        } else {
            this.ldnSpecified = false;
        }
    }

    public void setLDNs(String[] anLdnArray) {
        if (null != this.ldnArr && this.ldnArr.length > 0) {
            this.ldnArr = anLdnArray;
            this.ldnSpecified = true;
        } else {
            this.ldnSpecified = false;
        }
    }
}

