/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy;

import java.applet.Applet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import se.ericsson.cello.support.gui.EmasFramework;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.proxy.ExceptionHandler;
import se.ericsson.cello.support.proxy.RemoteObjectManagerException;
import se.ericsson.cello.support.proxy.Test;
import se.ericsson.cello.support.proxy.Trace;

public class CORBAManager {
    public static final String NC_IOR_PARAM = "NameServerIORRelativePath";
    public static final String NC_IOR_URL_PROPERTY = "CORBAManager.ncIorUrl";
    public static final String DEFAULT_NC_IOR_URL = "file:///tmp/nameroot.ior";
    public static final String INITIALIZER_PROPERTY = "CORBAManager.orbInitializer";
    protected ORB orb;
    protected NamingContext rootContext;
    static CORBAManager theCORBAManager;

    public ORB getORB() {
        Trace.enter(CORBAManager.class, "getORB()");
        return this.orb;
    }

    public NamingContext getRootContext() {
        Trace.enter(CORBAManager.class, "getRootContext()");
        return this.rootContext;
    }

    protected void finalize() {
        Trace.enter(CORBAManager.class, "finalize()");
    }

    public static CORBAManager getInstance() {
        Trace.enter(CORBAManager.class, "getInstance()");
        return theCORBAManager;
    }

    public static synchronized void init(String[] anArgv, Properties someProperties) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, MalformedURLException, IOException {
        Trace.enter(CORBAManager.class, "init(String[], Properties)", anArgv, someProperties);
        theCORBAManager = new CORBAManager(anArgv, someProperties);
    }

    public static synchronized void init(Applet anApplet, Properties someProperties) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, MalformedURLException, IOException {
        Trace.enter(CORBAManager.class, "init(Applet, Properties)", anApplet, someProperties);
        theCORBAManager = new CORBAManager(anApplet, someProperties);
    }

    protected CORBAManager(String[] anArgv, Properties someProperties) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, MalformedURLException, IOException {
        Trace.enter(CORBAManager.class, "init(String[], Properties)", anArgv, someProperties);
        this.orb = this.initORB(anArgv, null, someProperties);
        String url = EmasSystemProperties.getProperty(NC_IOR_URL_PROPERTY);
        if (url == null) {
            url = DEFAULT_NC_IOR_URL;
        }
        URL url2IORFile = new URL(url);
        this.rootContext = new NamingContext(url2IORFile);
    }

    protected CORBAManager(Applet anApplet, Properties someProperties) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, MalformedURLException, IOException {
        Trace.enter(CORBAManager.class, "CORBAManager(Applet, Properties)", anApplet, someProperties);
        this.orb = this.initORB(null, anApplet, someProperties);
        String path2IORFile = anApplet.getParameter(NC_IOR_PARAM);
        if (path2IORFile.charAt(0) == '/') {
            path2IORFile = path2IORFile.substring(1);
        }
        URL url2IORFile = new URL(anApplet.getCodeBase() + path2IORFile);
        this.rootContext = new NamingContext(url2IORFile);
    }

    protected ORB initORB(String[] anArgv, Applet anApplet, Properties someProperties) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Trace.enter(CORBAManager.class, "initORB(String[], Applet, Properties)", anArgv, anApplet, someProperties);
        Test test = Test.getInstance();
        String initializerClassName = test.getProperty(INITIALIZER_PROPERTY);
        ORB orb = initializerClassName == null ? EmasFramework.getORB() : this.dynamicInitORB(initializerClassName, anArgv, anApplet, someProperties);
        Trace.msg(CORBAManager.class, "initORB(String[], Applet, Properties)", "orb == " + orb);
        if (orb == null) {
            orb = anArgv == null ? ORB.init((Applet)anApplet, (Properties)someProperties) : ORB.init((String[])anArgv, (Properties)someProperties);
            EmasFramework.setORB(orb);
        }
        Trace.exit(CORBAManager.class, "initORB(String[], Applet, Properties)", orb);
        return orb;
    }

    protected ORB dynamicInitORB(String aClassName, String[] anArgv, Applet anApplet, Properties someProperties) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Trace.enter(CORBAManager.class, "dynamicInitORB(String, String[], Applet, Properties)", aClassName, anArgv, anApplet, someProperties);
        Class<?> initializerClass = Class.forName(aClassName);
        Class[] signature = new Class[]{anArgv == null ? Applet.class : String[].class, Properties.class};
        Method initializer = initializerClass.getMethod("init", signature);
        java.lang.Object[] args = new java.lang.Object[]{anArgv == null ? anApplet : anArgv, someProperties};
        ORB orb = (ORB)initializer.invoke(null, args);
        Trace.exit(CORBAManager.class, "dynamicInitORB(String, String[], Applet, Properties)", orb);
        return orb;
    }

    public class NamingContext {
        public static final String DELIMITER = ",";
        private org.omg.CosNaming.NamingContext context;

        public Object resolveObject(String aName) throws IllegalArgumentException, RemoteObjectManagerException {
            Trace.enter(NamingContext.class, "resolveObject(String)", aName);
            StringTokenizer tokenizer = new StringTokenizer(aName, DELIMITER);
            int nTokens = tokenizer.countTokens();
            if (nTokens == 0) {
                throw new IllegalArgumentException("aName is null or empty");
            }
            NameComponent[] nameSequence = new NameComponent[nTokens];
            for (int i = 0; i < nTokens; ++i) {
                NameComponent nameComponent;
                String namePart = tokenizer.nextToken();
                nameSequence[i] = nameComponent = new NameComponent(namePart, "");
            }
            Object object = null;
            try {
                object = this.context.resolve(nameSequence);
            }
            catch (InvalidName e) {
                throw ExceptionHandler.map(e, "");
            }
            catch (CannotProceed e) {
                throw ExceptionHandler.map(e, "");
            }
            catch (NotFound e) {
                throw ExceptionHandler.map(e, "");
            }
            return object;
        }

        public NamingContext resolveContext(String aName) throws RemoteObjectManagerException {
            Trace.enter(NamingContext.class, "resolveContext(String)", aName);
            Object resolvedObject = this.resolveObject(aName);
            org.omg.CosNaming.NamingContext resolvedContext = NamingContextHelper.narrow((Object)resolvedObject);
            return new NamingContext(resolvedContext);
        }

        protected NamingContext(org.omg.CosNaming.NamingContext aContext) {
            Trace.enter(NamingContext.class, "resolveContext(org.omg.CosNaming.NamingContext)", aContext);
            this.context = aContext;
        }

        protected NamingContext(URL aContext) throws IOException {
            Trace.enter(NamingContext.class, "resolveContext(URL)", aContext);
            BufferedReader br = new BufferedReader(new InputStreamReader(aContext.openStream()));
            String ior = br.readLine();
            br.close();
            Trace.msg(NamingContext.class, "resolveContext(URL)", "ior == " + (ior == null ? "null" : ior));
            this.context = NamingContextHelper.narrow((Object)CORBAManager.this.orb.string_to_object(ior));
        }
    }
}

