/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.util.StringTokenizer;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.SwAllocationReservable;
import se.ericsson.cello.managedelement.SystemFunctionsMoImpl;
import se.ericsson.cello.managedelement.WebServerMo;
import se.ericsson.cello.managedelement.WebServerPathConfigurationException;
import se.ericsson.cello.managedelement.WebServerReserver;
import se.ericsson.cello.managedelement.fropxy.OsaHttpsProxy;
import se.ericsson.cello.managedelement.suaccess.WebServerMoSU_Access;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedByOtherUserException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.util.library.Lib;

public class WebServerMoImpl
extends ManagedObjectBase
implements WebServerMo,
WebServerMoSU_Access,
SwAllocationReservable {
    private MoData data;
    private static String myWebServerIdentifier = "1";
    private static String myUserLabel = "";
    private static WebServerMoImpl instance = null;
    private static int HTTPSFRO_MAX_PATH_LEN = 10000;
    private static final String WEB_SERVER_PATHS = "webServerPaths";
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1"};
    private StringAttribute userLabel;
    private StringAttribute webServerPaths;
    private SequenceAttribute reservedBySwAllocation;
    private static final int MO_DATA_REVISION_3006 = 3006;
    private static final int MO_DATA_REVISION_LATEST = 3006;

    public static synchronized WebServerMoImpl instance() {
        UpgradeTrace.debug((Class)WebServerMoImpl.class, (int)70, (String)"instance()");
        if (instance == null) {
            try {
                instance = new WebServerMoImpl();
            }
            catch (MoAccessException moAccessException) {
                UpgradeTrace.error((Class)WebServerMoImpl.class, (String)"instance()", (String)"Exception caught when trying to create a singleton instance of Mo WebServerMoImpl.", (Throwable)moAccessException);
            }
        }
        return instance;
    }

    private WebServerMoImpl() throws MoAccessException {
        super((ManagedObject)SystemFunctionsMoImpl.instance(), "WebServer", myWebServerIdentifier, null);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"WebServerMoImpl()");
        ServiceLocatorFacade.getRepository().addService((Object)this, WebServerMoSU_Access.class, null);
    }

    void recover(MoData moData) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"recover(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, this);
        moDataRecoveryHelper.assertMoDataRevision(3006);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(WEB_SERVER_PATHS);
        moDataRecoveryHelper.assertAttribute("reservedBySwAllocation");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.webServerPaths = (StringAttribute)moData.getAttribute(WEB_SERVER_PATHS);
        this.reservedBySwAllocation = (SequenceAttribute)moData.getAttribute("reservedBySwAllocation");
    }

    public synchronized void registerData() {
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"registerData()", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
                this.data = new MoData(this.getLocalDistinguishedName(), "WebServer", true, coordinator);
                this.userLabel = new StringAttribute("userLabel", true, myUserLabel);
                this.data.registerPersistentAttr((Attribute)this.userLabel);
                this.webServerPaths = new StringAttribute(WEB_SERVER_PATHS, false, "");
                this.data.registerPersistentAttr((Attribute)this.webServerPaths);
                this.reservedBySwAllocation = new SequenceAttribute("reservedBySwAllocation", true);
                this.data.registerPersistentAttr((Attribute)this.reservedBySwAllocation);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                this.data.setRevision(3006);
                control.getTerminator().commit();
            }
            catch (Throwable throwable) {
                UpgradeTrace.warning(this.getClass(), (String)"registerData()", (String)("Start of WebServer failed, throwable caught.\n\tThrowable: " + throwable));
            }
        }
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        throw new UndeletableMoException((ManagedObject)this);
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public ManagedObject getReservedSwAllocationMo(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedSwAllocationMo(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        ManagedObject managedObject = null;
        ManagedObject[] managedObjectArray = this.getReservedBySwAllocation(coordinator);
        if (managedObjectArray.length > 0) {
            managedObject = managedObjectArray[0];
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"getReservedSwAllocationMo(Coordinator aCoordinator)", (String)("RETURNING theManagedObject: " + managedObject));
        return managedObject;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"String aValue, Coordinator aCoordinator", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"WebServer", (int)128, (int)0);
        this.checkTransaction(coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getWebServerId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getWebServerId(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        return myWebServerIdentifier;
    }

    public String getWebServerPaths(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getWebServerPaths(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.webServerPaths.getValue(coordinator);
    }

    public int getWebServerPathSize(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getWebServerPathSize(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getWebServerPaths(null), ":");
        return stringTokenizer.countTokens();
    }

    private void setWebServerPaths(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setWebServerPaths(String aWebServerPaths, Coordinator aCoordinator)", (String)("aWebServerPaths: " + string + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.checkTransaction(coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.sendWebServerPathToHttpServerLM(string, coordinator);
        this.webServerPaths.setValue(string);
    }

    public void setWebServerPathsFromSU(String string, Coordinator coordinator) throws MoAccessException {
        this.setWebServerPaths(string, coordinator);
    }

    public ManagedObject[] getReservedBySwAllocation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedBySwAllocation(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedBySwAllocation.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[attributeArray.length];
        ReferenceAttribute referenceAttribute = null;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            referenceAttribute = (ReferenceAttribute)attributeArray[i];
            managedObjectArray[i] = referenceAttribute.getValue(coordinator);
        }
        UpgradeTrace.debug(this.getClass(), (int)71, (String)"getReservedBySwAllocation(Coordinator aCoordinator)", (String)("RETURNING theSwAllocationArray: " + Lib.toString((ManagedObject[])managedObjectArray)));
        return managedObjectArray;
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve(ManagedObject aSwAllocationMo, Coordinator aCoordinator)", (String)("aSwAllocationMo: " + managedObject + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        if (!(managedObject instanceof WebServerReserver)) {
            throw new InvalidReferenceException("WebServer", (Object)managedObject);
        }
        ManagedObject[] managedObjectArray = this.getReservedBySwAllocation(coordinator);
        if (managedObjectArray.length > 0 && !managedObject.equals(managedObjectArray[0])) {
            throw new MoReservedByOtherUserException(managedObject.getLocalDistinguishedName(), this.getLocalDistinguishedName(), managedObjectArray[0].getLocalDistinguishedName());
        }
        this.reservedBySwAllocation = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"WebServer", (MoData)this.data, (SequenceAttribute)this.reservedBySwAllocation);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"release( ManagedObject aSwAllocationMo, Coordinator aCoordinator )", (String)("aSwAllocationMo: " + managedObject + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.reservedBySwAllocation = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"WebServer", (MoData)this.data, (SequenceAttribute)this.reservedBySwAllocation);
    }

    public String getType() {
        return "WebServer";
    }

    private void sendWebServerPathToHttpServerLM(String string, Coordinator coordinator) throws WebServerPathConfigurationException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"sendWebServerPathToHttpServerLM ( String aWebServerPaths, Coordinator aCoordinator )", (String)("aWebServerPaths: " + string + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        try {
            long l = new Integer(coordinator.getTransactionID()).longValue();
            byte[] byArray = MaoFroTypeConverter.string2byteArray((String)string, (int)HTTPSFRO_MAX_PATH_LEN);
            int n = OsaHttpsProxy.instance().sendOsaHttpsSetWebPathsReq(l, byArray);
            this.checkResult(n, string, coordinator);
        }
        catch (WebServerPathConfigurationException webServerPathConfigurationException) {
            throw webServerPathConfigurationException;
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"sendWebServerPathToHttpServerLM ( String aWebServerPaths, Coordinator aCoordinator )", (String)("Exception caught during setting of the WebServer root path.\n\tException: " + exception));
            throw new WebServerPathConfigurationException("Failed to add the requested WebServer paths '" + string + "to the default root path. The reason for the failure is (from exception) '" + exception.getMessage() + "'.");
        }
    }

    private void checkResult(int n, String string, Coordinator coordinator) throws WebServerPathConfigurationException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"checkResult ( int aResult, String aWebServerPaths, Coordinator aCoordinator )", (String)("aResult: " + n + "\n\taWebServerPaths: " + string + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        String string2 = "Unknown";
        if (n == 0) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"checkResult ( int aResult, String aWebServerPaths, Coordinator aCoordinator )", (String)"Result OK");
            return;
        }
        if (n == 1) {
            string2 = "HTTPS initiation error";
        } else if (n == 2) {
            string2 = "HTTPS content error";
        } else if (n == 3) {
            string2 = "HTTP realm error";
        } else if (n == 4) {
            string2 = "HTTPS file error";
        } else if (n == 5) {
            string2 = "HTTPS conf error";
        } else if (n == 6) {
            string2 = "HTTPS tran error";
        } else if (n == 7) {
            string2 = "HTTPS DB error";
        } else if (n == 8) {
            string2 = "HTTPS no service error";
        }
        UpgradeTrace.error(this.getClass(), (String)"checkResult ( int aResult, Coordinator aCoordinator )", (String)("Failed to add the requested WebServer paths '" + string + " to the default root path. The reason for the failure is '" + string2 + "'."));
        throw new WebServerPathConfigurationException("Failed to add the requested WebServer paths '" + string + " to the default root path. The reason for the failure is '" + string2 + "'.");
    }

    private void checkTransaction(Coordinator coordinator) throws TransactionRequiredException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"checkTransaction ( Coordinator aCoordinator )", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        if (coordinator == null) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"checkTransaction ( Coordinator aCoordinator )", (String)"Received transaction not valid.\n\taCoordinator: null ");
            throw new TransactionRequiredException();
        }
        if (coordinator.getStatus() != Status.ACTIVE) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"checkTransaction ( Coordinator aCoordinator )", (String)("Received transaction has not valid status (shall be ACTIVE).\n\tStatus of transaction: " + coordinator.getStatus()));
            throw new TransactionRequiredException();
        }
    }
}

