/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmpms;

import java.util.Arrays;

public class PmMeasuredInstantData {
    private final long[][] m_measurements;
    private final Exception m_exception;

    public PmMeasuredInstantData(long[][] measurements, Exception exception) {
        this.m_measurements = measurements;
        this.m_exception = exception;
    }

    public long[][] getMeasurements() {
        return this.m_measurements;
    }

    public Exception getException() {
        return this.m_exception;
    }

    public int[][] toPmiResultSet() {
        if (this.m_measurements == null) {
            return null;
        }
        int[][] convertedMeasurements = new int[this.m_measurements.length][];
        for (int i = 0; i < this.m_measurements.length; ++i) {
            convertedMeasurements[i] = new int[this.m_measurements[i].length];
            for (int j = 0; j < this.m_measurements[i].length; ++j) {
                convertedMeasurements[i][j] = (int)this.m_measurements[i][j];
            }
        }
        return convertedMeasurements;
    }

    public boolean equals(Object obj) {
        boolean equalMeasurements = false;
        boolean equalExceptions = false;
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PmMeasuredInstantData measuredInstantData = (PmMeasuredInstantData)obj;
        Exception measuredInstantDataException = measuredInstantData.getException();
        if (measuredInstantDataException == this.m_exception) {
            equalExceptions = true;
        } else if (measuredInstantDataException != null && this.m_exception != null) {
            equalExceptions = measuredInstantData.getException().getClass() == this.m_exception.getClass();
        }
        long[][] measurements = measuredInstantData.getMeasurements();
        if (measurements == this.m_measurements) {
            equalMeasurements = true;
        } else if (measurements != null && this.m_measurements != null && measurements.length == this.m_measurements.length) {
            equalMeasurements = true;
            for (int i = 0; i < measurements.length; ++i) {
                equalMeasurements = equalMeasurements && Arrays.equals(measurements[i], this.m_measurements[i]);
            }
        }
        return equalExceptions && equalMeasurements;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.m_exception == null ? 0 : this.m_exception.hashCode());
        if (this.m_measurements != null) {
            for (int i = 0; i < this.m_measurements.length; ++i) {
                for (int j = 0; j < this.m_measurements[i].length; ++j) {
                    hash = 31 * hash + (int)(this.m_measurements[i][j] ^ this.m_measurements[i][j] >>> 32);
                }
            }
        } else {
            hash = 31 * hash + 0;
        }
        return hash;
    }
}

