/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmpms;

import se.ericsson.cello.pms.generic.BasicScanner;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.pmapplication.PmThreadSwitcherI;
import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.cat.pmcommon.PmBaseState;
import se.ericsson.crbs.cat.pmcommon.PmClassCounter;
import se.ericsson.crbs.cat.pmpms.PmScannerI;
import se.ericsson.crbs.logging.AbstractLogger;

public class PmScanner
extends BasicScanner
implements PmScannerI {
    private final Class THIS_CLASS = this.getClass();
    private final AbstractLogger logger = PmBase.getLogger(this.THIS_CLASS.getName());
    private final int m_scannerId;
    private final PmClassCounter[] m_activeCounters;
    private final PmThreadSwitcherI m_threadSwitcher;
    private final Callback m_callback;
    private State m_state = State.Setup_Initial;

    public PmScanner(GranularityPeriod gp, PerformanceMonitoringState state, DataConsumer destination, String measurementName, ObservationClass[] ocList, Coordinator coordinator, int scannerId, PmThreadSwitcherI threadSwitcher, Callback callback) {
        super(gp, state, destination, measurementName, coordinator);
        if (PerformanceMonitoringState.ACTIVE == state) {
            this.general("Created activated Scanner with ScannerId: " + scannerId);
        } else {
            this.general("Created suspended Scanner with ScannerId: " + scannerId);
        }
        this.m_scannerId = scannerId;
        this.m_threadSwitcher = threadSwitcher;
        this.m_callback = callback;
        this.m_activeCounters = new PmClassCounter[ocList.length];
        for (int moClassIdx = 0; moClassIdx < ocList.length; ++moClassIdx) {
            String[] counterNameList = ocList[moClassIdx].class_attribute_list;
            PmClassCounter.PmCounter[] counters = new PmClassCounter.PmCounter[counterNameList.length];
            for (int counterIdx = 0; counterIdx < counterNameList.length; ++counterIdx) {
                counters[counterIdx] = new PmClassCounter.PmCounter(counterNameList[counterIdx]);
            }
            this.m_activeCounters[moClassIdx] = new PmClassCounter(ocList[moClassIdx].object_class_name, counters);
        }
        boolean isActive = PerformanceMonitoringState.ACTIVE == state;
        this.m_state = isActive ? State.Running_IsActivated : State.Running_None;
        this.m_threadSwitcher.executeInMainThread(new AddScannerRunnable());
    }

    public boolean isActivated() {
        int state = this.m_state.toInt();
        return state >= State.Running_IsActivated.toInt() && state <= State.Running_IsActivatedAndEnabled.toInt();
    }

    public boolean isActivatedAndEnabled() {
        return this.m_state.equals(State.Running_IsActivatedAndEnabled);
    }

    public void init() {
        this.enter("init");
        this.general("End of (incomplete) ROP for ScannerId: " + this.m_scannerId);
        if (this.isActivated()) {
            this.m_threadSwitcher.executeInMainThread(new ReportRunnable(false, this.getSeqNo()));
        }
    }

    public void scan() {
        this.enter("scan");
        this.general("End of ROP sequence number: " + this.getSeqNo());
        if (this.isActivated()) {
            boolean isJustActivated = this.m_state.equals(State.Running_IsActivated);
            this.m_threadSwitcher.executeInMainThread(new ReportRunnable(isJustActivated, this.getSeqNo()));
            if (isJustActivated) {
                this.general("First ROP counters enabled for ScannerId: " + this.m_scannerId);
                this.m_state = State.Running_IsActivatedAndEnabled;
            }
        }
    }

    public void setScannerState(PerformanceMonitoringState state, Coordinator coordinator) throws OverloadException, GranularityAndAttributeActivationException {
        boolean isActive;
        this.enter("setScannerState");
        super.setScannerState(state, coordinator);
        boolean bl = isActive = PerformanceMonitoringState.ACTIVE == state;
        if (this.isActivated() == isActive) {
            return;
        }
        if (this.isActivated()) {
            this.general("Suspend Scanner with ScannerId: " + this.m_scannerId);
            this.m_state = State.Running_None;
            this.m_threadSwitcher.executeInMainThread(new DeactivateRunnable());
        } else {
            this.general("Activate Scanner with ScannerId: " + this.m_scannerId);
            this.m_state = State.Running_IsActivated;
            this.m_threadSwitcher.executeInMainThread(new ActivateRunnable());
        }
    }

    public void delete(Coordinator coordinator) {
        this.enter("delete");
        super.delete(coordinator);
        if (this.isActivated()) {
            this.general("Delete activated Scanner with ScannerId: " + this.m_scannerId);
            this.m_state = State.Running_None;
            this.m_threadSwitcher.executeInMainThread(new DeactivateRunnable());
            this.m_threadSwitcher.executeInMainThread(new RemoveScannerRunnable());
        } else {
            this.general("Delete suspended Scanner with ScannerId: " + this.m_scannerId);
            this.m_threadSwitcher.executeInMainThread(new RemoveScannerRunnable());
        }
    }

    public int getScannerId() {
        this.enter("getScannerId");
        return this.m_scannerId;
    }

    public PmClassCounter[] getActiveCounters() {
        this.enter("getActiveCounters");
        if (this.getScannerState() == PerformanceMonitoringState.ACTIVE) {
            return this.m_activeCounters;
        }
        return new PmClassCounter[0];
    }

    public void enter(String msg) {
        this.logger.traceEnter(this.THIS_CLASS, msg);
    }

    public void info(String msg) {
        this.logger.info(this.THIS_CLASS, msg);
    }

    public void debug(String msg) {
        this.logger.traceDebug(this.THIS_CLASS, msg);
    }

    public void general(String msg) {
        this.logger.traceGeneral(this.THIS_CLASS, msg);
    }

    public static class State
    extends PmBaseState {
        public static final State Setup_Initial = new State(0x600100);
        public static final State Running_Begin = new State(0x600200);
        public static final State Running_None = new State(0x600200);
        public static final State Running_IsActivated = new State(6291984);
        public static final State Running_IsActivatedAndEnabled = new State(0x600220);
        public static final State Running_End = new State(0x600800);
        public static final State Terminated_Fault = new State(0x60FFFF);

        public State(int state) {
            super(state);
        }
    }

    public static interface Callback {
        public boolean scanner_addScannerEvent(PmScannerI var1, PmClassCounter[] var2, boolean var3);

        public boolean scanner_removeScannerEvent(int var1);

        public boolean scanner_reportScannerEvent(PmScanner var1, DataConsumer var2, boolean var3, int var4, PmClassCounter[] var5);

        public boolean scanner_activateCountersEvent(PmScanner var1, PmClassCounter[] var2);

        public boolean scanner_deactivateCountersEvent(PmClassCounter[] var1);
    }

    public class ReportRunnable
    implements Runnable {
        private final boolean m_enableCounters;
        private final int m_seqNo;

        public ReportRunnable(boolean enableCounters, int seqNo) {
            this.m_enableCounters = enableCounters;
            this.m_seqNo = seqNo;
        }

        public void run() {
            PmScanner.this.enter("ReportRunnable.run");
            PmScanner.this.m_callback.scanner_reportScannerEvent(PmScanner.this, PmScanner.this.destination, this.m_enableCounters, this.m_seqNo, PmScanner.this.m_activeCounters);
        }
    }

    public class DeactivateRunnable
    implements Runnable {
        public void run() {
            PmScanner.this.enter("DeactivateRunnable.run");
            PmScanner.this.m_callback.scanner_deactivateCountersEvent(PmScanner.this.m_activeCounters);
        }
    }

    public class ActivateRunnable
    implements Runnable {
        public void run() {
            PmScanner.this.enter("ActivateRunnable.run");
            PmScanner.this.m_callback.scanner_activateCountersEvent(PmScanner.this, PmScanner.this.m_activeCounters);
        }
    }

    public class RemoveScannerRunnable
    implements Runnable {
        public void run() {
            PmScanner.this.enter("RemoveScannerRunnable.run");
            PmScanner.this.m_callback.scanner_removeScannerEvent(PmScanner.this.getScannerId());
        }
    }

    public class AddScannerRunnable
    implements Runnable {
        public void run() {
            PmScanner.this.enter("AddScannerRunnable.run");
            PmScanner.this.m_callback.scanner_addScannerEvent(PmScanner.this, PmScanner.this.m_activeCounters, PmScanner.this.isActivated());
        }
    }
}

