/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmpms;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;

public class PmStatPredefinedScannerItem {
    private GranularityPeriod granularityPeriod;
    private String measurementName = null;
    private final List observationClasses = new ArrayList();
    private final ObservationObject[] observationObjects = new ObservationObject[0];
    private PerformanceMonitoringState state = null;

    public void setGranularityPeriod(GranularityPeriod inputGranularityPeriod) {
        this.granularityPeriod = inputGranularityPeriod;
    }

    public GranularityPeriod getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public void setMeasurementName(String inputMeasurementName) {
        this.measurementName = inputMeasurementName;
    }

    public String getMeasurementName() {
        return this.measurementName;
    }

    public void setState(PerformanceMonitoringState inputState) {
        this.state = inputState;
    }

    public PerformanceMonitoringState getState() {
        return this.state;
    }

    public void addObservationClass(ObservationClass observationClass) {
        this.observationClasses.add(observationClass);
    }

    public ObservationClass[] getObservationClasses() {
        ObservationClass[] obsClasses = new ObservationClass[this.observationClasses.size()];
        for (int i = 0; i < this.observationClasses.size(); ++i) {
            ObservationClass obsClass;
            obsClasses[i] = obsClass = (ObservationClass)this.observationClasses.get(i);
        }
        return obsClasses;
    }

    public ObservationObject[] getObservationObjects() {
        return this.observationObjects;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(300);
        buffer.append("\nPre-defined Scanner definition:");
        buffer.append("\n  MeasurementName = ").append(this.getMeasurementName());
        buffer.append("\n  Observation classes =");
        ObservationClass[] obsclasses = this.getObservationClasses();
        for (int i = 0; i < obsclasses.length; ++i) {
            buffer.append("\n    ").append(obsclasses[i].object_class_name);
            buffer.append(" (");
            for (int j = 0; j < obsclasses[i].class_attribute_list.length; ++j) {
                buffer.append(obsclasses[i].class_attribute_list[j]);
                if (j >= obsclasses[i].class_attribute_list.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(')');
        }
        buffer.append("\n  Granularityperiod = ").append(this.getGranularityPeriod().inSeconds());
        if (this.state != null) {
            String stateStr = this.state.equals(PerformanceMonitoringState.ACTIVE) ? "ACTIVE" : "SUSPENDED";
            buffer.append("\n  State = ").append(stateStr);
        }
        return buffer.toString();
    }
}

