/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.mao.AlarmHandler;
import se.ericsson.cello.mao.GenPmMaoHandler;
import se.ericsson.cello.mao.MaoPmLegacyStrategy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericFaultCeasedInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericFaultInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericMomDefinedEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericMomDefinedFaultCeaseInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericMomDefinedFaultInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.ManagedObject_v2;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.pmapp.ExtendedMoTypeHandler;
import se.ericsson.cello.pmapp.GenPmMao;
import se.ericsson.cello.pmapp.ObjectLifeCycleEvent;
import se.ericsson.cello.pmapp.PmAppException;
import se.ericsson.cello.pmapp.PmAppPortal;
import se.ericsson.cello.pmapp.PmAppPortalImpl;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxy;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxyException;
import se.ericsson.cello.pmapp.fropxy.Mo2FroIdTranslator;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public abstract class CelloMao
extends ManagedObjectBase
implements MaoFroIndicationSubscriber,
GenPmMao,
ManagedObject_v2 {
    protected PmAppPortal myPmAppPortal = PmAppPortalImpl.create();
    private GenPmMaoHandler myPmHandler = new MaoPmLegacyStrategy((ManagedObject)this, this.myPmAppPortal);
    public static final int PM_COUNTER_NOT_AVAILABLE = -1;

    protected CelloMao(ManagedObject managedObject, String string, String string2, Coordinator coordinator) throws MoNameAlreadyTakenException {
        super(managedObject, string, string2, coordinator);
        if (coordinator != null && this.myPmAppPortal.hasGenericPmProxy(string)) {
            new ObjectLifeCycleEvent(PmAppPortalImpl.create().getMoLifeCycleListener(), (ManagedObject)this, true, 0, coordinator);
        }
    }

    protected CelloMao(ManagedObject managedObject, String string, String string2, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        super(managedObject, string, string2, coordinator, initialMaoContext);
        if (coordinator != null && this.myPmAppPortal.hasGenericPmProxy(string)) {
            new ObjectLifeCycleEvent(PmAppPortalImpl.create().getMoLifeCycleListener(), (ManagedObject)this, true, 0, coordinator);
        }
    }

    protected CelloMao(String string) throws MoNameAlreadyTakenException {
        super(string);
    }

    protected CelloMao(String string, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        super(string, initialMaoContext);
    }

    public synchronized void alarmRaised(MaoFroGenericFaultInd maoFroGenericFaultInd, String string) {
        try {
            AlarmHandler.addGenericAlarm(maoFroGenericFaultInd.getParameters(TagNameDictionaries.getDefault()), maoFroGenericFaultInd.getSpecificProblem(), maoFroGenericFaultInd.getFroId(), maoFroGenericFaultInd.getFroType(), maoFroGenericFaultInd.isSecondary(), (ManagedObject)this, string);
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)("Unexepected exception :" + exception + ", alarm discarded  mo :" + this));
        }
    }

    public synchronized void alarmRaised(MaoFroGenericMomDefinedFaultInd maoFroGenericMomDefinedFaultInd, String string) {
        try {
            AlarmHandler.addGenericAlarmNoMapping(maoFroGenericMomDefinedFaultInd.getParameters(TagNameDictionaries.getDefault()), maoFroGenericMomDefinedFaultInd.getAlarmId(), maoFroGenericMomDefinedFaultInd.getFroId(), maoFroGenericMomDefinedFaultInd.isSecondary(), (ManagedObject)this, string);
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)("Unexepected exception :" + exception + ", alarm discarded  mo :" + this));
        }
    }

    public void alarmCeased(MaoFroGenericFaultCeasedInd maoFroGenericFaultCeasedInd) {
        AlarmHandler.clearGenericAlarm(maoFroGenericFaultCeasedInd.getSpecificProblem(), maoFroGenericFaultCeasedInd.getFroType(), (ManagedObject)this);
    }

    public void alarmCeased(MaoFroGenericMomDefinedFaultCeaseInd maoFroGenericMomDefinedFaultCeaseInd) {
        AlarmHandler.clearGenericAlarmNoMapping(maoFroGenericMomDefinedFaultCeaseInd.getAlarmId(), (ManagedObject)this);
    }

    public void ceaseAllAlarms(String string) {
        AlarmManager.getReporter().ceaseAlarmsForService(string);
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        MessageLog.traceError(this.getClass(), (String)("Event not handled :" + maoFroGenericEventInd + " mo :" + this));
    }

    public void eventRaised(MaoFroGenericMomDefinedEventInd maoFroGenericMomDefinedEventInd) {
        try {
            Map map = maoFroGenericMomDefinedEventInd.getParameters(TagNameDictionaries.getDefault());
            StringParameter stringParameter = (StringParameter)map.get("additionalText");
            String string = "";
            if (stringParameter != null) {
                string = stringParameter.getValue();
            }
            AlarmManager.getReporter().reportEvent(maoFroGenericMomDefinedEventInd.getEventId(), (ManagedObject)this, "", string, null);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        SignedIntParameter signedIntParameter = null;
        try {
            signedIntParameter = (SignedIntParameter)maoFroGenericParameterChdInd.getParameters(TagNameDictionaries.getDefault()).get("administrativeState");
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Unable to translate parameters in indication signal", (Throwable)moAccessException);
        }
        if (signedIntParameter != null) {
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[1];
            Integer n = new Integer(signedIntParameter.getValue());
            objectArray[0] = n;
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
        }
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException, PmAppException {
        return this.myPmHandler.getCurrentPmRegister(coordinator);
    }

    protected String[] getPmAttrInStringFormat(String string, Coordinator coordinator) throws GenericPmFroProxyException, NoSuchAttributeException, MoAccessException {
        int n = -1;
        String string2 = null;
        String[] stringArray = null;
        GenericPmFroProxy genericPmFroProxy = null;
        Map map = ExtendedMoTypeHandler.getMoTypeMap();
        List list = (List)map.get(this.getType());
        if (list.size() > 1) {
            boolean bl = true;
            block0: for (int i = 0; i < list.size() && bl; ++i) {
                string2 = (String)list.get(i);
                genericPmFroProxy = this.myPmAppPortal.getGenericPmFroProxyFactory().lookupByMoType(string2);
                if (genericPmFroProxy == null) continue;
                String[] stringArray2 = genericPmFroProxy.getPmAttributeNames();
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!string.equals(stringArray2[j])) continue;
                    bl = false;
                    continue block0;
                }
            }
            if (bl) {
                throw new NoSuchAttributeException(string, this.getType());
            }
            n = Mo2FroIdTranslator.getFroId((ManagedObject)this, string2);
            stringArray = genericPmFroProxy.getCurrentPmRegister(n);
        } else {
            stringArray = this.getCurrentPmRegister(coordinator);
        }
        return stringArray;
    }

    protected int getPmAttribute(String string, Coordinator coordinator) throws MoAccessException, PmAppException, NoSuchAttributeException {
        try {
            String[] stringArray = this.getPmAttrInStringFormat(string, coordinator);
            return this.getPmIntAttributeValue(string, stringArray);
        }
        catch (GenericPmFroProxyException genericPmFroProxyException) {
            MessageLog.trace((int)5, this.getClass(), (String)"GenericPmFroProxyException caught, returning PM_COUNTER_NOT_AVAILABLE (-1)");
            return -1;
        }
    }

    protected long getPmLongAttribute(String string, Coordinator coordinator) throws MoAccessException, PmAppException, NoSuchAttributeException {
        try {
            String[] stringArray = this.getPmAttrInStringFormat(string, coordinator);
            return this.getPmLongAttributeValue(string, stringArray);
        }
        catch (GenericPmFroProxyException genericPmFroProxyException) {
            MessageLog.trace((int)5, this.getClass(), (String)"GenericPmFroProxyException caught, returning PM_COUNTER_NOT_AVAILABLE (-1)");
            return -1L;
        }
    }

    protected int[] getPmIntArrayAttribute(String string, Coordinator coordinator) throws MoAccessException, PmAppException, NoSuchAttributeException {
        String[] stringArray = this.getCurrentPmRegister(coordinator);
        return this.getPmIntArrayAttributeValue(string, stringArray);
    }

    protected long[] getPmLongArrayAttribute(String string, Coordinator coordinator) throws MoAccessException, PmAppException, NoSuchAttributeException {
        String[] stringArray = this.getCurrentPmRegister(coordinator);
        return this.getPmLongArrayAttributeValue(string, stringArray);
    }

    protected int getPmIntAttributeValue(String string, String[] stringArray) throws NoSuchAttributeException {
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("=");
            String string2 = stringArray[i].substring(0, n).trim();
            if (!string2.equals(string)) continue;
            return Integer.parseInt(stringArray[i].substring(n + 1, stringArray[i].length()));
        }
        throw new NoSuchAttributeException(string, this.getType());
    }

    protected long getPmLongAttributeValue(String string, String[] stringArray) throws NoSuchAttributeException {
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("=");
            String string2 = stringArray[i].substring(0, n).trim();
            if (!string2.equals(string)) continue;
            return Long.parseLong(stringArray[i].substring(n + 1, stringArray[i].length()));
        }
        throw new NoSuchAttributeException(string, this.getType());
    }

    protected int[] getPmIntArrayAttributeValue(String string, String[] stringArray) throws NoSuchAttributeException {
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("=");
            String string2 = stringArray[i].substring(0, n).trim();
            if (!string2.equalsIgnoreCase(string)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i].substring(n + 1, stringArray[i].length()), " ");
            int[] nArray = new int[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            return nArray;
        }
        throw new NoSuchAttributeException(string, this.getType());
    }

    protected long[] getPmLongArrayAttributeValue(String string, String[] stringArray) throws NoSuchAttributeException {
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("=");
            String string2 = stringArray[i].substring(0, n).trim();
            if (!string2.equalsIgnoreCase(string)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i].substring(n + 1, stringArray[i].length()), " ");
            long[] lArray = new long[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                lArray[n2] = Long.parseLong(stringTokenizer.nextToken());
                ++n2;
            }
            return lArray;
        }
        throw new NoSuchAttributeException(string, this.getType());
    }

    public int getPmFroId(String string, Coordinator coordinator) throws MoAccessException {
        return this.myPmHandler.getPmFroId(string, coordinator);
    }

    public int getFroId(Coordinator coordinator) throws PmAppException, MoAccessException {
        return this.myPmHandler.getFroId(coordinator);
    }

    public boolean getCounterActivation(Coordinator coordinator) throws PmAppException, MoAccessException {
        return this.myPmHandler.getCounterActivation(coordinator);
    }

    public void setInstanceCounterActivation(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.myPmHandler.setInstanceCounterActivation(bl, coordinator);
    }

    public void setPdfCounterActivation(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.myPmHandler.setPdfCounterActivation(bl, coordinator);
    }

    public boolean hasPdfActivationAttribute() throws MoAccessException {
        return this.myPmHandler.hasPdfActivationAttribute();
    }

    public boolean hasCounterActivationAttribute() throws MoAccessException {
        return this.myPmHandler.hasCounterActivationAttribute();
    }

    protected void setPmHandler(GenPmMaoHandler genPmMaoHandler) {
        this.myPmHandler = genPmMaoHandler;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return super.getType();
    }
}

