/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.mao.GenPmMaoHandler;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.pmapp.ExtendedMoTypeHandler;
import se.ericsson.cello.pmapp.GenPmMao;
import se.ericsson.cello.pmapp.ObjectLifeCycleEvent;
import se.ericsson.cello.pmapp.PmAppException;
import se.ericsson.cello.pmapp.PmAppPortal;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxy;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxyException;
import se.ericsson.cello.pmapp.fropxy.Mo2FroIdTranslator;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class MaoPmLegacyStrategy
implements GenPmMaoHandler {
    private ManagedObject theMao;
    private PmAppPortal thePmAppPortalRef;

    public MaoPmLegacyStrategy(ManagedObject managedObject, PmAppPortal pmAppPortal) {
        if (!(managedObject instanceof GenPmMao)) {
            throw new IllegalStateException("The " + (managedObject == null ? "NULL" : managedObject.getType()) + " MO does not support Generic PM");
        }
        this.theMao = managedObject;
        this.thePmAppPortalRef = pmAppPortal;
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException, PmAppException {
        Map map = ExtendedMoTypeHandler.getMoTypeMap();
        List list = (List)map.get(this.theMao.getType());
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n = -1;
        String string = null;
        for (int i = 0; i < list.size(); ++i) {
            n = Mo2FroIdTranslator.getFroId(this.theMao, (String)list.get(i));
            GenericPmFroProxy genericPmFroProxy = this.thePmAppPortalRef.getGenericPmFroProxyFactory().lookupByMoType((String)list.get(i));
            if (genericPmFroProxy != null) {
                try {
                    String[] stringArray = genericPmFroProxy.getCurrentPmRegister(n);
                    arrayList.add(i, stringArray);
                }
                catch (GenericPmFroProxyException genericPmFroProxyException) {
                    String[] stringArray = genericPmFroProxy.translate2PmTags(genericPmFroProxy.getPmAttributeNames());
                    String[] stringArray2 = new String[stringArray.length];
                    for (int j = 0; j < stringArray.length; ++j) {
                        stringArray2[j] = genericPmFroProxy.getDictionary().lookupKey(stringArray[j]) + "=" + -1;
                    }
                    arrayList.add(i, stringArray2);
                    string = genericPmFroProxyException.getMessage();
                }
                continue;
            }
            throw new PmAppException("Pm fro proxy could not be looked up for mo type = " + this.theMao.getType());
        }
        if (string != null) {
            MessageLog.trace((int)5, this.getClass(), string);
        }
        return ExtendedMoTypeHandler.mergeAttributes(arrayList);
    }

    public int getPmFroId(String string, Coordinator coordinator) throws MoAccessException {
        return ((GenPmMao)this.theMao).getFroId(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws PmAppException, MoAccessException {
        throw new PmAppException("Mo type " + this.theMao.getType() + " does not implement method getFroId");
    }

    public boolean getCounterActivation(Coordinator coordinator) throws PmAppException, MoAccessException {
        throw new PmAppException(this.theMao.getType());
    }

    public void setInstanceCounterActivation(boolean bl, Coordinator coordinator) {
        new ObjectLifeCycleEvent(this.thePmAppPortalRef.getMoLifeCycleListener(), this.theMao, bl, 1, coordinator);
    }

    public void setPdfCounterActivation(boolean bl, Coordinator coordinator) {
        new ObjectLifeCycleEvent(this.thePmAppPortalRef.getMoLifeCycleListener(), this.theMao, bl, 2, coordinator);
    }

    public boolean hasCounterActivationAttribute() throws MoAccessException {
        return false;
    }

    public boolean hasPdfActivationAttribute() throws MoAccessException {
        return false;
    }
}

