/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

public class Revision
implements Comparable {
    private String revision;

    public Revision(String string) {
        this.revision = string;
    }

    public String toString() {
        return this.revision;
    }

    public boolean equals(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Revision revision = null;
        if (object instanceof Revision) {
            revision = (Revision)object;
        } else if (object instanceof String) {
            revision = new Revision(object.toString());
        } else {
            throw new ClassCastException();
        }
        return this.compareTo(revision) == 0;
    }

    public int compareTo(Object object) throws ClassCastException, NullPointerException {
        if (object == null) {
            throw new NullPointerException();
        }
        Revision revision = null;
        if (object instanceof Revision) {
            revision = (Revision)object;
        } else if (object instanceof String) {
            revision = new Revision((String)object);
        } else {
            throw new ClassCastException();
        }
        int n = this.getMajorRevision();
        int n2 = revision.getMajorRevision();
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        int n3 = Revision.compareMinorStrings(this.getMinorRevision(), revision.getMinorRevision());
        if (n3 != 0) {
            return n3;
        }
        int n4 = Revision.compareSuffixes(this.getSuffix(), revision.getSuffix());
        return n4;
    }

    public int getMajorRevision() {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < this.revision.length() && Character.isDigit(c = this.revision.charAt(i)); ++i) {
            stringBuffer.append(c);
        }
        String string = stringBuffer.toString();
        return Integer.parseInt(string);
    }

    public String getMinorRevision() {
        char c;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 1; n < this.revision.length() && !Character.isLetter(this.revision.charAt(n)); ++n) {
        }
        while (n < this.revision.length() && Character.isLetter(c = this.revision.charAt(n))) {
            stringBuffer.append(c);
            ++n;
        }
        String string = stringBuffer.toString();
        return string;
    }

    public String getSuffix() {
        int n;
        for (n = 1; n < this.revision.length() && !Character.isLetter(this.revision.charAt(n)); ++n) {
        }
        while (n < this.revision.length() && Character.isLetter(this.revision.charAt(n))) {
            ++n;
        }
        if (n < this.revision.length()) {
            return this.revision.substring(n);
        }
        return "";
    }

    public static int compareMinorStrings(String string, String string2) {
        if (string.length() > string2.length()) {
            return 1;
        }
        if (string.length() < string2.length()) {
            return -1;
        }
        return string.compareTo(string2);
    }

    public static int compareSuffixes(String string, String string2) {
        int n;
        boolean bl = "".equals(string);
        boolean bl2 = "".equals(string2);
        if (bl && bl2) {
            return 0;
        }
        if (bl != bl2) {
            return bl ? -1 : 1;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (string.startsWith("/")) {
            bl3 = true;
            string = string.substring(1);
        }
        if (string2.startsWith("/")) {
            bl4 = true;
            string2 = string2.substring(1);
        }
        if (bl3 != bl4) {
            return bl3 ? 1 : -1;
        }
        int n2 = Integer.parseInt(string);
        if (n2 > (n = Integer.parseInt(string2))) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.revision.hashCode();
    }
}

