/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.TransactionHelperImpl;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.pmapp.CelloScanner;
import se.ericsson.cello.pmapp.ExtendedMoTypeHandler;
import se.ericsson.cello.pmapp.GenPmMao;
import se.ericsson.cello.pmapp.MiAttributeHandler;
import se.ericsson.cello.pmapp.fropxy.CelloMaoFroPmDataStruct;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxy;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxyException;
import se.ericsson.cello.pmapp.fropxy.Mo2FroIdTranslator;
import se.ericsson.cello.pmapp.fropxy.PmIndicationEvent;
import se.ericsson.cello.pmapp.fropxy.PmrRecoveryProxy;
import se.ericsson.cello.pmreporter.PmReporterAdmin;
import se.ericsson.cello.pmreporter.PmReporterFactory;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.PerformanceMgmntService;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmReporterRecoveryHandler;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;

public class ProxyAdapter
implements ActionListener,
PmReporterRecoveryHandler {
    private boolean silent = false;
    private static final int RETRY_INTERVAL = 2000;
    private static final int MAX_NO_OF_RETRIES = 10;
    private static final int TX_TIMEOUT = 60;
    private static final int RETRY_INTERVAL_TRANSACTION_CREATE = 500;
    private static final int MAX_NO_OF_RETRIES_TRANSACTION_CREATE = 20;
    private CelloScanner celloScanner;
    private GenericPmFroProxy proxy;
    private GranularityPeriod gp;
    private Set attributes = new HashSet();
    private MiAttributeHandler miHandler = null;
    private String obsClass;
    private Set obsInstances;
    private boolean sendSubscribe;
    private Map fro2MoMap = new HashMap();

    ProxyAdapter(CelloScanner celloScanner, GenericPmFroProxy genericPmFroProxy, GranularityPeriod granularityPeriod) {
        this.setProxy(genericPmFroProxy);
        this.celloScanner = celloScanner;
        this.gp = granularityPeriod;
        this.addActionListener(this);
        if (PerformanceMgmntService.getHighCapacityPMEnabled() == 1) {
            try {
                Class.forName("se.ericsson.cello.pmreporter.PmReporterFactory");
                PmReporterAdmin pmReporterAdmin = PmReporterFactory.create();
                pmReporterAdmin.registerPmReporterRecoveryHandler((PmReporterRecoveryHandler)this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                MessageLog.traceError(this.getClass(), (String)"Cannot find se.ericsson.cello.pmreporter.PmReporterFactory even though HighCapacityPMEnabled id true");
            }
        }
    }

    void validate() throws GenericPmFroProxyException {
        this.getProxy().translate2PmTags(this.getAttributes());
    }

    void subscribe(Coordinator coordinator, boolean bl) {
        this.silent = bl;
        this.subscribe(coordinator);
    }

    void subscribe(Coordinator coordinator) {
        String[] stringArray;
        int[] nArray = this.getFroIds();
        this.mapFroIdToMo(nArray);
        String[] stringArray2 = this.filterAttributes(this.getAttributes(), false);
        if (stringArray2 != null && stringArray2.length != 0) {
            this.miHandler = new MiAttributeHandler(stringArray2);
        }
        if (PerformanceMgmntService.getHighCapacityPMEnabled() == 1 && PerformanceMgmntService.getNodeKpiEnabled() == 1 && this.silent) {
            stringArray = this.filterAttributes(this.getAttributes(), true);
            this.getProxy().pmKpiCounterSubscribe(coordinator, this.gp.inSeconds(), stringArray);
        }
        if (this.getProxy().isSessionCreated()) {
            if (nArray != null && nArray.length != 0) {
                stringArray = (String[])this.getActivatedPdfFroIds(nArray);
                String[] stringArray3 = this.filterAttributes(this.getAttributes(), true);
                String[] stringArray4 = this.getProxy().getPdfCounterNames(stringArray3);
                String[] stringArray5 = this.getProxy().getOrdinaryCounterNames(stringArray3);
                if (stringArray != null) {
                    if (stringArray4 != null && stringArray4.length != 0) {
                        this.getProxy().pmSubscribe(coordinator, this.gp.inSeconds(), (int[])stringArray, stringArray4, this.getLdns((int[])stringArray), this.silent);
                    }
                    if (stringArray5 != null && stringArray5.length != 0) {
                        this.getProxy().pmSubscribe(coordinator, this.gp.inSeconds(), nArray, stringArray5, this.getLdns(nArray), this.silent);
                    }
                } else if (this.hasPdfActivation(nArray)) {
                    if (stringArray5 != null && stringArray5.length != 0) {
                        this.getProxy().pmSubscribe(coordinator, this.gp.inSeconds(), nArray, stringArray5, this.getLdns(nArray), this.silent);
                    }
                } else {
                    this.getProxy().pmSubscribe(coordinator, this.gp.inSeconds(), nArray, stringArray3, this.getLdns(nArray), this.silent);
                }
                this.sendSubscribe = false;
            }
        } else {
            this.sendSubscribe = true;
        }
    }

    void unsubscribe(Coordinator coordinator) {
        String[] stringArray;
        this.miHandler = null;
        int[] nArray = this.getFroIds();
        if (PerformanceMgmntService.getHighCapacityPMEnabled() == 1 && PerformanceMgmntService.getNodeKpiEnabled() == 1 && this.silent) {
            stringArray = this.filterAttributes(this.getAttributes(), true);
            this.getProxy().pmKpiCounterUnSubscribe(coordinator, this.gp.inSeconds(), stringArray);
        }
        if (this.getProxy().isSessionCreated()) {
            if (nArray != null && nArray.length != 0) {
                stringArray = (String[])this.getActivatedPdfFroIds(nArray);
                String[] stringArray2 = this.filterAttributes(this.getAttributes(), true);
                String[] stringArray3 = this.getProxy().getPdfCounterNames(stringArray2);
                String[] stringArray4 = this.getProxy().getOrdinaryCounterNames(stringArray2);
                if (stringArray != null) {
                    if (stringArray3 != null && stringArray3.length != 0) {
                        this.getProxy().pmUnsubscribe(coordinator, this.gp.inSeconds(), (int[])stringArray, stringArray3, this.silent);
                    }
                    if (stringArray4 != null && stringArray4.length != 0) {
                        this.getProxy().pmUnsubscribe(coordinator, this.gp.inSeconds(), nArray, stringArray4, this.silent);
                    }
                } else if (this.hasPdfActivation(nArray)) {
                    if (stringArray4 != null && stringArray4.length != 0) {
                        this.getProxy().pmUnsubscribe(coordinator, this.gp.inSeconds(), nArray, stringArray4, this.silent);
                    }
                } else {
                    this.getProxy().pmUnsubscribe(coordinator, this.gp.inSeconds(), nArray, stringArray2, this.silent);
                }
            }
        } else {
            this.sendSubscribe = false;
        }
    }

    public void performPmrRecovery() {
        int[] nArray = this.getFroIds();
        this.mapFroIdToMo(nArray);
        if (nArray != null && nArray.length != 0) {
            int[] nArray2 = this.getActivatedPdfFroIds(nArray);
            String[] stringArray = this.filterAttributes(this.getAttributes(), true);
            String[] stringArray2 = this.getProxy().getPdfCounterNames(stringArray);
            String[] stringArray3 = this.getProxy().getOrdinaryCounterNames(stringArray);
            if (nArray2 != null) {
                if (stringArray2 != null && stringArray2.length != 0) {
                    ((PmrRecoveryProxy)((Object)this.getProxy())).recoverPmrData(this.gp.inSeconds(), nArray2, stringArray2, this.getLdns(nArray2), this.silent);
                }
                if (stringArray3 != null && stringArray3.length != 0) {
                    ((PmrRecoveryProxy)((Object)this.getProxy())).recoverPmrData(this.gp.inSeconds(), nArray, stringArray3, this.getLdns(nArray), this.silent);
                }
            } else if (this.hasPdfActivation(nArray)) {
                if (stringArray3 != null && stringArray3.length != 0) {
                    ((PmrRecoveryProxy)((Object)this.getProxy())).recoverPmrData(this.gp.inSeconds(), nArray, stringArray3, this.getLdns(nArray), this.silent);
                }
            } else {
                ((PmrRecoveryProxy)((Object)this.getProxy())).recoverPmrData(this.gp.inSeconds(), nArray, stringArray, this.getLdns(nArray), this.silent);
            }
        }
    }

    void subscribeUpdateMoCreation(int n, ManagedObject managedObject) {
        MessageLog.trace((int)5, this.getClass(), (String)("subscribeUpdateMoCreation: mo = " + managedObject.getLocalDistinguishedName()));
        try {
            if (this.obsClass != null || this.obsInstances.contains(managedObject.getLocalDistinguishedName())) {
                this.addFroId(n, managedObject);
                if (((GenPmMao)managedObject).hasPdfActivationAttribute()) {
                    this.updatePdfAtCreation(n, managedObject);
                } else if (((GenPmMao)managedObject).hasCounterActivationAttribute()) {
                    if (this.celloScanner.isActivated(managedObject)) {
                        this.updateFro(n, managedObject, this.getAttributes(), true);
                    }
                } else {
                    this.updateFro(n, managedObject, this.getAttributes(), true);
                }
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"subscribeUpdateMoCreation()", (Throwable)moAccessException);
        }
    }

    private void updatePdfAtCreation(int n, ManagedObject managedObject) {
        String[] stringArray = this.getAttributes();
        String[] stringArray2 = this.getProxy().getPdfCounterNames(stringArray);
        String[] stringArray3 = this.getProxy().getOrdinaryCounterNames(stringArray);
        if (this.celloScanner.isActivated(managedObject)) {
            if (stringArray2 != null && stringArray2.length != 0) {
                this.updateFro(n, managedObject, stringArray2, true);
            }
            if (stringArray3 != null && stringArray3.length != 0) {
                this.updateFro(n, managedObject, stringArray3, true);
            }
        } else if (stringArray3 != null && stringArray3.length != 0) {
            this.updateFro(n, managedObject, stringArray3, true);
        }
    }

    void subscribeUpdatePdfActivation(int n, ManagedObject managedObject) {
        MessageLog.trace((int)5, this.getClass(), (String)("subscribeUpdatePdfActivation: mo = " + managedObject.getLocalDistinguishedName()));
        if (this.obsInstances != null && this.getMo(n) == null) {
            return;
        }
        try {
            if (((GenPmMao)managedObject).hasPdfActivationAttribute()) {
                String[] stringArray = this.getProxy().getPdfCounterNames(this.getAttributes());
                if (stringArray != null && stringArray.length != 0) {
                    this.updateFro(n, managedObject, stringArray, true);
                }
            } else {
                MessageLog.info(this.getClass(), (String)("subscribeUpdatePdfActivation(): No PDF activation attribute for MO " + managedObject.getType()));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"subscribeUpdateCounterActivation()", (Throwable)moAccessException);
        }
    }

    void subscribeUpdateCounterActivation(int n, ManagedObject managedObject) {
        MessageLog.trace((int)5, this.getClass(), (String)("subscribeUpdateCounterActivation: mo = " + managedObject.getLocalDistinguishedName()));
        try {
            if (((GenPmMao)managedObject).hasCounterActivationAttribute() && this.obsClass != null) {
                this.addFroId(n, managedObject);
                this.updateFro(n, managedObject, this.getAttributes(), true);
            } else {
                MessageLog.info(this.getClass(), (String)("subscribeUpdateCounterActivation(): No counterActivation attribute for MO" + managedObject.getType()));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"subscribeUpdateCounterActivation()", (Throwable)moAccessException);
        }
    }

    void unsubscribeUpdatePdfActivation(int n, ManagedObject managedObject) {
        MessageLog.trace((int)5, this.getClass(), (String)("unsubscribeUpdatePdfActivation: mo = " + managedObject.getLocalDistinguishedName()));
        if (this.obsInstances != null && this.getMo(n) == null) {
            return;
        }
        try {
            if (((GenPmMao)managedObject).hasPdfActivationAttribute()) {
                String[] stringArray = this.getProxy().getPdfCounterNames(this.getAttributes());
                if (stringArray != null && stringArray.length != 0) {
                    this.updateFro(n, managedObject, stringArray, false);
                } else {
                    MessageLog.info(this.getClass(), (String)("unsubscribeUpdatePdfActivation: No PDF activation attribute for MO " + managedObject.getType()));
                }
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"unsubscribeUpdatePdfActivation()", (Throwable)moAccessException);
        }
    }

    void unsubscribeUpdateCounterActivation(int n, ManagedObject managedObject) {
        MessageLog.trace((int)5, this.getClass(), (String)("unsubscribeUpdateCounterActivation: mo = " + managedObject.getLocalDistinguishedName()));
        try {
            if (((GenPmMao)managedObject).hasCounterActivationAttribute() && this.obsClass != null) {
                this.updateFro(n, managedObject, this.getAttributes(), false);
            } else {
                MessageLog.info(this.getClass(), (String)("unsubscribeUpdateCounterActivation: No counterActivation attribute for MO " + managedObject.getType()));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"unsubscribeUpdateCounterActivation()", (Throwable)moAccessException);
        }
    }

    private void updateFro(int n, ManagedObject managedObject, String[] stringArray, boolean bl) {
        if (n < -1 && !this.getProxy().isSessionCreated()) {
            MessageLog.info(this.getClass(), (String)("PM FRO is not supported on this type node/network for this MO " + managedObject.getType()));
            return;
        }
        Control control = ProxyAdapter.createTx();
        Coordinator coordinator = control.getCoordinator();
        try {
            if (bl) {
                int[] nArray = new int[]{n};
                this.getProxy().pmSubscribe(coordinator, this.gp.inSeconds(), nArray, stringArray, this.getLdns(nArray), this.silent);
            } else {
                this.getProxy().pmUnsubscribe(coordinator, this.gp.inSeconds(), new int[]{n}, stringArray, this.silent);
            }
            control.getTerminator().commit();
        }
        catch (GenericPmFroProxyException genericPmFroProxyException) {
            MessageLog.traceError(this.getClass(), (String)"Method updateFro() generated a runtime exception.", (Throwable)genericPmFroProxyException);
            try {
                control.getTerminator().rollback();
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"rollback failed - inactive", (Throwable)inactiveTransactionException);
            }
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)"sessionCreated() commit failed - rollback", (Throwable)transactionRolledBackException);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"commit failed - inactive", (Throwable)inactiveTransactionException);
        }
    }

    private void mapFroIdToMo(int[] nArray) {
        if (this.obsClass != null) {
            this.mapClass(nArray);
        } else {
            this.mapInstances(nArray);
        }
    }

    private void mapInstances(int[] nArray) {
        Iterator iterator = this.obsInstances.iterator();
        try {
            GenPmMao genPmMao = null;
            String string = null;
            String string2 = null;
            ManagedObject managedObject = null;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof String)) {
                    throw new IllegalArgumentException("Bad type in Set.");
                }
                string = (String)e;
                string2 = Mo2FroIdTranslator.extractMoTypeFromDistinguishedName(string);
                String string3 = ExtendedMoTypeHandler.extractMoTypefromMoTypeExtended(string2);
                String string4 = ExtendedMoTypeHandler.replaceMoTypeinDistinguishedName(string3, string);
                managedObject = MoRepository.instance().lookup(string4);
                genPmMao = (GenPmMao)managedObject;
                if (genPmMao == null) {
                    MessageLog.info(this.getClass(), (String)("mapFroIdToMo(): DN='" + string + "' does not exist."));
                    continue;
                }
                if (managedObject.isCreated()) {
                    int n = genPmMao.getPmFroId(string2, null);
                    for (int i = 0; i < nArray.length; ++i) {
                        if (n != nArray[i]) continue;
                        this.addFroId(n, managedObject);
                    }
                    continue;
                }
                MessageLog.info((String)("Instance Mo with LDN " + managedObject.getLocalDistinguishedName() + " is NOT created"));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"mapFroIdToMo()", (Throwable)moAccessException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void mapClass(int[] nArray) {
        String string = ExtendedMoTypeHandler.extractMoTypefromMoTypeExtended(this.obsClass);
        MoIterator moIterator = MoRepository.instance().lookupType(string);
        if (moIterator == null) {
            return;
        }
        try {
            block2: while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                GenPmMao genPmMao = (GenPmMao)managedObject;
                if (managedObject.isCreated()) {
                    int n = genPmMao.getPmFroId(this.obsClass, null);
                    int n2 = 0;
                    while (true) {
                        if (n2 >= nArray.length) continue block2;
                        if (n == nArray[n2]) {
                            this.addFroId(n, managedObject);
                        }
                        ++n2;
                    }
                }
                MessageLog.info((String)("Class Mo with LDN " + managedObject.getLocalDistinguishedName() + " is NOT created"));
            }
            return;
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"mapFroIdToMo()", (Throwable)moAccessException);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            MessageLog.trace((int)5, this.getClass(), (String)("actionPerformed(): actionEvent.getID()=" + actionEvent.getID()));
            if (actionEvent.getID() == 100 || actionEvent.getID() == 107 || actionEvent.getID() == 104 || actionEvent.getID() == 106 || actionEvent.getID() == 101 || actionEvent.getID() == 103) {
                return;
            }
            if (actionEvent.getID() == 110) {
                if (this.celloScanner.getScannerState().equals(PerformanceMonitoringState.SUSPENDED)) {
                    return;
                }
                this.sendSubscribe = true;
                return;
            }
            if (actionEvent.getID() == 109) {
                this.sessionCreated();
                return;
            }
            MessageLog.traceError(this.getClass(), (String)("Received unknown event: " + actionEvent.getSource()));
            return;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"Method actionPerformed() generated a runtime exception.", (Throwable)runtimeException);
            return;
        }
    }

    void addActionListener(ActionListener actionListener) {
        this.getProxy().addActionEventListener(actionListener);
    }

    void removeActionListener(ActionListener actionListener) {
        this.getProxy().removeActionEventListener(actionListener);
        this.getProxy().removeActionEventListener(this);
    }

    public String toString() {
        return this.getClass().getName() + ": obsClass=" + this.obsClass + ", obsInstances=" + this.obsInstances + ", attributes=" + this.attributes + ", proxy=" + this.proxy;
    }

    private int[] getFroIds() {
        if (this.obsClass != null) {
            return Mo2FroIdTranslator.getFroIds(this.obsClass);
        }
        if (this.obsInstances != null) {
            return Mo2FroIdTranslator.getFroIds(this.obsInstances);
        }
        return new int[0];
    }

    public String[] filterAttributes(String[] stringArray, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                int n;
                if (stringArray[i].startsWith("pm") && bl) {
                    String string = this.proxy.getDictionary().lookupValue(stringArray[i]);
                    int n2 = string.indexOf(":");
                    if (n2 == -1) {
                        if (new Integer(string) >= 10000) continue;
                        arrayList.add(stringArray[i]);
                        continue;
                    }
                    arrayList.add(stringArray[i]);
                    continue;
                }
                if (stringArray[i].startsWith("pm") || bl || (n = this.proxy.getDictionary().lookupTag(stringArray[i])) < 10000) continue;
                arrayList.add(stringArray[i]);
                continue;
            }
            catch (TagNameDictionaryException tagNameDictionaryException) {
                throw new GenericPmFroProxyException(103, 22, tagNameDictionaryException.toString());
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    MiAttributeHandler getMiAttributeHandler() {
        return this.miHandler;
    }

    void setObservationClass(String string) {
        this.obsClass = string;
        this.obsInstances = null;
    }

    void addObservationInstance(String string) {
        if (this.obsClass != null) {
            return;
        }
        if (this.obsInstances == null) {
            this.obsInstances = new HashSet();
        }
        this.obsInstances.add(string);
    }

    ObservationClass[] getObservationClasses() {
        String[] stringArray = this.getProxy().getMoTypes();
        ObservationClass[] observationClassArray = new ObservationClass[stringArray.length];
        String[] stringArray2 = this.getAttributes();
        for (int i = 0; i < stringArray.length; ++i) {
            observationClassArray[i] = new ObservationClass(stringArray[i], stringArray2);
        }
        return observationClassArray;
    }

    void addAttributes(String[] stringArray) {
        this.attributes.addAll(Arrays.asList(stringArray));
    }

    void scan() {
        PmIndicationEvent pmIndicationEvent;
        if (PerformanceMgmntService.getHighCapacityPMEnabled() == 1 && this.miHandler != null) {
            MessageLog.trace((int)5, this.getClass(), (String)"scan():Create event to trigger non_pm attribute retrieval");
            pmIndicationEvent = this.createPmIndicationEventForHighCapPM();
            this.celloScanner.handleHighCapacityPmIndication(pmIndicationEvent);
        }
        MessageLog.trace((int)5, this.getClass(), (String)("scan(): proxyAdapter expects data soon! for froType:" + this.getProxy().getFroType()));
        if (!this.getProxy().isSessionCreated()) {
            if (this.isPMFroSupported()) {
                MessageLog.trace((int)5, this.getClass(), (String)("scan():no session send default for froType:" + this.getProxy().getFroType()));
                pmIndicationEvent = this.buildDefaultPmData();
                this.celloScanner.handlePmIndication(pmIndicationEvent);
            } else {
                MessageLog.trace((int)5, this.getClass(), (String)("scan():no session and not supported pm fro, send pm fro not supported pm data for froType:" + this.getProxy().getFroType()));
                pmIndicationEvent = this.buildFroNotSupportedPmData();
                this.celloScanner.handlePmIndication(pmIndicationEvent);
            }
        }
    }

    PmIndicationEvent buildDefaultPmData() {
        return this.createPmIndicationEvent(-1, true);
    }

    void rollbackAdapter() {
        if (this.sendSubscribe) {
            this.sendSubscribe = false;
        }
    }

    void sessionCreated() {
        int n = 0;
        boolean bl = true;
        if (this.sendSubscribe) {
            Control control = null;
            Coordinator coordinator = null;
            while (bl) {
                ++n;
                try {
                    control = ProxyAdapter.createTx();
                    coordinator = control.getCoordinator();
                    this.subscribe(coordinator);
                    control.getTerminator().commit();
                    bl = false;
                }
                catch (GenericPmFroProxyException genericPmFroProxyException) {
                    try {
                        control.getTerminator().rollback();
                    }
                    catch (InactiveTransactionException inactiveTransactionException) {
                        MessageLog.info((Class)(class$se$ericsson$cello$pmapp$ProxyAdapter == null ? ProxyAdapter.class$("se.ericsson.cello.pmapp.ProxyAdapter") : class$se$ericsson$cello$pmapp$ProxyAdapter), (String)"rollback failed - InactiveTransaction");
                    }
                    if (!this.maxTriesReached(n, genericPmFroProxyException)) {
                        this.tryLater();
                        continue;
                    }
                    bl = false;
                    this.sendSubscribe = false;
                    MessageLog.traceError(this.getClass(), (String)"Method subscribe(c)called from sessionCreated() generated a runtime exception.", (Throwable)genericPmFroProxyException);
                }
                catch (TransactionRolledBackException transactionRolledBackException) {
                    if (!this.maxTriesReached(n, (Exception)((Object)transactionRolledBackException))) {
                        this.tryLater();
                        continue;
                    }
                    bl = false;
                    MessageLog.traceError((Class)(class$se$ericsson$cello$pmapp$ProxyAdapter == null ? ProxyAdapter.class$("se.ericsson.cello.pmapp.ProxyAdapter") : class$se$ericsson$cello$pmapp$ProxyAdapter), (String)"sessionCreated() commit failed - rollback", (Throwable)transactionRolledBackException);
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    if (!this.maxTriesReached(n, (Exception)((Object)inactiveTransactionException))) {
                        this.tryLater();
                        continue;
                    }
                    bl = false;
                    MessageLog.traceError((Class)(class$se$ericsson$cello$pmapp$ProxyAdapter == null ? ProxyAdapter.class$("se.ericsson.cello.pmapp.ProxyAdapter") : class$se$ericsson$cello$pmapp$ProxyAdapter), (String)"commit failed - inactive", (Throwable)inactiveTransactionException);
                }
                this.sendSubscribe = false;
            }
        }
    }

    private boolean maxTriesReached(int n, Exception exception) {
        if (n < 10) {
            if (n == 1 || n % 5 == 0) {
                MessageLog.info(this.getClass(), (String)("Failed to connect to transaction server due to " + exception.getMessage() + ", trying again..."));
            }
            return false;
        }
        return true;
    }

    private void tryLater() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            MessageLog.traceError(this.getClass(), (String)"Thread interupted", (Throwable)interruptedException);
        }
    }

    private static Control createTx() {
        try {
            Control control = TransactionHelperImpl.instance().createTransactionWithTimeOut(500, 20, 60);
            return control;
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)CelloScanner.class, (String)"Transaction", (Throwable)exception);
            throw new RuntimeException("Failed createTransaction in Celloscanner.proxyAdapter.");
        }
    }

    public String[] getAttributes() {
        String[] stringArray = new String[this.attributes.size()];
        this.attributes.toArray(stringArray);
        return stringArray;
    }

    public GenericPmFroProxy getProxy() {
        return this.proxy;
    }

    private void setProxy(GenericPmFroProxy genericPmFroProxy) {
        this.proxy = genericPmFroProxy;
    }

    private int[] getActivatedPdfFroIds(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                ManagedObject managedObject = this.getMo(nArray[i]);
                if (managedObject == null || !((GenPmMao)managedObject).hasPdfActivationAttribute() || !this.celloScanner.isActivated(managedObject)) continue;
                arrayList.add(new Integer(nArray[i]));
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            int[] nArray2 = new int[arrayList.size()];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = (Integer)arrayList.get(i);
            }
            return nArray2;
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError((Class)ProxyAdapter.class, (String)"getActivatedPdfFroIds()", (Throwable)moAccessException);
            return null;
        }
    }

    private boolean hasPdfActivation(int[] nArray) {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                ManagedObject managedObject = this.getMo(nArray[i]);
                if (managedObject == null || !((GenPmMao)managedObject).hasPdfActivationAttribute()) continue;
                return true;
            }
            return false;
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError((Class)ProxyAdapter.class, (String)"hasPdfActivation()", (Throwable)moAccessException);
            return false;
        }
    }

    private String[] getLdns(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            ManagedObject managedObject = (ManagedObject)this.fro2MoMap.get(new Integer(nArray[i]));
            if (managedObject == null) {
                return null;
            }
            stringArray[i] = managedObject.getLocalDistinguishedName();
        }
        return stringArray;
    }

    private void addFroId(int n, ManagedObject managedObject) {
        this.fro2MoMap.put(new Integer(n), managedObject);
        MessageLog.trace((int)5, this.getClass(), (String)("addFroId: froId=" + n + ", LDN=" + managedObject.getLocalDistinguishedName()));
    }

    public ManagedObject getMo(int n) {
        return (ManagedObject)this.fro2MoMap.get(new Integer(n));
    }

    private boolean isPMFroSupported() {
        if (this.fro2MoMap.size() >= 1) {
            Object[] objectArray = this.fro2MoMap.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if ((Integer)objectArray[i] < -1) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    PmIndicationEvent buildFroNotSupportedPmData() {
        return this.createPmIndicationEvent(-2, false);
    }

    private PmIndicationEvent createPmIndicationEvent(int n, boolean bl) {
        int n2;
        int n3 = 0;
        String[] stringArray = this.getProxy().getPmAttributeNames();
        List list = this.getProxy().getNoOfValuesPerAttribute(stringArray);
        for (int i = 0; i < list.size(); ++i) {
            n3 += ((Integer)list.get(i)).intValue();
        }
        long[] lArray = new long[n3];
        for (n2 = 0; n2 < lArray.length; ++n2) {
            lArray[n2] = n;
        }
        n2 = this.getProxy().getFroType();
        int n4 = MaoFroTypeConverter.boolean2int(bl);
        PmIndicationEvent pmIndicationEvent = new PmIndicationEvent(this.getProxy());
        int[] nArray = this.obsClass != null ? Mo2FroIdTranslator.getFroIds(this.obsClass) : Mo2FroIdTranslator.getFroIds(this.obsInstances);
        for (int i = 0; i < nArray.length; ++i) {
            CelloMaoFroPmDataStruct celloMaoFroPmDataStruct = new CelloMaoFroPmDataStruct(n2, nArray[i], n4, lArray);
            pmIndicationEvent.addPmData(celloMaoFroPmDataStruct);
        }
        return pmIndicationEvent;
    }

    private PmIndicationEvent createPmIndicationEventForHighCapPM() {
        this.filterAttributes(this.getAttributes(), false);
        int n = this.getProxy().getFroType();
        PmIndicationEvent pmIndicationEvent = new PmIndicationEvent(this.getProxy());
        int[] nArray = this.obsClass != null ? Mo2FroIdTranslator.getFroIds(this.obsClass) : Mo2FroIdTranslator.getFroIds(this.obsInstances);
        for (int i = 0; i < nArray.length; ++i) {
            CelloMaoFroPmDataStruct celloMaoFroPmDataStruct = new CelloMaoFroPmDataStruct(n, nArray[i]);
            pmIndicationEvent.addPmData(celloMaoFroPmDataStruct);
        }
        return pmIndicationEvent;
    }
}

