/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp.fropxy;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.support.debug.MessageLog;

public class CelloMaoFroPmDataStruct {
    private int froType;
    private int froId;
    private int suspectFlag;
    private int noOfPmAttr;
    private long[] pmAttrList;
    private boolean readIntArr = true;

    protected CelloMaoFroPmDataStruct(SignalInputStream signalInputStream, UnlinkedSignal unlinkedSignal) throws IOException {
        if (unlinkedSignal.getSigNo() == 721100 || unlinkedSignal.getSigNo() == 721098 || unlinkedSignal.getSigNo() == 721104) {
            this.readIntArr = false;
        }
        this.receive(signalInputStream);
    }

    public CelloMaoFroPmDataStruct(int n, int n2) {
        this.froId = n2;
        this.froType = n;
        this.pmAttrList = new long[0];
    }

    public CelloMaoFroPmDataStruct(int n, int n2, int n3, long[] lArray) {
        this.froType = n;
        this.froId = n2;
        this.suspectFlag = n3;
        this.pmAttrList = lArray;
    }

    private void receive(SignalInputStream signalInputStream) throws IOException {
        Object[] objectArray;
        if (!this.readIntArr) {
            signalInputStream.align(8);
        }
        this.froType = (int)signalInputStream.readU32();
        MessageLog.trace((int)2, this.getClass(), (String)("cello..dataStruct receive frotype = " + this.froType));
        this.froId = (int)signalInputStream.readU32();
        MessageLog.trace((int)2, this.getClass(), (String)("cello..dataStruct receive froId = " + this.froId));
        this.suspectFlag = (int)signalInputStream.readU32();
        MessageLog.trace((int)5, this.getClass(), (String)("cello..dataStruct receive suspectFlag = " + this.suspectFlag));
        this.noOfPmAttr = (int)signalInputStream.readU32();
        MessageLog.trace((int)5, this.getClass(), (String)("cello..dataStruct receive noOfPmAttr= " + this.noOfPmAttr));
        if (this.readIntArr) {
            objectArray = signalInputStream.readS32Array(this.noOfPmAttr);
            this.pmAttrList = this.convertIntToLongArray((int[])objectArray);
        } else {
            objectArray = new long[this.noOfPmAttr];
            for (int i = 0; i < this.noOfPmAttr; ++i) {
                objectArray[i] = signalInputStream.readS64();
            }
            this.pmAttrList = objectArray;
        }
        for (int i = 0; i < this.pmAttrList.length; ++i) {
            MessageLog.trace((int)5, this.getClass(), (String)(" cello..dataStruct receive pmAttrList[" + i + "] = " + this.pmAttrList[i]));
        }
    }

    protected void send(SignalOutputStream signalOutputStream) throws IOException {
        signalOutputStream.writeU32((long)this.froType);
        MessageLog.trace((int)2, this.getClass(), (String)("cello..dataStruct send frotype = " + this.froType));
        signalOutputStream.writeU32((long)this.froId);
        MessageLog.trace((int)2, this.getClass(), (String)("cello..dataStruct send froId = " + this.froId));
        signalOutputStream.writeU32((long)this.suspectFlag);
        MessageLog.trace((int)5, this.getClass(), (String)("cello..dataStruct send suspectFlag = " + this.suspectFlag));
        signalOutputStream.writeU32((long)this.pmAttrList.length);
        MessageLog.trace((int)5, this.getClass(), (String)("cello..dataStruct send pmAttrList.length = " + this.pmAttrList.length));
        for (int i = 0; i < this.pmAttrList.length; ++i) {
            MessageLog.trace((int)5, this.getClass(), (String)(" cello..dataStruct  pmAttrList[" + i + "] = " + this.pmAttrList[i]));
        }
        signalOutputStream.writeS32Array(this.convertLongToIntArray(this.pmAttrList));
    }

    private long[] convertIntToLongArray(int[] nArray) {
        long[] lArray = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }

    private int[] convertLongToIntArray(long[] lArray) {
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    public int getFroId() {
        return this.froId;
    }

    public int getFroType() {
        return this.froType;
    }

    public long[] getPmAttrList() {
        return this.pmAttrList;
    }

    public boolean getSuspectFlag() {
        return MaoFroTypeConverter.int2boolean(this.suspectFlag);
    }

    public int getNoOfPmAttr() {
        return this.noOfPmAttr;
    }

    public void setNoOfPmAttr(int n) {
        this.noOfPmAttr = n;
    }
}

