/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp.fropxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.common.fropxy.CmaPmPortManager;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.pmapp.fropxy.CelloMaoFroPmDataStruct;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxy;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxyFactory;
import se.ericsson.cello.pmapp.fropxy.MaoFroPm64AgentAck;
import se.ericsson.cello.pmapp.fropxy.MaoFroPm64AgentInd;
import se.ericsson.cello.pmapp.fropxy.MaoFroPm64AgentSplitAck;
import se.ericsson.cello.pmapp.fropxy.MaoFroPm64AgentSplitInd;
import se.ericsson.cello.pmapp.fropxy.MaoFroPmAgentAck;
import se.ericsson.cello.pmapp.fropxy.MaoFroPmAgentInd;
import se.ericsson.cello.pmapp.fropxy.MaoFroPmAgentSplitAck;
import se.ericsson.cello.pmapp.fropxy.MaoFroPmAgentSplitInd;
import se.ericsson.cello.pmapp.fropxy.MaoFroPmInd;
import se.ericsson.cello.pmapp.fropxy.PmIndicationEvent;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;

public final class PmSignalDistributor
implements SignalObserver {
    private GenericPmFroProxyFactory myProxyMgr;
    private static PmSignalDistributor instance;
    private static final int INDICATION_DELAY = 1000;
    private static Map splitPmFroMap;

    public void signalReceived(InSignal inSignal) {
        MessageLog.trace((int)5, this.getClass(), (String)"PmSignalDistributor signalReceived");
        if (!(inSignal.getClass().equals(MaoFroPmInd.class) || inSignal.getClass().equals(MaoFroPmAgentInd.class) || inSignal.getClass().equals(MaoFroPm64AgentInd.class) || inSignal.getClass().equals(MaoFroPmAgentSplitInd.class) || inSignal.getClass().equals(MaoFroPm64AgentSplitInd.class))) {
            MessageLog.traceError(this.getClass(), (String)("Received unknown signal: " + inSignal));
            return;
        }
        this.distribute(inSignal);
    }

    protected void distribute(Object object) {
        Object object2;
        Object object3;
        int n = 0;
        int n2 = 0;
        CelloMaoFroPmDataStruct[] celloMaoFroPmDataStructArray = null;
        Map map = new HashMap();
        if (object.getClass().equals(MaoFroPmInd.class)) {
            Thread.yield();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            celloMaoFroPmDataStructArray = ((MaoFroPmInd)((Object)object)).getPmAttrsPerFroArray();
            map = this.handlePmEvent(celloMaoFroPmDataStructArray, map);
        } else if (object.getClass().equals(MaoFroPm64AgentInd.class)) {
            celloMaoFroPmDataStructArray = ((MaoFroPm64AgentInd)((Object)object)).getPmAttrsPerFroArray();
            object3 = ((MaoFroPm64AgentInd)((Object)object)).getSender();
            object2 = new MaoFroPm64AgentAck();
            MessageLog.trace((int)2, this.getClass(), (String)"about to send MaoFroPm64AgentAck");
            SignalHelper.send((OseProcess)object3, (Signal)object2);
            map = this.handlePmEvent(celloMaoFroPmDataStructArray, map);
        } else if (object.getClass().equals(MaoFroPmAgentInd.class)) {
            celloMaoFroPmDataStructArray = ((MaoFroPmAgentInd)((Object)object)).getPmAttrsPerFroArray();
            object3 = ((MaoFroPmAgentInd)((Object)object)).getSender();
            object2 = new MaoFroPmAgentAck();
            MessageLog.trace((int)2, this.getClass(), (String)"about to send MaoFroPmAgentAck");
            SignalHelper.send((OseProcess)object3, (Signal)object2);
            map = this.handlePmEvent(celloMaoFroPmDataStructArray, map);
        } else if (object.getClass().equals(MaoFroPm64AgentSplitInd.class)) {
            celloMaoFroPmDataStructArray = ((MaoFroPm64AgentSplitInd)((Object)object)).getPmAttrsPerFroArray();
            n2 = ((MaoFroPm64AgentSplitInd)((Object)object)).getTotalNoOfCounters();
            n = ((MaoFroPm64AgentSplitInd)((Object)object)).getTotalNoOfSplitSignals();
            object3 = ((MaoFroPm64AgentSplitInd)((Object)object)).getSender();
            object2 = new MaoFroPm64AgentSplitAck();
            MessageLog.trace((int)2, this.getClass(), (String)"about to send MaoFroPm64AgentSplitAck");
            SignalHelper.send((OseProcess)object3, (Signal)object2);
            map = this.handleSplitPmEvent(celloMaoFroPmDataStructArray, map, n, n2);
        } else if (object.getClass().equals(MaoFroPmAgentSplitInd.class)) {
            celloMaoFroPmDataStructArray = ((MaoFroPmAgentSplitInd)((Object)object)).getPmAttrsPerFroArray();
            n2 = ((MaoFroPmAgentSplitInd)((Object)object)).getTotalNoOfCounters();
            n = ((MaoFroPmAgentSplitInd)((Object)object)).getTotalNoOfSplitSignals();
            object3 = ((MaoFroPmAgentSplitInd)((Object)object)).getSender();
            object2 = new MaoFroPmAgentSplitAck();
            MessageLog.trace((int)2, this.getClass(), (String)"about to send MaoFroPmAgentSplitAck");
            SignalHelper.send((OseProcess)object3, (Signal)object2);
            map = this.handleSplitPmEvent(celloMaoFroPmDataStructArray, map, n, n2);
        }
        object3 = map.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = (PmIndicationEvent)((Map.Entry)object3.next()).getValue();
            MessageLog.trace((int)2, this.getClass(), (String)"pmEvent.send");
            object2.send();
        }
    }

    private Map handleSplitPmEvent(CelloMaoFroPmDataStruct[] celloMaoFroPmDataStructArray, Map map, int n, int n2) {
        for (int i = 0; i < celloMaoFroPmDataStructArray.length; ++i) {
            CelloMaoFroPmDataStruct celloMaoFroPmDataStruct = celloMaoFroPmDataStructArray[i];
            MessageLog.trace((int)2, this.getClass(), (String)("distribute pmlist.length = " + celloMaoFroPmDataStructArray.length));
            this.addSplitPmPushSignalData(celloMaoFroPmDataStruct);
            if (!this.isAllSplitSignalsReceived(celloMaoFroPmDataStruct, n)) continue;
            celloMaoFroPmDataStruct = this.getConsolidatedPmData(celloMaoFroPmDataStruct, n, n2);
            this.createPmEvent(map, celloMaoFroPmDataStruct);
        }
        return map;
    }

    private Map handlePmEvent(CelloMaoFroPmDataStruct[] celloMaoFroPmDataStructArray, Map map) {
        for (int i = 0; i < celloMaoFroPmDataStructArray.length; ++i) {
            CelloMaoFroPmDataStruct celloMaoFroPmDataStruct = celloMaoFroPmDataStructArray[i];
            MessageLog.trace((int)2, this.getClass(), (String)("distribute pmlist.length = " + celloMaoFroPmDataStructArray.length));
            this.createPmEvent(map, celloMaoFroPmDataStruct);
        }
        return map;
    }

    private void addSplitPmPushSignalData(CelloMaoFroPmDataStruct celloMaoFroPmDataStruct) {
        String string = "" + celloMaoFroPmDataStruct.getFroType();
        String string2 = "" + celloMaoFroPmDataStruct.getFroId();
        String string3 = string + "_" + string2;
        if (!splitPmFroMap.containsKey(string3)) {
            ArrayList<CelloMaoFroPmDataStruct> arrayList = new ArrayList<CelloMaoFroPmDataStruct>();
            arrayList.add(celloMaoFroPmDataStruct);
            splitPmFroMap.put(string3, arrayList);
        } else {
            List list = (List)splitPmFroMap.get(string3);
            list.add(celloMaoFroPmDataStruct);
        }
    }

    private boolean isAllSplitSignalsReceived(CelloMaoFroPmDataStruct celloMaoFroPmDataStruct, int n) {
        String string = "" + celloMaoFroPmDataStruct.getFroType();
        String string2 = "" + celloMaoFroPmDataStruct.getFroId();
        String string3 = string + "_" + string2;
        List list = (List)splitPmFroMap.get(string3);
        return list.size() == n;
    }

    private CelloMaoFroPmDataStruct getConsolidatedPmData(CelloMaoFroPmDataStruct celloMaoFroPmDataStruct, int n, int n2) {
        int n3 = 0;
        String string = "" + celloMaoFroPmDataStruct.getFroType();
        String string2 = "" + celloMaoFroPmDataStruct.getFroId();
        String string3 = string + "_" + string2;
        ArrayList arrayList = (ArrayList)splitPmFroMap.get(string3);
        long[] lArray = new long[n2];
        for (int i = 0; i < n; ++i) {
            CelloMaoFroPmDataStruct celloMaoFroPmDataStruct2 = (CelloMaoFroPmDataStruct)arrayList.get(i);
            System.arraycopy(celloMaoFroPmDataStruct2.getPmAttrList(), 0, lArray, n3, celloMaoFroPmDataStruct2.getPmAttrList().length);
            n3 += celloMaoFroPmDataStruct2.getPmAttrList().length;
        }
        CelloMaoFroPmDataStruct celloMaoFroPmDataStruct3 = new CelloMaoFroPmDataStruct(celloMaoFroPmDataStruct.getFroType(), celloMaoFroPmDataStruct.getFroId(), MaoFroTypeConverter.boolean2int(celloMaoFroPmDataStruct.getSuspectFlag()), lArray);
        celloMaoFroPmDataStruct3.setNoOfPmAttr(n2);
        for (int i = n - 1; i >= 0; --i) {
            arrayList.remove(i);
        }
        return celloMaoFroPmDataStruct3;
    }

    private void createPmEvent(Map map, CelloMaoFroPmDataStruct celloMaoFroPmDataStruct) {
        int n = celloMaoFroPmDataStruct.getFroType();
        String string = "" + n;
        GenericPmFroProxy genericPmFroProxy = this.myProxyMgr.lookupByFroType(n);
        if (genericPmFroProxy != null) {
            PmIndicationEvent pmIndicationEvent;
            if (!map.containsKey(string)) {
                MessageLog.trace((int)2, this.getClass(), (String)("if (!pmEvents.containsKey(froType) froType =" + n));
                pmIndicationEvent = new PmIndicationEvent(genericPmFroProxy);
                map.put(string, pmIndicationEvent);
            }
            pmIndicationEvent = (PmIndicationEvent)map.get(string);
            pmIndicationEvent.addPmData(celloMaoFroPmDataStruct);
            MessageLog.trace((int)2, this.getClass(), (String)"pmEvent.created");
        } else {
            MessageLog.traceError(this.getClass(), (String)("Pm Fro Proxy could not be found given fro type= " + n));
        }
    }

    public static void start(GenericPmFroProxyFactory genericPmFroProxyFactory) {
        MessageLog.trace((int)5, (Class)PmSignalDistributor.class, (String)"PmSignalDistributor start()");
        if (instance == null) {
            instance = new PmSignalDistributor(genericPmFroProxyFactory);
        }
    }

    public static void startListeningPmIndication() {
        CmaPmPortManager.instance().addSignalObserver(instance, MaoFroPmInd.class);
        CmaPmPortManager.instance().addSignalObserver(instance, MaoFroPmAgentInd.class);
        CmaPmPortManager.instance().addSignalObserver(instance, MaoFroPm64AgentInd.class);
        CmaPmPortManager.instance().addSignalObserver(instance, MaoFroPmAgentSplitInd.class);
        CmaPmPortManager.instance().addSignalObserver(instance, MaoFroPm64AgentSplitInd.class);
    }

    public static void stop() {
        if (instance == null) {
            return;
        }
        CmaPmPortManager.instance().removeSignalObserver(instance, MaoFroPmInd.class);
        CmaPmPortManager.instance().removeSignalObserver(instance, MaoFroPmAgentInd.class);
        CmaPmPortManager.instance().removeSignalObserver(instance, MaoFroPm64AgentInd.class);
        CmaPmPortManager.instance().removeSignalObserver(instance, MaoFroPmAgentSplitInd.class);
        CmaPmPortManager.instance().removeSignalObserver(instance, MaoFroPm64AgentSplitInd.class);
        instance = null;
    }

    PmSignalDistributor(GenericPmFroProxyFactory genericPmFroProxyFactory) {
        this.myProxyMgr = genericPmFroProxyFactory;
    }

    static {
        splitPmFroMap = new HashMap();
    }
}

