/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coli.ColiSessionFactory;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coli.ColiSessionInstigator;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.AbstractColiController;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.ColiHandlerListener;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.ColiListener;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.CommandHandlingSession;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.CapiTotCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.FanCountCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.FanTempCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.LlogCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.TeLogReadCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.ViiCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.units.AuxiliaryUnit;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.units.AuxiliaryUnitHandler;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.units.DeviceBoard;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.units.DeviceBoardHandler;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Utils;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;

public class ColiController
extends AbstractColiController {
    final HashMap deviceBoards = new HashMap();
    final HashMap auxiliaryUnits = new HashMap();
    final HashMap auxSerialNumbers = new HashMap();
    final Map sessionStatus = new HashMap();
    final CacheManager cacheMgr;
    final NealManager nealMgr;
    final CmService cmService;
    private Transaction transaction;
    final ColiSessionFactory coliSessionFactory;
    final CvSession cvSession;
    private ColiHandlerListener aColiListener;
    private boolean bIsStopped = false;
    private CommandHandlingSession currentAuSession;
    private CommandHandlingSession currentDbSession;

    public ColiController(CvSession cvSession) {
        this.cvSession = cvSession;
        this.coliSessionFactory = this.getColiSessionFactory();
        this.cacheMgr = cvSession.getCacheManager();
        this.nealMgr = cvSession.getNealManager();
        this.cmService = this.nealMgr.getCmService();
        if (this.cmService != null) {
            this.transaction = null;
        }
    }

    @Override
    public void cacheAllData(String[] stringArray, String[] stringArray2, ColiHandlerListener coliHandlerListener) {
        this.aColiListener = coliHandlerListener;
        this.initiateAllDeviceBoards(stringArray);
        this.initiateAllAuxiliaryUnits(stringArray2);
        this.startJobs();
    }

    private ColiSessionFactory getColiSessionFactory() {
        return new ColiSessionInstigator(this.cvSession.getLauncherData());
    }

    private void initiateAllDeviceBoards(String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                DeviceBoard deviceBoard = new DeviceBoard(stringArray[i]);
                if (deviceBoard.isGpbUnit() && this.isActiveUnit(stringArray[i])) {
                    deviceBoard.setActiveUnit(true);
                }
                this.deviceBoards.put(stringArray[i], deviceBoard);
                super.registerDeviceBoard(deviceBoard);
            }
        }
    }

    private boolean isActiveUnit(String string) {
        int n = 3;
        try {
            Transaction transaction = this.cmService.createNullTransaction();
            Mo mo = this.cmService.getMo(string);
            Mo mo2 = mo.getParent(transaction);
            NameValue nameValue = mo2.getAttribute("reservedBy", null);
            if (!(nameValue.getValue() instanceof Mo[])) {
                return false;
            }
            Mo[] moArray = nameValue.getMoArrayValue();
            for (int i = 0; i < moArray.length; ++i) {
                NameValue nameValue2;
                String string2 = moArray[i].getType();
                if (!"ReliableProgramUniter".equals(string2) || (nameValue2 = moArray[i].getAttribute("operationalMode", transaction)).getIntValue() == n) continue;
                Trace.observation(this, "---> Ldn: " + string + "   mode: " + nameValue2.getValue());
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void initiateAllAuxiliaryUnits(String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                AuxiliaryUnit auxiliaryUnit = new AuxiliaryUnit(stringArray[i]);
                this.auxiliaryUnits.put(stringArray[i], auxiliaryUnit);
                super.registerAuxiliaryUnit(auxiliaryUnit);
                String string = null;
                try {
                    Mo mo = this.cmService.getMo(stringArray[i]);
                    Mo mo2 = mo.getParent(this.transaction);
                    string = mo2.getAttribute("serialNumber", this.transaction).getStringValue();
                }
                catch (Exception exception) {
                    Trace.observation(this, "Not possible to fetch the serial no for " + stringArray[i] + exception.toString(), exception);
                    string = "";
                }
                auxiliaryUnit.setNodeStoredSerialNo(string);
                this.auxSerialNumbers.put(string, auxiliaryUnit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startJobs() {
        ColiController coliController = this;
        synchronized (coliController) {
            Vector vector;
            if (this.bIsStopped) {
                return;
            }
            ArrayList<DeviceBoardHandler> arrayList = new ArrayList<DeviceBoardHandler>();
            String string = (String)Utils.ATF_BOARDS.get(0);
            ArrayList arrayList2 = super.getDeviceBoardList();
            Iterator iterator = arrayList2.iterator();
            DeviceBoardHandler deviceBoardHandler2 = null;
            while (iterator.hasNext()) {
                deviceBoardHandler2 = (DeviceBoardHandler)iterator.next();
                if (!deviceBoardHandler2.getBoardType().equals(string)) continue;
                arrayList.add(deviceBoardHandler2);
            }
            ArrayList<DeviceBoardHandler> arrayList3 = new ArrayList<DeviceBoardHandler>();
            string = (String)Utils.ATF_BOARDS.get(1);
            for (DeviceBoardHandler deviceBoardHandler2 : arrayList2) {
                if (!deviceBoardHandler2.getBoardType().equals(string) || !deviceBoardHandler2.getSubrackId().equals("1")) continue;
                arrayList3.add(deviceBoardHandler2);
            }
            ArrayList<DeviceBoardHandler> arrayList4 = new ArrayList<DeviceBoardHandler>();
            string = (String)Utils.ATF_BOARDS.get(1);
            for (DeviceBoardHandler deviceBoardHandler2 : arrayList2) {
                if (!deviceBoardHandler2.getBoardType().equals(string) || !deviceBoardHandler2.getSubrackId().equals("2")) continue;
                arrayList4.add(deviceBoardHandler2);
            }
            ArrayList<DeviceBoardHandler> arrayList5 = new ArrayList<DeviceBoardHandler>();
            string = (String)Utils.ATF_BOARDS.get(2);
            for (DeviceBoardHandler deviceBoardHandler2 : arrayList2) {
                if (!deviceBoardHandler2.getBoardType().equals(string) || !deviceBoardHandler2.getSubrackId().equals("1")) continue;
                arrayList5.add(deviceBoardHandler2);
            }
            CommandHandlingSession commandHandlingSession = new CommandHandlingSession(this.coliSessionFactory, this.cvSession.getVibManager());
            this.sessionStatus.put(commandHandlingSession, Boolean.FALSE);
            commandHandlingSession.addColiListener(new ColiSessionListener());
            CommandHandlingSession commandHandlingSession2 = null;
            CommandHandlingSession commandHandlingSession3 = null;
            CommandHandlingSession commandHandlingSession4 = null;
            CommandHandlingSession commandHandlingSession5 = null;
            if (!arrayList.isEmpty()) {
                commandHandlingSession2 = new CommandHandlingSession(this.coliSessionFactory, this.cvSession.getVibManager());
                this.sessionStatus.put(commandHandlingSession2, Boolean.FALSE);
                commandHandlingSession2.addColiListener(new ColiSessionListener());
            }
            if (!arrayList3.isEmpty()) {
                commandHandlingSession3 = new CommandHandlingSession(this.coliSessionFactory, this.cvSession.getVibManager());
                this.sessionStatus.put(commandHandlingSession3, Boolean.FALSE);
                commandHandlingSession3.addColiListener(new ColiSessionListener());
            }
            if (!arrayList4.isEmpty()) {
                commandHandlingSession4 = new CommandHandlingSession(this.coliSessionFactory, this.cvSession.getVibManager());
                this.sessionStatus.put(commandHandlingSession4, Boolean.FALSE);
                commandHandlingSession4.addColiListener(new ColiSessionListener());
            }
            if (!arrayList5.isEmpty()) {
                commandHandlingSession5 = new CommandHandlingSession(this.coliSessionFactory, this.cvSession.getVibManager());
                this.sessionStatus.put(commandHandlingSession5, Boolean.FALSE);
                commandHandlingSession5.addColiListener(new ColiSessionListener());
            }
            if (!this.deviceBoards.isEmpty()) {
                commandHandlingSession.queueJob(super.getDeviceBoardList(), 2);
            } else {
                this.cvSession.getVibManager().allDataCached();
            }
            if (!arrayList.isEmpty()) {
                commandHandlingSession2.queueJob(super.getAuxiliaryUnitList(), arrayList, 3);
            }
            if (!arrayList3.isEmpty()) {
                vector = new Vector();
                vector.addAll(super.getAuxiliaryUnitList());
                commandHandlingSession3.queueJob(vector, arrayList3, 3);
            }
            if (!arrayList4.isEmpty()) {
                vector = new Vector();
                vector.addAll(super.getAuxiliaryUnitList());
                commandHandlingSession4.queueJob(vector, arrayList4, 3);
            }
            if (!arrayList5.isEmpty()) {
                commandHandlingSession5.queueJob(super.getAuxiliaryUnitList(), arrayList5, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cacheDeviceBoardData(String string, ColiHandlerListener coliHandlerListener) {
        ColiController coliController = this;
        synchronized (coliController) {
            boolean bl = this.seizeSession();
            if (!bl) {
                Trace.observation(this, "No free session: " + this.sessionStatus);
                return false;
            }
            this.aColiListener = coliHandlerListener;
            DeviceBoard deviceBoard = new DeviceBoard(string);
            if (this.deviceBoards.containsKey(string)) {
                this.deviceBoards.remove(string);
            }
            if (deviceBoard.isGpbUnit() && this.isActiveUnit(string)) {
                deviceBoard.setActiveUnit(true);
            }
            this.deviceBoards.put(string, deviceBoard);
            this.currentDbSession = new CommandHandlingSession(this.coliSessionFactory, this.cvSession.getVibManager());
            this.currentDbSession.addColiListener(new ColiSessionListener());
            ArrayList<DeviceBoard> arrayList = new ArrayList<DeviceBoard>();
            arrayList.add(deviceBoard);
            this.sessionStatus.put(this.currentDbSession, Boolean.FALSE);
            this.currentDbSession.queueJob(arrayList, 0);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cacheAuxiliaryUnitData(String string, String[] stringArray, ColiHandlerListener coliHandlerListener) {
        ColiController coliController = this;
        synchronized (coliController) {
            boolean bl = this.seizeSession();
            if (!bl) {
                return false;
            }
            this.aColiListener = coliHandlerListener;
            AuxiliaryUnitHandler auxiliaryUnitHandler = (AuxiliaryUnitHandler)this.auxiliaryUnits.get(string);
            AuxiliaryUnit auxiliaryUnit = new AuxiliaryUnit(string);
            if (this.auxiliaryUnits.containsKey(string)) {
                this.auxiliaryUnits.remove(string);
            }
            this.auxiliaryUnits.put(string, auxiliaryUnit);
            if (auxiliaryUnitHandler == null) {
                this.fetchSerialNumberFromNeal(auxiliaryUnit);
            } else {
                auxiliaryUnit.setAtfProcess(auxiliaryUnitHandler.getAtfProcess());
                auxiliaryUnit.setNodeStoredSerialNo(auxiliaryUnitHandler.getNodeStoredSerialNo());
                auxiliaryUnit.setAtfBoard(auxiliaryUnitHandler.getAtfBoard());
            }
            CommandHandlingSession commandHandlingSession = new CommandHandlingSession(this.coliSessionFactory, this.cvSession.getVibManager());
            commandHandlingSession.addColiListener(new ColiSessionListener());
            ArrayList<AuxiliaryUnit> arrayList = new ArrayList<AuxiliaryUnit>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList.add(auxiliaryUnit);
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                if (stringArray[i].indexOf("Slot=1,") != -1) {
                    bl2 = true;
                    object = new DeviceBoard(stringArray[i]);
                    arrayList2.add(object);
                    continue;
                }
                if (i != 0 && bl2) {
                    object = (String)Utils.ATF_BOARDS.get(1);
                    DeviceBoard deviceBoard = new DeviceBoard(stringArray[i], (String)object);
                    arrayList2.add(deviceBoard);
                    continue;
                }
                object = new DeviceBoard(stringArray[i]);
                arrayList2.add(object);
            }
            this.sessionStatus.put(commandHandlingSession, Boolean.FALSE);
            commandHandlingSession.queueJob(arrayList, arrayList2, 1);
            return bl;
        }
    }

    private void fetchSerialNumberFromNeal(AuxiliaryUnitHandler auxiliaryUnitHandler) {
        String string = null;
        try {
            Mo mo = this.cmService.getMo(auxiliaryUnitHandler.getLdn());
            Mo mo2 = mo.getParent(this.transaction);
            string = mo2.getAttribute("serialNumber", this.transaction).getStringValue();
        }
        catch (Exception exception) {
            Trace.observation(this, "Not possible to fetch the serial no for " + auxiliaryUnitHandler.getLdn() + exception.toString(), exception);
            string = "";
        }
        auxiliaryUnitHandler.setNodeStoredSerialNo(string);
        this.auxSerialNumbers.put(string, auxiliaryUnitHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cacheDeviceBoardLogData(String string, List list, ColiHandlerListener coliHandlerListener) {
        ColiController coliController = this;
        synchronized (coliController) {
            boolean bl = this.seizeSession();
            if (!bl) {
                return false;
            }
            this.aColiListener = coliHandlerListener;
            List list2 = list;
            DeviceBoard deviceBoard = new DeviceBoard(string, list2);
            if (!this.deviceBoards.isEmpty() && this.deviceBoards.containsKey(string)) {
                this.deviceBoards.remove(string);
            }
            this.deviceBoards.put(string, deviceBoard);
            CommandHandlingSession commandHandlingSession = new CommandHandlingSession(this.coliSessionFactory, this.cvSession.getVibManager());
            commandHandlingSession.addColiListener(new ColiSessionListener());
            ArrayList<DeviceBoard> arrayList = new ArrayList<DeviceBoard>();
            arrayList.add(deviceBoard);
            this.sessionStatus.put(commandHandlingSession, Boolean.FALSE);
            commandHandlingSession.queueJob(arrayList, 4);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandHandlingSession getCurrentAuSession() {
        ColiController coliController = this;
        synchronized (coliController) {
            return this.currentAuSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandHandlingSession getCurrentDbSession() {
        ColiController coliController = this;
        synchronized (coliController) {
            return this.currentDbSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cacheAuxiliaryUnitLogData(String string, String[] stringArray, ColiHandlerListener coliHandlerListener) {
        ColiController coliController = this;
        synchronized (coliController) {
            Object object;
            Object object2;
            boolean bl = this.seizeSession();
            if (!bl) {
                return false;
            }
            this.aColiListener = coliHandlerListener;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("te log read");
            AuxiliaryUnit auxiliaryUnit = new AuxiliaryUnit(string, arrayList);
            if (this.auxiliaryUnits.containsKey(string)) {
                this.auxiliaryUnits.remove(string);
            }
            String string2 = null;
            try {
                object2 = this.cmService.getMo(string);
                object = object2.getParent(this.transaction);
                string2 = object.getAttribute("serialNumber", this.transaction).getStringValue();
            }
            catch (Exception exception) {
                Trace.observation(this, "Not possible to fetch the serial no for " + string + exception.toString(), exception);
                string2 = "";
            }
            auxiliaryUnit.setNodeStoredSerialNo(string2);
            this.auxiliaryUnits.put(string, auxiliaryUnit);
            object2 = new CommandHandlingSession(this.coliSessionFactory, this.cvSession.getVibManager());
            ((CommandHandlingSession)object2).addColiListener(new ColiSessionListener());
            object = new ArrayList();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ((ArrayList)object).add(auxiliaryUnit);
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                Object object3;
                if (stringArray[i].indexOf("Slot=1,") != -1) {
                    bl2 = true;
                    object3 = new DeviceBoard(stringArray[i]);
                    arrayList2.add(object3);
                    continue;
                }
                if (i != 0 && bl2) {
                    object3 = (String)Utils.ATF_BOARDS.get(1);
                    DeviceBoard deviceBoard = new DeviceBoard(stringArray[i], (String)object3);
                    arrayList2.add(deviceBoard);
                    continue;
                }
                object3 = new DeviceBoard(stringArray[i]);
                arrayList2.add(object3);
            }
            this.sessionStatus.put(object2, Boolean.FALSE);
            ((CommandHandlingSession)object2).queueJob((List)object, arrayList2, 5);
            this.currentAuSession = object2;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean savePmDumpLogData(String string, ColiHandlerListener coliHandlerListener) {
        ColiController coliController = this;
        synchronized (coliController) {
            boolean bl = this.seizeSession();
            if (!bl) {
                return false;
            }
            this.aColiListener = coliHandlerListener;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("pmdumps");
            DeviceBoard deviceBoard = new DeviceBoard(string, arrayList);
            if (!this.deviceBoards.isEmpty() && this.deviceBoards.containsKey(string)) {
                this.deviceBoards.remove(string);
            }
            this.deviceBoards.put(string, deviceBoard);
            CommandHandlingSession commandHandlingSession = new CommandHandlingSession(this.coliSessionFactory, this.cvSession.getVibManager());
            commandHandlingSession.addColiListener(new ColiSessionListener());
            ArrayList<DeviceBoard> arrayList2 = new ArrayList<DeviceBoard>();
            arrayList2.add(deviceBoard);
            this.sessionStatus.put(commandHandlingSession, Boolean.FALSE);
            commandHandlingSession.queueJob(arrayList2, 4);
            return bl;
        }
    }

    @Override
    public String getLedStatus(String string, String string2) {
        Object object;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = this.deviceBoards.containsKey(string);
        if (bl2) {
            bl = true;
        } else {
            bl2 = this.auxiliaryUnits.containsKey(string);
            if (!bl2) {
                return null;
            }
        }
        Map map = null;
        if (bl) {
            object = (DeviceBoardHandler)this.deviceBoards.get(string);
            map = object.getCommandTable();
        } else {
            object = (AuxiliaryUnitHandler)this.auxiliaryUnits.get(string);
            map = object.getCommandTable();
        }
        if (map.isEmpty() || !map.containsKey("vii")) {
            return null;
        }
        object = (ViiCommand)map.get("vii");
        Object object2 = ((ViiCommand)object).getParsedCmdRespons(string2);
        string3 = (String)object2;
        return string3;
    }

    @Override
    public Map getLedStatus(String string) {
        Object object;
        Map map = null;
        boolean bl = false;
        boolean bl2 = this.deviceBoards.containsKey(string);
        if (bl2) {
            bl = true;
        } else {
            bl2 = this.auxiliaryUnits.containsKey(string);
            if (!bl2) {
                return null;
            }
        }
        Map map2 = null;
        if (bl) {
            object = (DeviceBoardHandler)this.deviceBoards.get(string);
            map2 = object.getCommandTable();
        } else {
            object = (AuxiliaryUnitHandler)this.auxiliaryUnits.get(string);
            map2 = object.getCommandTable();
        }
        if (map2.isEmpty() || !map2.containsKey("vii")) {
            return null;
        }
        object = (ViiCommand)map2.get("vii");
        Object[] objectArray = ((ViiCommand)object).getParsedCmdRespons();
        map = (Map)objectArray[0];
        return map;
    }

    @Override
    public String getSerialNumber(String string) {
        boolean bl = false;
        String string2 = null;
        bl = this.auxiliaryUnits.containsKey(string);
        if (!bl) {
            return null;
        }
        AuxiliaryUnitHandler auxiliaryUnitHandler = (AuxiliaryUnitHandler)this.auxiliaryUnits.get(string);
        string2 = auxiliaryUnitHandler.getColiFetchedSerialNo();
        return string2;
    }

    @Override
    public Integer getProcessorLoad(String string) {
        boolean bl = this.deviceBoards.containsKey(string);
        if (!bl) {
            return null;
        }
        Map map = null;
        DeviceBoardHandler deviceBoardHandler = (DeviceBoardHandler)this.deviceBoards.get(string);
        map = deviceBoardHandler.getCommandTable();
        if (map.isEmpty() || !map.containsKey("capi tot")) {
            return null;
        }
        CapiTotCommand capiTotCommand = (CapiTotCommand)map.get("capi tot");
        Object[] objectArray = capiTotCommand.getParsedCmdRespons();
        Integer n = (Integer)objectArray[0];
        return n;
    }

    @Override
    public Float getFanTemp(String string) {
        boolean bl = this.auxiliaryUnits.containsKey(string);
        if (!bl) {
            return null;
        }
        Map map = null;
        AuxiliaryUnitHandler auxiliaryUnitHandler = (AuxiliaryUnitHandler)this.auxiliaryUnits.get(string);
        map = auxiliaryUnitHandler.getCommandTable();
        if (map.isEmpty() || !map.containsKey("fantemp")) {
            return null;
        }
        FanTempCommand fanTempCommand = (FanTempCommand)map.get("fantemp");
        Object[] objectArray = fanTempCommand.getParsedCmdRespons();
        Float f = (Float)objectArray[0];
        return f;
    }

    @Override
    public Integer getFanCount(String string) {
        boolean bl = this.auxiliaryUnits.containsKey(string);
        if (!bl) {
            return null;
        }
        int n = -1;
        Map map = null;
        AuxiliaryUnitHandler auxiliaryUnitHandler = (AuxiliaryUnitHandler)this.auxiliaryUnits.get(string);
        map = auxiliaryUnitHandler.getCommandTable();
        if (map.isEmpty()) {
            return null;
        }
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith("fancount")) continue;
            bl2 = true;
            arrayList.add(string2);
        }
        if (!bl2) {
            return null;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            FanCountCommand fanCountCommand = (FanCountCommand)map.get(string3);
            Object[] objectArray = fanCountCommand.getParsedCmdRespons();
            Integer n2 = (Integer)objectArray[0];
            if (n2 == null || n2 <= n) continue;
            n = n2;
        }
        return new Integer(n);
    }

    @Override
    public String getDeviceBoardRestartLogData(String string) {
        boolean bl = this.deviceBoards.containsKey(string);
        if (!bl) {
            return null;
        }
        Map map = null;
        DeviceBoardHandler deviceBoardHandler = (DeviceBoardHandler)this.deviceBoards.get(string);
        map = deviceBoardHandler.getCommandTable();
        if (map.isEmpty() || !map.containsKey("llog -l")) {
            return null;
        }
        LlogCommand llogCommand = (LlogCommand)map.get("llog -l");
        Object[] objectArray = llogCommand.getParsedCmdRespons();
        String string2 = (String)objectArray[0];
        return string2;
    }

    @Override
    public String getDeviceBoardTraceAndErrorLogData(String string) {
        boolean bl = this.deviceBoards.containsKey(string);
        if (!bl) {
            return null;
        }
        Map map = null;
        DeviceBoardHandler deviceBoardHandler = (DeviceBoardHandler)this.deviceBoards.get(string);
        map = deviceBoardHandler.getCommandTable();
        if (map.isEmpty() || !map.containsKey("te log read")) {
            return null;
        }
        TeLogReadCommand teLogReadCommand = (TeLogReadCommand)map.get("te log read");
        Object[] objectArray = teLogReadCommand.getParsedCmdRespons();
        String string2 = (String)objectArray[0];
        return string2;
    }

    @Override
    public String getAuxiliaryUnitLogData(String string) {
        boolean bl = this.auxiliaryUnits.containsKey(string);
        if (!bl) {
            return null;
        }
        Map map = null;
        AuxiliaryUnitHandler auxiliaryUnitHandler = (AuxiliaryUnitHandler)this.auxiliaryUnits.get(string);
        map = auxiliaryUnitHandler.getCommandTable();
        if (map.isEmpty() || !map.containsKey("te log read")) {
            return null;
        }
        TeLogReadCommand teLogReadCommand = (TeLogReadCommand)map.get("te log read");
        Object[] objectArray = teLogReadCommand.getParsedCmdRespons();
        String string2 = (String)objectArray[0];
        return string2;
    }

    @Override
    public void stop() {
        this.bIsStopped = true;
        Trace.error(this, "STOPPING COLI CONTROLLER");
        if (this.sessionStatus == null) {
            return;
        }
        for (CommandHandlingSession commandHandlingSession : this.sessionStatus.keySet()) {
            commandHandlingSession.stopNodeAccess();
        }
    }

    @Override
    public void stop(CommandHandlingSession commandHandlingSession) {
        if (commandHandlingSession != null) {
            commandHandlingSession.stopNodeAccess();
        }
    }

    private void releaseSession(CommandHandlingSession commandHandlingSession) {
        if (this.sessionStatus.containsKey(commandHandlingSession)) {
            this.sessionStatus.remove(commandHandlingSession);
            Boolean bl = Boolean.TRUE;
            this.sessionStatus.put(commandHandlingSession, bl);
        }
        Trace.observation(this, "Released session:" + commandHandlingSession);
    }

    private boolean seizeSession() {
        this.checkSessions();
        boolean bl = false;
        for (CommandHandlingSession commandHandlingSession : this.sessionStatus.keySet()) {
            Boolean bl2 = (Boolean)this.sessionStatus.get(commandHandlingSession);
            if (!bl2.booleanValue()) continue;
            bl = true;
            this.sessionStatus.remove(commandHandlingSession);
            break;
        }
        return bl;
    }

    private void checkSessions() {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : this.sessionStatus.keySet()) {
            Boolean bl = (Boolean)this.sessionStatus.get(object2);
            if (bl.booleanValue() || ((CommandHandlingSession)object2).isBusy()) continue;
            arrayList.add(object2);
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            this.releaseSession((CommandHandlingSession)object2.next());
        }
    }

    class ColiSessionListener
    implements ColiListener {
        ColiSessionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deviceBoardDataCached(CommandHandlingSession commandHandlingSession, String string) {
            ColiSessionListener coliSessionListener = this;
            synchronized (coliSessionListener) {
                ColiController.this.aColiListener.deviceBoardDataCached(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void auxiliaryUnitDataCached(CommandHandlingSession commandHandlingSession, String string) {
            ColiSessionListener coliSessionListener = this;
            synchronized (coliSessionListener) {
                ColiController.this.aColiListener.auxiliaryUnitDataCached(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sessionDataCached(CommandHandlingSession commandHandlingSession) {
            ColiSessionListener coliSessionListener = this;
            synchronized (coliSessionListener) {
                if (ColiController.this.sessionStatus.containsKey(commandHandlingSession)) {
                    ColiController.this.releaseSession(commandHandlingSession);
                    ColiController.this.aColiListener.allDataCached();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deviceBoardLogDataCached(CommandHandlingSession commandHandlingSession, String string) {
            ColiSessionListener coliSessionListener = this;
            synchronized (coliSessionListener) {
                ColiController.this.aColiListener.deviceBoardLogDataCached(string);
                ColiController.this.releaseSession(commandHandlingSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void auxiliaryUnitLogDataCached(CommandHandlingSession commandHandlingSession, String string) {
            ColiSessionListener coliSessionListener = this;
            synchronized (coliSessionListener) {
                ColiController.this.aColiListener.auxiliaryUnitLogDataCached(string);
                ColiController.this.releaseSession(commandHandlingSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void coliCommunicationExceptionOccured(CommandHandlingSession commandHandlingSession, Exception exception) {
            ColiSessionListener coliSessionListener = this;
            synchronized (coliSessionListener) {
                ColiController.this.releaseSession(commandHandlingSession);
                String string = commandHandlingSession.getFirstLdnInDeviceBoardList();
                if (string == null || string.equals("")) {
                    string = commandHandlingSession.getFirstLdnInAuxillaryUnitsList();
                }
                ColiController.this.aColiListener.coliCommunicationExceptionOccured(string, exception);
            }
        }
    }
}

