/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.AdminStateHelper;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class Lock
extends CabinetViewerAction {
    private static final String ACTION_DISPLAY_NAME_LOCK = "Lock";
    protected Mo mo = null;
    protected String ldn = null;
    private String msg = null;

    public Lock(Operable operable, String string) {
        super(operable, ACTION_DISPLAY_NAME_LOCK, "");
        this.ldn = string;
        this.mo = this.cmService.getMo(string);
    }

    public Lock(Operable operable) {
        super(operable, ACTION_DISPLAY_NAME_LOCK, "");
        this.init();
    }

    public Lock() {
        super(ACTION_DISPLAY_NAME_LOCK, "");
    }

    @Override
    public void setOperable(Operable operable) {
        super.setOperable(operable);
        this.init();
    }

    private void init() {
        this.ldn = this.operable.getTargetMoLdnForLockUnlock();
        if (this.ldn != null) {
            this.mo = this.cmService.getMo(this.ldn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.confirmLock()) {
            this.performLockAction();
        }
    }

    protected String getLdn() {
        return this.ldn;
    }

    protected Mo getMo() {
        return this.mo;
    }

    private boolean confirmLock() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isConfirmTechnicianPresent(this.ldn)) {
            stringBuffer.append("Field technician is present.\n");
        }
        if (this.isSharedWithExternalMe((VoData)((Object)this.operable))) {
            stringBuffer.append("This unit is shared with external Me.\n");
        }
        stringBuffer.append("Are you sure you want to lock ");
        stringBuffer.append(this.getViewableObjectName());
        stringBuffer.append("?");
        this.msg = stringBuffer.toString();
        if (this.isStartWithoutGui()) {
            return true;
        }
        return JOptionPane.showConfirmDialog(null, this.msg, ACTION_DISPLAY_NAME_LOCK, 0, 3) == 0;
    }

    private void performLockAction() {
        Object object;
        Transaction transaction = null;
        try {
            object = this.getCmService();
            Mo mo = this.getMo();
            NameValue nameValue = object.getNameValueFactory().create("administrativeState", 0);
            transaction = object.createTransaction();
            mo.setAttribute(nameValue, transaction);
            transaction.commit();
            Trace.observation(this, "Lock: " + this.getViewableObjectName());
        }
        catch (Exception exception) {
            if (exception.getMessage().contains("technician present")) {
                this.showError(this.getTechnicianPresentMessage("lock"), exception);
            } else if (NealManager.isCausedByNodeRestarting(exception)) {
                this.showConnectionError(exception);
            } else {
                this.showOperationError(exception);
            }
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                Trace.error(this, "Rollback failed. " + exception2);
            }
        }
        if (!this.isStartWithoutGui()) {
            object = new AdminStateHelper(this.mo, 1, this.operable);
            ((Thread)object).start();
        }
    }

    @Override
    protected void addOptions(JPanel jPanel, GridBagConstraints gridBagConstraints) {
    }

    @Override
    protected String getText() {
        return null;
    }

    public String getMsg() {
        return this.msg;
    }

    @Override
    protected void performTheAction() {
    }
}

