/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.IllegalTypeException;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.cello.neal.cm.Value;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.repairdeliverynote.RepairDeliveryApplication;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.repairdeliverynote.RepairDeliveryException;

public class RepairDeliveryNote
extends CabinetViewerAction {
    private static final String REPAIR_DELIVERY_NOTE = "Repair delivery note";
    private static final String ACTIONNAME_READREPAIRDELIVERYNOTEFROMHWLOG = "readRepairDeliveryNoteFromHwLog";
    private static final String ACTIONNAME_ISREPAIRDELIVERYNOTEEXISTING = "isRepairDeliveryNoteExisting";
    private static final String ACTIONNAME_WRITEREPAIRDELIVERYNOTETOHWLOG = "writeRepairDeliveryNoteToHwLog";
    private static final String ACTIONNAME_WRITEREPAIRDELIVNOTE = "writeRepairDelivNote";
    private static final String ACTIONNAME_READREPAIRDELIVNOTE = "readRepairDelivNote";
    private static final String FUNCTION_NOT_SUPPORTED = "FunctionNotSupported";
    private static final String NO_ACCESS_TO_HW_LOG = "NoAccessToHwLog";
    private static final String REPAIR_DELIVERY_NOTE_DOES_NOT_EXIST = "RepairDeliveryNoteDoesNotExist";
    private static final String HW_LOG_FULL = "HwLogFull";
    private static final String REPAIR_DELIVERY_NOTE_ALREADY_EXISTS = "RepairDeliveryNoteAlreadyExists";
    private static final String AUX_PLUG_IN_UNIT = "AuxPlugInUnit";
    private static final String PLUG_IN_UNIT = "PlugInUnit";
    private String currentLdn = null;
    final Map applMap = new HashMap();

    public RepairDeliveryNote(Operable operable) {
        super(operable, REPAIR_DELIVERY_NOTE, "KEY_REPAIR_NOTE");
        this.init();
    }

    public RepairDeliveryNote() {
        super(REPAIR_DELIVERY_NOTE, "KEY_REPAIR_NOTE");
    }

    @Override
    public void setOperable(Operable operable) {
        super.setOperable(operable);
        this.init();
    }

    private void init() {
        this.currentLdn = this.operable.getTargetMoLdnForRepairDeliveryNote();
    }

    protected Mo getMo(String string) {
        Mo mo = null;
        if (string != null && (mo = this.cmService.getMo(string)) != null && !mo.exists()) {
            mo = null;
        }
        return mo;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object v = this.applMap.get(this.currentLdn);
        if (v != null) {
            RepairDeliveryApplication repairDeliveryApplication = (RepairDeliveryApplication)v;
            repairDeliveryApplication.setAlwaysOnTop(true);
        } else {
            RepairDeliveryApplication repairDeliveryApplication = new RepairDeliveryApplication(this.operable, this);
            if (repairDeliveryApplication.isRunning()) {
                this.applMap.put(this.currentLdn, repairDeliveryApplication);
            }
        }
    }

    public void endApplication(Operable operable) {
        if (operable == null) {
            return;
        }
        String string = operable.getTargetMoLdnForRepairDeliveryNote();
        if (string != null) {
            this.applMap.remove(string);
        }
    }

    protected String getLdn() {
        return this.currentLdn;
    }

    private boolean isRepairDeliveryNoteExisting(String string) throws CmException, Exception {
        Mo mo = this.getMo(string);
        NameValue[] nameValueArray = new NameValue[]{};
        Transaction transaction = this.cmService.createTransaction();
        Value value = mo.action(ACTIONNAME_ISREPAIRDELIVERYNOTEEXISTING, nameValueArray, transaction);
        boolean bl = value.getBooleanValue();
        transaction.commit();
        Trace.observation(this, "Is Repair Delivery Note existing on Node: " + this.operable.getViewableObjectName());
        return bl;
    }

    private boolean isRepairDeliveryNoteExisting(CmException cmException) {
        return !REPAIR_DELIVERY_NOTE_DOES_NOT_EXIST.equalsIgnoreCase(cmException.getCauseTag());
    }

    public Struct performReadRepairDeliveryNoteAction(Operable operable) throws RepairDeliveryException {
        String string = operable.getTargetMoLdnForRepairDeliveryNote();
        String string2 = operable.getActionNameForReadRepairDeliveryNote();
        Trace.observation(this, "line 214. performReadRepairDeliveryNoteAction()  readActionName := " + string2);
        Struct struct = null;
        if (string2 != null) {
            struct = this.readRepairDeliveryAction(string, string2);
            return struct;
        }
        struct = this.isPiuOrAuxPiu(string) ? this.readActionOnPiuOrAuxPiu(string) : this.readActionOnDeviceGroup(string);
        return struct;
    }

    private Struct readActionOnDeviceGroup(String string) throws RepairDeliveryException {
        try {
            if (!this.isRepairDeliveryNoteExisting(string)) {
                return null;
            }
            Mo mo = this.getMo(string);
            if (mo == null) {
                return null;
            }
            NameValue[] nameValueArray = new NameValue[]{};
            Transaction transaction = this.cmService.createTransaction();
            Value value = mo.action(ACTIONNAME_READREPAIRDELIVERYNOTEFROMHWLOG, nameValueArray, transaction);
            Struct struct = value.getStructValue();
            transaction.commit();
            Trace.observation(this, "Read Repair Delivery Note from HW log: " + this.operable.getViewableObjectName());
            return struct;
        }
        catch (Exception exception) {
            Trace.error(this, "Failed: readRepairDeliveryNoteFromHwLog", exception);
            if (NealManager.isCausedByNodeRestarting(exception)) {
                this.showConnectionError(exception);
            } else {
                this.showOperationError(exception);
            }
            throw new RepairDeliveryException(exception);
        }
    }

    private Struct readActionOnPiuOrAuxPiu(String string) throws RepairDeliveryException {
        try {
            Mo mo = this.getMo(string);
            if (mo == null) {
                return null;
            }
            Mo mo2 = this.getMo("ManagedElement=1,NodeBFunction=1");
            NameValue[] nameValueArray = new NameValue[]{};
            Value value = mo2 != null ? mo.action(ACTIONNAME_READREPAIRDELIVNOTE, nameValueArray, null) : (this.isAuxPiu(string) ? mo.action(ACTIONNAME_READREPAIRDELIVERYNOTEFROMHWLOG, nameValueArray, null) : mo.action(ACTIONNAME_READREPAIRDELIVNOTE, nameValueArray, null));
            Struct struct = value.getStructValue();
            return struct;
        }
        catch (CmException cmException) {
            Trace.error(this, "Failed: readRepairDelivNote", cmException);
            if (this.isMomException(cmException, REPAIR_DELIVERY_NOTE_DOES_NOT_EXIST)) {
                return null;
            }
            this.showError(this.getReadExceptionCause(cmException), (Exception)((Object)cmException));
            throw new RepairDeliveryException(cmException);
        }
        catch (Exception exception) {
            Trace.error(this, "Failed: readRepairDelivNote", exception);
            if (NealManager.isCausedByNodeRestarting(exception)) {
                this.showConnectionError(exception);
            } else {
                this.showOperationError(exception);
            }
            throw new RepairDeliveryException(exception);
        }
    }

    private Struct readRepairDeliveryAction(String string, String string2) throws RepairDeliveryException {
        try {
            Mo mo = this.getMo(string);
            if (mo == null) {
                return null;
            }
            NameValue[] nameValueArray = new NameValue[]{};
            Transaction transaction = this.cmService.createTransaction();
            Value value = mo.action(string2, nameValueArray, null);
            Struct struct = value.getStructValue();
            transaction.commit();
            Trace.observation(this, "Read Repair Delivery Note from HW log: " + this.operable.getViewableObjectName());
            return struct;
        }
        catch (CmException cmException) {
            if (this.isMomException(cmException, REPAIR_DELIVERY_NOTE_DOES_NOT_EXIST)) {
                return null;
            }
            Trace.error(this, "Failed: " + string2, cmException);
            this.showError(this.getReadExceptionCause(cmException), (Exception)((Object)cmException));
            throw new RepairDeliveryException(cmException);
        }
        catch (IllegalTypeException illegalTypeException) {
            Trace.error(this, "Failed: " + string2, illegalTypeException);
            this.showOperationError((Exception)((Object)illegalTypeException));
            throw new RepairDeliveryException(illegalTypeException);
        }
    }

    public void performWriteRepairDeliveryNoteAction(Operable operable, NameValue[] nameValueArray) {
        String string = operable.getTargetMoLdnForRepairDeliveryNote();
        Transaction transaction = null;
        try {
            Mo mo = this.getMo(string);
            if (mo == null) {
                return;
            }
            Mo mo2 = this.getMo("ManagedElement=1,NodeBFunction=1");
            transaction = this.cmService.createTransaction();
            if (mo2 != null) {
                if (this.isPiuOrAuxPiu(string)) {
                    mo.action(ACTIONNAME_WRITEREPAIRDELIVNOTE, nameValueArray, null);
                } else {
                    mo.action(ACTIONNAME_WRITEREPAIRDELIVERYNOTETOHWLOG, nameValueArray, null);
                }
            } else if (this.isAuxPiu(string)) {
                mo.action(ACTIONNAME_WRITEREPAIRDELIVERYNOTETOHWLOG, nameValueArray, null);
            } else {
                mo.action(ACTIONNAME_WRITEREPAIRDELIVNOTE, nameValueArray, null);
            }
            transaction.commit();
        }
        catch (CmException cmException) {
            this.showError(this.getWriteExceptionCause(cmException), (Exception)((Object)cmException));
        }
        catch (Exception exception) {
            if (NealManager.isCausedByNodeRestarting(exception)) {
                this.showConnectionError(exception);
            }
            this.showOperationError(exception);
        }
    }

    @Override
    protected void addOptions(JPanel jPanel, GridBagConstraints gridBagConstraints) {
    }

    @Override
    protected String getText() {
        return null;
    }

    @Override
    protected void performTheAction() {
    }

    private boolean isPiuOrAuxPiu(String string) {
        if (string == null) {
            return false;
        }
        int n = string.lastIndexOf(44);
        if (n > -1) {
            String string2 = string.substring(n + 1);
            String string3 = string2.substring(0, string2.indexOf(61));
            return PLUG_IN_UNIT.equals(string3) || AUX_PLUG_IN_UNIT.equals(string3);
        }
        return false;
    }

    private boolean isAuxPiu(String string) {
        if (string == null) {
            return false;
        }
        int n = string.lastIndexOf(44);
        if (n > -1) {
            String string2 = string.substring(n + 1);
            String string3 = string2.substring(0, string2.indexOf(61));
            return AUX_PLUG_IN_UNIT.equals(string3);
        }
        return false;
    }

    private boolean isMomException(CmException cmException, String string) {
        String string2 = cmException.getRawInfo();
        return string2 != null && string2.indexOf(string) != -1;
    }

    private String getReadExceptionCause(CmException cmException) {
        String string = "";
        string = this.isMomException(cmException, FUNCTION_NOT_SUPPORTED) ? this.getActionName() + " is not supported on this unit." : (this.isMomException(cmException, NO_ACCESS_TO_HW_LOG) ? "Could not read repair delivery note information. \nNo access to HW log." : (this.isMomException(cmException, REPAIR_DELIVERY_NOTE_DOES_NOT_EXIST) ? "Repair delivery note information has not been set on unit." : this.getActionName() + " failed."));
        return string;
    }

    private String getWriteExceptionCause(CmException cmException) {
        String string = "";
        String string2 = cmException.getCauseTag();
        if (string2 == null) {
            return this.getActionName() + " failed.";
        }
        string = this.isMomException(cmException, FUNCTION_NOT_SUPPORTED) ? this.getActionName() + " is not supported on this unit." : (this.isMomException(cmException, NO_ACCESS_TO_HW_LOG) ? "Could not write repair delivery note information. \nNo access to HW log." : (this.isMomException(cmException, HW_LOG_FULL) ? "Could not write repair delivery note information. \nHW log is full." : (this.isMomException(cmException, REPAIR_DELIVERY_NOTE_ALREADY_EXISTS) ? "Repair delivery note information has already been written." : this.getActionName() + " failed.")));
        return string;
    }
}

