/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.repairdeliverynote;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JOptionPane;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.RepairDeliveryNote;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.repairdeliverynote.RepairDeliveryException;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.repairdeliverynote.RepairDeliveryModel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.repairdeliverynote.RepairDeliveryView;

public class RepairDeliveryController {
    public static final String REPORT_DELIVERY_WARNING = "It will not be possible to edit or delete the note after saving.\n Are you sure you want to save?";
    public static final String TITLE = "Information";
    private Operable operable;
    private RepairDeliveryNote action;
    private RepairDeliveryView view;
    private RepairDeliveryModel model;
    private boolean isRunning = false;

    public RepairDeliveryController(Operable operable, RepairDeliveryNote repairDeliveryNote) {
        this.operable = operable;
        this.action = repairDeliveryNote;
        this.view = new RepairDeliveryView();
        this.model = new RepairDeliveryModel(operable, repairDeliveryNote, this.view);
        try {
            this.init();
        }
        catch (RepairDeliveryException repairDeliveryException) {
            this.endApplication();
            return;
        }
        this.view.setVisible(true);
        this.isRunning = true;
    }

    protected boolean isRunning() {
        return this.isRunning;
    }

    public void setAlwaysOnTop(boolean bl) {
        this.view.setAlwaysOnTop(bl);
    }

    private void endApplication() {
        this.view.setVisible(false);
        this.view = null;
        this.model = null;
        this.isRunning = false;
        this.action.endApplication(this.operable);
    }

    private void init() throws RepairDeliveryException {
        this.view.init();
        this.view.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RepairDeliveryController.this.action.endApplication(RepairDeliveryController.this.operable);
            }
        });
        this.view.setButtonListeners(new SaveButtonListener(), new CancelButtonListener());
        this.model.setDataInGUI();
    }

    private boolean showConfirmDialog() {
        int n = JOptionPane.showConfirmDialog(this.view, REPORT_DELIVERY_WARNING, TITLE, 0, 1);
        return n == 0;
    }

    private void saveRepairDeliveryNote() {
        String string = this.view.getPrepBy();
        String string2 = this.view.getCountryCode();
        String string3 = this.view.getDesOfFault();
        String string4 = this.view.getTrNo();
        String string5 = this.view.getCompRef();
        String string6 = this.view.getStateCode();
        this.model.writeRepairDeliveryNote(string, string2, string3, string4, string5, string6);
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RepairDeliveryController.this.endApplication();
        }
    }

    private class SaveButtonListener
    implements ActionListener {
        private SaveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = RepairDeliveryController.this.showConfirmDialog();
            if (bl) {
                try {
                    RepairDeliveryController.this.saveRepairDeliveryNote();
                }
                catch (Exception exception) {
                    RepairDeliveryController.this.endApplication();
                }
                RepairDeliveryController.this.view.disableSaveButton();
                RepairDeliveryController.this.endApplication();
            }
        }
    }
}

