/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LED;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedRepaintListener;

public class LedRepaintThread
extends Thread {
    private static final int NO_OF_DELAYS_PER_YIELD = 10;
    private static final int PERIOD = 30;
    private List<LedRepaintListener> listeners = new ArrayList<LedRepaintListener>();
    private volatile boolean isStopped = false;
    private volatile boolean isPaused = true;

    public LedRepaintThread() {
        super("LED repaint thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeRepaintItem(List<LedRepaintListener> list) {
        List<LedRepaintListener> list2 = this.listeners;
        synchronized (list2) {
            for (LedRepaintListener ledRepaintListener : list) {
                if (this.listeners.contains(ledRepaintListener)) continue;
                this.listeners.add(ledRepaintListener);
                LED lED = (LED)ledRepaintListener;
                lED.revalidate();
            }
        }
    }

    public void dispose() {
        this.isStopped = true;
        this.go();
    }

    public void halt() {
        this.isPaused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        this.isPaused = false;
        LedRepaintThread ledRepaintThread = this;
        synchronized (ledRepaintThread) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        int n = 0;
        while (!this.isStopped) {
            Object object;
            if (this.isPaused) {
                try {
                    object = this;
                    synchronized (object) {
                        while (this.isPaused) {
                            Trace.observation(this, "LED repaint thread is paused");
                            this.wait();
                        }
                    }
                }
                catch (Exception exception) {
                    Trace.warning(this, "Wait failed", exception);
                }
                Trace.observation(this, "Painting again after wait");
                l5 = 0L;
            }
            l = System.currentTimeMillis();
            object = this.listeners;
            synchronized (object) {
                if (this.listeners.size() == 0) {
                    continue;
                }
                for (LedRepaintListener ledRepaintListener : this.listeners) {
                    ledRepaintListener.doRepaintStep();
                }
            }
            l2 = System.currentTimeMillis();
            l4 = l2 - l;
            l3 = 30L - l4 - l5;
            if (l3 > 0L) {
                try {
                    Thread.sleep(l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l5 = System.currentTimeMillis() - l2 - l3;
                continue;
            }
            l5 = 0L;
            if (++n < 10) continue;
            Thread.yield();
            n = 0;
        }
        Trace.observation(this, "LED repaint thread has stopped");
    }
}

