/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.util.List;
import java.util.StringTokenizer;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoDataListener;

class NotifyUpdateManager
implements VoDataListener {
    final VoView voView;

    public NotifyUpdateManager(VoView voView) {
        this.voView = voView;
    }

    @Override
    public void voDataChanged(VoData voData, int n) {
        try {
            this.updateVoData(voData, n);
        }
        catch (Exception exception) {
            Trace.observation(this, "Could not update " + voData.getSpecificType() + " name. " + exception);
        }
    }

    protected void updateVoData(VoData voData, int n) throws Exception {
        ViewableObject viewableObject = (ViewableObject)voData;
        Object object = viewableObject.getProperty("NOTIFY_UPDATE");
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)object;
        String[] stringArray = null;
        String string = null;
        Object object2 = null;
        String string2 = null;
        for (Object e : list) {
            String string3 = (String)e;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ":", false);
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            if (string4 == null || string5 == null) {
                return;
            }
            if ((string4 = string4.toUpperCase()).equals("MO")) {
                stringArray = viewableObject.getLdns(string5);
                if (stringArray == null || stringArray.length <= 0) {
                    return;
                }
                string = stringArray[0];
                continue;
            }
            if (string4.equals("ATTRIBUTE")) {
                object2 = viewableObject.getValue(string, string5);
                if (object2 != null) continue;
                return;
            }
            if (!string4.equals("STRUCTMEMBER")) continue;
            Struct struct = (Struct)object2;
            if (struct == null) {
                return;
            }
            NameValue nameValue = struct.getMember(string5);
            if (nameValue == null) {
                return;
            }
            string2 = (String)nameValue.getValue();
            if (string2 == null || string2.equals("")) {
                return;
            }
            if (string2.length() <= 8) break;
            string2 = string2.substring(0, 8);
            break;
        }
        if (string2 == null) {
            if (object2 != null) {
                this.update(object2.toString());
            }
        } else {
            this.update(string2);
        }
    }

    protected void update(String string) {
        if (string != null && this.voView != null) {
            this.voView.setLabel(string);
            this.voView.getVoData().setSpecificType(string);
            this.voView.setToolTipText(this.voView.getVoData().getFullName());
        }
    }
}

