/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels;

import java.util.ArrayList;
import java.util.Hashtable;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.AttributeExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.restrictions.Restriction;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class MoAttributeExtractor
implements AttributeExtractor {
    private VoData vo;
    private String moName;
    private Restriction restriction;
    private String attributeName;

    public MoAttributeExtractor(VoData voData, String string, String string2) {
        this(voData, string, null, string2);
    }

    public MoAttributeExtractor(VoData voData, String string, Restriction restriction, String string2) {
        this.vo = voData;
        this.moName = string;
        this.restriction = restriction;
        this.attributeName = string2;
    }

    @Override
    public void setVo(VoData voData) {
        this.vo = voData;
    }

    @Override
    public Object get() {
        String[] stringArray = this.vo.getLdns(this.moName);
        if (this.restriction != null && stringArray != null && stringArray.length >= 1) {
            for (String string : stringArray) {
                Hashtable<String, Object> hashtable = this.vo.getMoProperties(string);
                CachedMo cachedMo = this.vo.getCvSession().getCacheManager().getCachedMo(string);
                if (!this.restriction.isValid(cachedMo, hashtable)) continue;
                return this.vo.getValue(string, this.attributeName);
            }
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.vo.getValue(stringArray[i], this.attributeName);
            arrayList.add(object);
        }
        if (arrayList.size() <= 0) {
            return null;
        }
        Object[] objectArray = null;
        if (arrayList.size() == 1) {
            objectArray = (Object[])arrayList.get(0);
        } else if (arrayList.size() > 1) {
            objectArray = arrayList.toArray(new Object[1]);
        }
        return objectArray;
    }

    public Object get(String string) {
        return this.vo.getValue(string, this.attributeName);
    }

    @Override
    public boolean isExisting() {
        return this.vo.isExisting(this.moName);
    }

    public String getMoName() {
        return this.moName;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{this.getAttributeName()};
    }

    @Override
    public String getKey() {
        return this.getAttributeName();
    }

    @Override
    public String[] getKeys() {
        return new String[]{this.getKey()};
    }
}

