/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.InfoView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.InfoViewable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.Item;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.InfoPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class ViewFormPanel
extends JPanel
implements InfoPanel {
    private static final String REFERENCE_STRING = "Ljava.lang.Object;@";
    private static final String NOT_READABLE = "[Not readable]";
    private VoData vo;
    private InfoView infoView;
    final String useInfoViewName;

    public ViewFormPanel(String string) {
        this.useInfoViewName = string;
    }

    public InfoView getInfoView() {
        return this.infoView;
    }

    public VoData getVoData() {
        return this.vo;
    }

    @Override
    public void update(VoData voData) {
        this.vo = voData;
        try {
            this.removeAll();
            if (voData instanceof InfoViewable) {
                InfoViewable infoViewable = (InfoViewable)((Object)voData);
                this.infoView = infoViewable.getInfoView(this.useInfoViewName);
                if (this.infoView != null) {
                    this.createInfoViewPanel();
                }
            } else {
                this.infoView = null;
            }
        }
        catch (Exception exception) {
            Trace.warning(this, "Unable to show panel " + this.useInfoViewName, exception);
        }
    }

    @Override
    public boolean isApplicable() {
        if (this.infoView != null && this.vo != null) {
            return this.infoView.isApplicable(this.vo);
        }
        return false;
    }

    protected void createInfoViewPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 10.0;
        gridBagConstraints2.anchor = 18;
        this.setLayout(new GridBagLayout());
        List<Item> list = this.infoView.getItems();
        for (int i = 0; i < list.size(); ++i) {
            Item item = list.get(i);
            String string = item.getLabel();
            Object object = item.getValue(this.vo);
            if (object == null && item.isOptional() || item.excludeInSummary()) continue;
            if (object == null || object.equals("")) {
                object = "-";
            }
            gridBagConstraints.gridy = i;
            this.add((Component)new JLabel(string), gridBagConstraints);
            gridBagConstraints2.gridy = i;
            String string2 = object.toString();
            if (string2.contains(REFERENCE_STRING)) {
                string2 = NOT_READABLE;
            }
            JTextField jTextField = new JTextField(string2);
            if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
                jTextField.setName(string + "_Value");
            }
            jTextField.setEditable(false);
            jTextField.setBorder(null);
            jTextField.setBackground(this.getBackground());
            this.add((Component)jTextField, gridBagConstraints2);
        }
        String string = this.infoView.getGroupLabel();
        this.setBorder(new TitledBorder(string));
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
            this.setName(string + "_Group");
        }
    }
}

