/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.PimcuPort;

public class PimcuManager {
    private List<Integer> ruList = new LinkedList<Integer>();
    private Map<PimcuPort, PimcuPort> ruleMap;
    private boolean isCompared = false;
    private static PimcuManager instance = new PimcuManager();

    private PimcuManager() {
    }

    public static PimcuManager getInstance() {
        return instance;
    }

    private PimcuPort getRUFromRuleMap(PimcuPort pimcuPort) {
        PimcuPort pimcuPort2 = null;
        if (this.ruleMap == null) {
            this.ruleMap = new HashMap<PimcuPort, PimcuPort>();
            this.ruleMap.put(PimcuPort.PIMCU_BB_A, PimcuPort.PIMCU_RU_A);
            this.ruleMap.put(PimcuPort.PIMCU_BB_B, PimcuPort.PIMCU_RU_B);
            this.ruleMap.put(PimcuPort.PIMCU_BB_C, PimcuPort.PIMCU_RU_C);
            this.ruleMap.put(PimcuPort.PIMCU_BB_D, PimcuPort.PIMCU_RU_D);
            this.ruleMap.put(PimcuPort.PIMCU_BB_E, PimcuPort.PIMCU_RU_E);
            this.ruleMap.put(PimcuPort.PIMCU_BB_F, PimcuPort.PIMCU_RU_F);
        }
        if (pimcuPort != null) {
            pimcuPort2 = this.ruleMap.get((Object)pimcuPort);
        }
        return pimcuPort2;
    }

    public boolean compareToRUPortOfPimcu(PimcuPort pimcuPort) {
        boolean bl = false;
        if (pimcuPort != null && (pimcuPort.equals((Object)PimcuPort.PIMCU_RU_A) || pimcuPort.equals((Object)PimcuPort.PIMCU_RU_B) || pimcuPort.equals((Object)PimcuPort.PIMCU_RU_C) || pimcuPort.equals((Object)PimcuPort.PIMCU_RU_D) || pimcuPort.equals((Object)PimcuPort.PIMCU_RU_E) || pimcuPort.equals((Object)PimcuPort.PIMCU_RU_F))) {
            bl = true;
        }
        return bl;
    }

    public void addRUPortOfPimcu(PimcuPort pimcuPort) {
        if (this.isCompared) {
            this.isCompared = false;
            this.cleanRUList();
        }
        if (pimcuPort != null && !this.ruList.contains(pimcuPort.getValue())) {
            this.ruList.add(pimcuPort.getValue());
        }
    }

    public boolean compareToBBPortOfPimcu(PimcuPort pimcuPort) {
        boolean bl = false;
        if (pimcuPort != null && (pimcuPort.equals((Object)PimcuPort.PIMCU_BB_A) || pimcuPort.equals((Object)PimcuPort.PIMCU_BB_B) || pimcuPort.equals((Object)PimcuPort.PIMCU_BB_C) || pimcuPort.equals((Object)PimcuPort.PIMCU_BB_D) || pimcuPort.equals((Object)PimcuPort.PIMCU_BB_E) || pimcuPort.equals((Object)PimcuPort.PIMCU_BB_F))) {
            bl = true;
        }
        return bl;
    }

    public boolean isExistRefRU(PimcuPort pimcuPort) {
        boolean bl = false;
        if (pimcuPort != null) {
            this.isCompared = true;
            PimcuPort pimcuPort2 = this.getRUFromRuleMap(pimcuPort);
            if (pimcuPort2 != null) {
                bl = this.ruList.contains(pimcuPort2.getValue());
            }
        }
        return bl;
    }

    private void cleanRUList() {
        if (!this.ruList.isEmpty()) {
            this.ruList.clear();
        }
    }
}

