/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader;

import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter.SummaryConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader.VimModelLoader;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader.VimModelSummaryLoader;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.ModelException;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.SummaryXmlSchemaInfo;

public class VimModelSummaryLoaderImpl
implements Runnable,
VimModelSummaryLoader,
SummaryXmlSchemaInfo {
    private VimModelLoader vimModelLoader;
    Node nodeSummary;
    private JPanel[] panels;
    private Thread summaryThread;
    private boolean loadingOfSummaryCompleted = false;
    private Exception loadingOfSummaryException;
    private Hashtable valueConvertersHash;
    private boolean isMultiConfig;

    public VimModelSummaryLoaderImpl(VimModelLoader vimModelLoader, Hashtable hashtable, boolean bl) {
        this.vimModelLoader = vimModelLoader;
        this.valueConvertersHash = hashtable;
        this.isMultiConfig = bl;
    }

    @Override
    public void loadSummary() {
        this.summaryThread = new Thread((Runnable)this, "VimSummaryLoader");
        this.summaryThread.start();
    }

    @Override
    public boolean waitForLoadingOfSummaryComplete() throws InterruptedException {
        if (this.summaryThread == null) {
            return true;
        }
        this.summaryThread.join();
        return this.loadingOfSummaryCompleted;
    }

    @Override
    public Exception getLoadingErrorForSummary() {
        return this.loadingOfSummaryException;
    }

    protected void setLoadingErrorForSummary(Exception exception) {
        this.loadingOfSummaryException = exception;
    }

    @Override
    public JPanel[] getSummaryPanels() {
        return this.panels;
    }

    @Override
    public void run() {
        try {
            this.loadingOfSummaryCompleted = false;
            this.nodeSummary = this.vimModelLoader.loadAndValidateXmlFile("se/ericsson/wcdma/rbs/cabinetviewer/model/Summary.xml", "summary");
            this.panels = this.createSummary(this.nodeSummary, this.valueConvertersHash);
            this.loadingOfSummaryCompleted = true;
        }
        catch (SAXException sAXException) {
            this.setLoadingErrorForSummary(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.setLoadingErrorForSummary(parserConfigurationException);
        }
        catch (IOException iOException) {
            this.setLoadingErrorForSummary(iOException);
        }
        catch (ModelException modelException) {
            this.setLoadingErrorForSummary(modelException);
        }
        catch (Exception exception) {
            this.setLoadingErrorForSummary(exception);
        }
    }

    protected JPanel[] createSummary(Node node, Hashtable hashtable) {
        SummaryConverter summaryConverter = new SummaryConverter();
        Hashtable hashtable2 = new Hashtable();
        summaryConverter.load(hashtable2, node, this.isMultiConfig);
        return summaryConverter.createSummaryPanels(hashtable);
    }
}

