/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.TableConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ValueConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.AbstractSummary;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.InputElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.ResultElement;

public class TableElement
extends AbstractSummary {
    private InputElement inputElement;
    private ResultElement resultElement;

    public TableElement(Node node) {
        super(node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("input")) {
                this.inputElement = new InputElement(node2);
                continue;
            }
            if (!string.equals("result")) continue;
            this.resultElement = new ResultElement(node2);
        }
    }

    protected ValueConverter getConverter() {
        Object[][] objectArray = this.inputElement.getResultMatrix();
        Object[] objectArray2 = this.resultElement.getResultValues();
        if (objectArray == null || objectArray2 == null) {
            Trace.warning(this, "The xml element <input>. Input is " + objectArray + " result is " + objectArray2);
            return null;
        }
        if (!this.isMatrixConsisten(objectArray)) {
            Trace.warning(this, "The xml element <input> under the element <table>. Input matrix has inconsisten dimension");
            return null;
        }
        if (objectArray.length != objectArray2.length) {
            Trace.warning(this, "The xml element <input>. Inconsistent no. of rows between input (" + objectArray.length + ") and result (" + objectArray2.length + ") ");
            return null;
        }
        Object[][] objectArray3 = this.insertColumn(objectArray, objectArray2);
        return new TableConverter(objectArray3);
    }

    private Object[][] insertColumn(Object[][] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        int n2 = objectArray[0].length + 1;
        Object[][] objectArray3 = new Object[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < objectArray[0].length; ++j) {
                objectArray3[i][j] = objectArray[i][j];
            }
            objectArray3[i][n2 - 1] = objectArray2[i];
        }
        return objectArray3;
    }

    private boolean isMatrixConsisten(Object[][] objectArray) {
        int n = objectArray[0].length;
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].length != n) {
                bl = false;
            }
            n = objectArray[i].length;
        }
        return bl;
    }
}

