/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.aal2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.atm.aal2.Aal2ApMo;
import se.ericsson.cello.atm.aal2.Aal2PathDistributionUnitMoImpl;
import se.ericsson.cello.atm.aal2.Aal2PathIdNotUniqueException;
import se.ericsson.cello.atm.aal2.Aal2PathVccTpMoImpl;
import se.ericsson.cello.atm.aal2.Aal2QosCodePointProfileMo;
import se.ericsson.cello.atm.aal2.Aal2QosCodePointProfileMoImpl;
import se.ericsson.cello.atm.aal2.UniSaalTpBuildIF;
import se.ericsson.cello.atm.mom.EnumAal2AllocationMode;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.UniSaalTpRepository;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GenPmMaoHandler;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MaoPmStrategyForReqContext;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Mtp3bApBuildIF;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.Aal2ApReservingRpu;
import se.ericsson.cello.swmanagement.ReliableProgramUniterMo;
import se.ericsson.cello.swmanagement.ReliableProgramUniterMoInternal;
import se.ericsson.cello.swmanagement.ReliableProgramUniterRepository;
import se.ericsson.cello.transaction.Coordinator;

public class Aal2ApMoImpl
extends CelloMao
implements Aal2ApMo,
Aal2ApReservingRpu,
FroInfo {
    private MoData data;
    private FroProxy aal2ApProxy = null;
    private static TransactionalFroIdMap froIdTable = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private Map myPmProxyFroIdMap = new HashMap(3);
    private static final int MO_DATA_REVISION_6_0 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;
    private static final int TIMER_ERQ_MIN = 5000;
    private static final int TIMER_ERQ_MAX = 30000;
    private static final int TIMER_ERQ_DEFAULT = 5000;
    private static final int TIMER_REL_MIN = 2000;
    private static final int TIMER_REL_MAX = 60000;
    private static final int TIMER_REL_DEFAULT = 2000;
    private static final int ALLOCATION_MODE_MIN = 0;
    private static final int ALLOCATION_MODE_MAX = 1;
    private static final int ALLOCATION_MODE_DEFAULT = 0;
    private static final int MAX_NO_OF_AAL2_AP = 900;
    static /* synthetic */ Class class$se$ericsson$cello$swmanagement$ReliableProgramUniterRepository;
    static /* synthetic */ Class class$se$ericsson$cello$managedelement$UniSaalTpRepository;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Aal2Sp");
        MoAttributeValidator.checkIdentity((String)"Aal2Ap", (String)string);
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"Aal2Ap", (int)900);
        Class[] classArray = new Class[]{UniSaalTpBuildIF.class, Mtp3bApBuildIF.class};
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"sigLinkId", (AttrList)attrList, (boolean)true, (Class[])classArray, (String)"Aal2Ap");
        String[] stringArray = new String[]{"ReliableProgramUniter"};
        ManagedObject managedObject4 = MoAttributeValidator.checkAndGetReferenceAttribute2((String)"rpuId", (AttrList)attrList, (boolean)false, (String[])stringArray, (String)"Aal2Ap");
        if (managedObject4 != null) {
            Aal2ApMoImpl.checkRpu(managedObject4, coordinator);
        }
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Aal2Ap", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"timerErq", (AttrList)attrList, (boolean)false, (int)5000, (int)5000, (int)30000, (String)"Aal2Ap");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"timerRel", (AttrList)attrList, (boolean)false, (int)2000, (int)2000, (int)60000, (String)"Aal2Ap");
        Class[] classArray2 = new Class[]{UniSaalTpBuildIF.class};
        ManagedObject managedObject5 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"secondarySigLinkId", (AttrList)attrList, (boolean)false, (Class[])classArray2, (String)"Aal2Ap");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"allocationMode", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"Aal2Ap");
        ManagedObject managedObject6 = Aal2ApMoImpl.checkAndGetAal2QosCppId(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Aal2Ap");
        if (n3 != 1) {
            if (managedObject4 == null) {
                throw new IllegalAttributeValueException("If the allocationMode is MANUAL, rpuId must be set.", "Aal2Ap");
            }
        } else if (managedObject4 != null) {
            throw new IllegalAttributeValueException("If the allocationMode is AUTOMATIC, rpuId must not be set.", "Aal2Ap");
        }
        Aal2ApMoImpl.checkAllocationMode(n3, managedObject3);
        if (managedObject5 == managedObject3) {
            throw new ValueOutOfRangeException("secondarySigLinkId", "Aal2Ap");
        }
        Aal2ApMoImpl aal2ApMoImpl = new Aal2ApMoImpl(managedObject, string2, managedObject6, managedObject3, managedObject5, managedObject4, n, n2, n3, string, coordinator, initialMaoContext, froProxy);
        return aal2ApMoImpl;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject;
        Reservable reservable;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (((ManagedObject[])this.getAttribute("reservedBy", coordinator)).length != 0) {
            throw new MoReservedNotDeletableException("Aal2Ap");
        }
        ManagedObject managedObject2 = (ManagedObject)this.getAttribute("sigLinkId", coordinator);
        if (managedObject2 instanceof Mtp3bApBuildIF || managedObject2 instanceof UniSaalTpBuildIF) {
            reservable = (Reservable)managedObject2;
            reservable.release((ManagedObject)this, coordinator);
        }
        if ((reservable = (ManagedObject)this.getAttribute("aal2QoSCodePointProfileId", coordinator)) != null && reservable.getType().equals("Aal2QosCodePointProfile")) {
            managedObject = reservable;
            managedObject.release((ManagedObject)this, coordinator);
        }
        if ((managedObject = (ManagedObject)this.getAttribute("secondarySigLinkId", coordinator)) != null && managedObject instanceof UniSaalTpBuildIF) {
            Reservable reservable2 = (Reservable)managedObject;
            reservable2.release((ManagedObject)this, coordinator);
        }
        this.aal2ApProxy.delete(coordinator, this.getFroId(coordinator), null);
        froIdTable.remove(this.getAal2ApFroId(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private Aal2ApMoImpl(ManagedObject managedObject, String string, ManagedObject managedObject2, ManagedObject managedObject3, ManagedObject managedObject4, ManagedObject managedObject5, int n, int n2, int n3, String string2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        super(managedObject, "Aal2Ap", string2, coordinator, initialMaoContext);
        int n4;
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.aal2ApProxy = froProxy;
        this.data.setRevision(6000);
        ReferenceAttribute referenceAttribute = new ReferenceAttribute("sigLinkId", false);
        referenceAttribute.setValue(managedObject3);
        this.data.registerPersistentAttr((Attribute)referenceAttribute);
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        ArrayList<UnsignedIntParameter> arrayList = new ArrayList<UnsignedIntParameter>();
        if (managedObject5 != null) {
            int n5 = (int)((ReliableProgramUniterMoInternal)managedObject5).getRpuId(coordinator);
            arrayList.add(new UnsignedIntParameter("rpuId", (long)n5));
        }
        ManagedObject managedObject6 = referenceAttribute.getValue(coordinator);
        ((Reservable)managedObject3).reserve((ManagedObject)this, coordinator);
        if (managedObject6 instanceof UniSaalTpBuildIF) {
            n4 = ((UniSaalTpBuildIF)managedObject3).getFroId(coordinator);
            arrayList.add(new UnsignedIntParameter("sigLinkId", (long)n4));
        } else if (managedObject6 instanceof Mtp3bApBuildIF) {
            n4 = ((Mtp3bApBuildIF)managedObject3).getMtp3bApFroId(coordinator);
            arrayList.add(new UnsignedIntParameter("mtp3ApFroId", (long)n4));
        }
        if (managedObject2 != null) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
            n4 = ((Aal2QosCodePointProfileMoImpl)managedObject2).getAal2QosCppFroId(coordinator);
            arrayList.add(new UnsignedIntParameter("aal2QoSCodePointProfileId", (long)n4));
        }
        if (managedObject4 != null) {
            ((Reservable)managedObject4).reserve((ManagedObject)this, coordinator);
            n4 = ((UniSaalTpBuildIF)managedObject4).getFroId(coordinator);
            arrayList.add(new UnsignedIntParameter("secondarySigLinkId", (long)n4));
        }
        arrayList.add(new UnsignedIntParameter("timerErq", (long)n));
        arrayList.add(new UnsignedIntParameter("timerRel", (long)n2));
        arrayList.add(new UnsignedIntParameter("allocationMode", (long)n3));
        FroData froData = this.aal2ApProxy.create(coordinator, arrayList);
        int n6 = froData.getFroId();
        froIdTable.put(n6, (ManagedObject)this, coordinator);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n6));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string));
        this.data.setRevision(6000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getAal2ApId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("Aal2ApId", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public int getTimerErq(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("timerErq", coordinator);
    }

    public int getTimerRel(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("timerRel", coordinator);
    }

    public ManagedObject getSigLinkId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("sigLinkId", coordinator);
    }

    public ManagedObject getSecondarySigLinkId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("secondarySigLinkId", coordinator);
    }

    public void setSecondarySigLinkId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("secondarySigLinkId", managedObject, coordinator);
    }

    public ManagedObject getRpuId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("rpuId", coordinator);
    }

    public void setRpuId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("rpuId", managedObject, coordinator);
    }

    public ManagedObject getAal2QoSCodePointProfileId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("aal2QoSCodePointProfileId", coordinator);
    }

    public void setAal2QoSCodePointProfileId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("aal2QoSCodePointProfileId", managedObject, coordinator);
    }

    public int getPmExisOrigConns(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmExisOrigConns", coordinator);
    }

    public int getPmExisTermConns(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmExisTermConns", coordinator);
    }

    public int getPmExisTransConns(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmExisTransConns", coordinator);
    }

    public int getPmUnRecMessages(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnRecMessages", coordinator);
    }

    public int getPmUnRecParams(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnRecParams", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    public int getPmSuccInConnsRemoteQosClassA(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSuccInConnsRemoteQosClassA", coordinator);
    }

    public int getPmSuccInConnsRemoteQosClassB(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSuccInConnsRemoteQosClassB", coordinator);
    }

    public int getPmSuccInConnsRemoteQosClassD(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSuccInConnsRemoteQosClassD", coordinator);
    }

    public int getPmSuccInConnsRemoteQosClassC(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSuccInConnsRemoteQosClassC", coordinator);
    }

    public int getPmSuccOutConnsRemoteQosClassA(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSuccOutConnsRemoteQosClassA", coordinator);
    }

    public int getPmSuccOutConnsRemoteQosClassB(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSuccOutConnsRemoteQosClassB", coordinator);
    }

    public int getPmSuccOutConnsRemoteQosClassC(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSuccOutConnsRemoteQosClassC", coordinator);
    }

    public int getPmSuccOutConnsRemoteQosClassD(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSuccOutConnsRemoteQosClassD", coordinator);
    }

    public int getPmUnSuccInConnsLocalQosClassA(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccInConnsLocalQosClassA", coordinator);
    }

    public int getPmUnSuccInConnsLocalQosClassB(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccInConnsLocalQosClassB", coordinator);
    }

    public int getPmUnSuccInConnsLocalQosClassD(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccInConnsLocalQosClassD", coordinator);
    }

    public int getPmUnSuccInConnsLocalQosClassC(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccInConnsLocalQosClassC", coordinator);
    }

    public int getPmUnSuccInConnsRemoteQosClassA(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccInConnsRemoteQosClassA", coordinator);
    }

    public int getPmUnSuccInConnsRemoteQosClassB(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccInConnsRemoteQosClassB", coordinator);
    }

    public int getPmUnSuccInConnsRemoteQosClassD(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccInConnsRemoteQosClassD", coordinator);
    }

    public int getPmUnSuccInConnsRemoteQosClassC(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccInConnsRemoteQosClassC", coordinator);
    }

    public int getPmUnSuccOutConnsLocalQosClassA(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccOutConnsLocalQosClassA", coordinator);
    }

    public int getPmUnSuccOutConnsLocalQosClassB(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccOutConnsLocalQosClassB", coordinator);
    }

    public int getPmUnSuccOutConnsLocalQosClassD(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccOutConnsLocalQosClassD", coordinator);
    }

    public int getPmUnSuccOutConnsLocalQosClassC(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccOutConnsLocalQosClassC", coordinator);
    }

    public int getPmUnSuccOutConnsRemoteQosClassA(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccOutConnsRemoteQosClassA", coordinator);
    }

    public int getPmUnSuccOutConnsRemoteQosClassB(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccOutConnsRemoteQosClassB", coordinator);
    }

    public int getPmUnSuccOutConnsRemoteQosClassC(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccOutConnsRemoteQosClassC", coordinator);
    }

    public int getPmUnSuccOutConnsRemoteQosClassD(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUnSuccOutConnsRemoteQosClassD", coordinator);
    }

    public int getAllocationMode(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("allocationMode", coordinator);
    }

    public void setAllocationMode(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("allocationMode", new Integer(n), coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = this.aal2ApProxy.getAttributes(coordinator, this.getFroId(coordinator));
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            ReliableProgramUniterRepository reliableProgramUniterRepository;
            UnsignedIntParameter unsignedIntParameter;
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(this.getFroId(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nrOfRemotelyBlockedAal2Paths")) {
                objectArray[i] = new Integer(this.getNrOfRemotelyBlockedAal2Paths(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rpuId")) {
                unsignedIntParameter = (UnsignedIntParameter)map.get("rpuId");
                if (unsignedIntParameter == null || unsignedIntParameter.getValue() == 0L) {
                    objectArray[i] = null;
                    continue;
                }
                reliableProgramUniterRepository = (ReliableProgramUniterRepository)this.getMaoContext().getServiceRepository().getService(class$se$ericsson$cello$swmanagement$ReliableProgramUniterRepository == null ? Aal2ApMoImpl.class$("se.ericsson.cello.swmanagement.ReliableProgramUniterRepository") : class$se$ericsson$cello$swmanagement$ReliableProgramUniterRepository);
                if (reliableProgramUniterRepository != null) {
                    objectArray[i] = reliableProgramUniterRepository.lookupInstance((int)unsignedIntParameter.getValue(), coordinator);
                    continue;
                }
                MessageLog.traceError(this.getClass(), (String)"ReliableProgramUniterRepository not registered in ServiceRepository.");
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("sigLinkId")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("sigLinkId")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("secondarySigLinkId")) {
                unsignedIntParameter = (UnsignedIntParameter)map.get("secondarySigLinkId");
                if (unsignedIntParameter == null || unsignedIntParameter.getValue() == 0L) {
                    objectArray[i] = null;
                    continue;
                }
                reliableProgramUniterRepository = (UniSaalTpRepository)this.getMaoContext().getServiceRepository().getService(class$se$ericsson$cello$managedelement$UniSaalTpRepository == null ? Aal2ApMoImpl.class$("se.ericsson.cello.managedelement.UniSaalTpRepository") : class$se$ericsson$cello$managedelement$UniSaalTpRepository);
                if (reliableProgramUniterRepository != null) {
                    objectArray[i] = reliableProgramUniterRepository.lookupInstance((int)unsignedIntParameter.getValue(), coordinator);
                    continue;
                }
                MessageLog.traceError(this.getClass(), (String)"UniSaalTpRepository not registered in ServiceRepository.");
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nrOfConfiguredAal2Paths")) {
                objectArray[i] = new Integer(this.getNrOfConfiguredAal2Paths(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nrOfUnavailableAal2Paths")) {
                objectArray[i] = new Integer(this.getNrOfUnavailableAal2Paths(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2QoSCodePointProfileId")) {
                unsignedIntParameter = (UnsignedIntParameter)map.get("aal2QoSCodePointProfileId");
                if (unsignedIntParameter == null || unsignedIntParameter.getValue() == 0L) {
                    objectArray[i] = null;
                    continue;
                }
                objectArray[i] = Aal2QosCodePointProfileMoImpl.lookupInstance((int)unsignedIntParameter.getValue(), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                unsignedIntParameter = (UnsignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                unsignedIntParameter = (UnsignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("timerErq")) {
                unsignedIntParameter = (UnsignedIntParameter)map.get("timerErq");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("timerRel")) {
                unsignedIntParameter = (UnsignedIntParameter)map.get("timerRel");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("allocationMode")) {
                unsignedIntParameter = (UnsignedIntParameter)map.get("allocationMode");
                objectArray[i] = new Integer((int)unsignedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmExisOrigConns")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmExisOrigConns", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmExisTermConns")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmExisTermConns", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmExisTransConns")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmExisTransConns", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnRecMessages")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnRecMessages", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnRecParams")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnRecParams", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSuccInConnsRemoteQosClassA")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmSuccInConnsRemoteQosClassA", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSuccInConnsRemoteQosClassB")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmSuccInConnsRemoteQosClassB", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSuccInConnsRemoteQosClassC")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmSuccInConnsRemoteQosClassC", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSuccInConnsRemoteQosClassD")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmSuccInConnsRemoteQosClassD", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSuccOutConnsRemoteQosClassA")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmSuccOutConnsRemoteQosClassA", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSuccOutConnsRemoteQosClassB")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmSuccOutConnsRemoteQosClassB", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSuccOutConnsRemoteQosClassC")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmSuccOutConnsRemoteQosClassC", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSuccOutConnsRemoteQosClassD")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmSuccOutConnsRemoteQosClassD", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccInConnsLocalQosClassA")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccInConnsLocalQosClassA", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccInConnsLocalQosClassB")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccInConnsLocalQosClassB", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccInConnsLocalQosClassC")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccInConnsLocalQosClassC", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccInConnsLocalQosClassD")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccInConnsLocalQosClassD", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccInConnsRemoteQosClassA")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccInConnsRemoteQosClassA", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccInConnsRemoteQosClassB")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccInConnsRemoteQosClassB", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccInConnsRemoteQosClassC")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccInConnsRemoteQosClassC", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccInConnsRemoteQosClassD")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccInConnsRemoteQosClassD", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccOutConnsLocalQosClassA")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccOutConnsLocalQosClassA", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccOutConnsLocalQosClassB")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccOutConnsLocalQosClassB", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccOutConnsLocalQosClassC")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccOutConnsLocalQosClassC", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccOutConnsLocalQosClassD")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccOutConnsLocalQosClassD", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccOutConnsRemoteQosClassA")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccOutConnsRemoteQosClassA", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccOutConnsRemoteQosClassB")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccOutConnsRemoteQosClassB", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccOutConnsRemoteQosClassC")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccOutConnsRemoteQosClassC", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUnSuccOutConnsRemoteQosClassD")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUnSuccOutConnsRemoteQosClassD", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = pmRequestContextImpl.getCurrentPmRegister();
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Aal2Ap");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = 0;
        ArrayList<UnsignedIntParameter> arrayList = new ArrayList<UnsignedIntParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("userLabel", "Aal2Ap");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"Aal2Ap", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2QoSCodePointProfileId")) {
                if (objectArray[i] == null || !(objectArray[i] instanceof Aal2QosCodePointProfileMo)) {
                    throw new WrongAttributeTypeException("aal2QoSCodePointProfileId", "Aal2Ap");
                }
                n = ((Aal2QosCodePointProfileMoImpl)objectArray[i]).getAal2QosCppFroId(coordinator);
                if (this.getAttribute("aal2QoSCodePointProfileId", coordinator) == null) {
                    arrayList.add(new UnsignedIntParameter("aal2QoSCodePointProfileId", (long)n));
                    ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                } else if (!((Aal2QosCodePointProfileMoImpl)objectArray[i]).equals(this.getAttribute("aal2QoSCodePointProfileId", coordinator))) {
                    object = (ManagedObject)this.getAttribute("aal2QoSCodePointProfileId", coordinator);
                    if (object != null && object.getType().equals("Aal2QosCodePointProfile")) {
                        ((Reservable)object).release((ManagedObject)this, coordinator);
                    }
                    arrayList.add(new UnsignedIntParameter("aal2QoSCodePointProfileId", (long)n));
                    ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                }
                this.sendNotification("aal2QoSCodePointProfileId", objectArray[i], coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rpuId")) {
                if (objectArray[i] == null || !(objectArray[i] instanceof ReliableProgramUniterMo)) {
                    throw new WrongAttributeTypeException("rpuId", "Aal2Ap");
                }
                object = ((ReliableProgramUniterMo)objectArray[i]).getReliableProgramLabel(coordinator);
                String string = null;
                if (this.getAttribute("rpuId", coordinator) != null) {
                    string = (String)((ReliableProgramUniterMo)this.getAttribute("rpuId", coordinator)).getAttribute("reliableProgramLabel", coordinator);
                }
                if (!((String)object).equals(string) && string != null) {
                    throw new ConfigurationMismatchException("New ReliableProgramUniter must have the same reliableProgramLabel as the old-one has." + string, "Aal2Ap");
                }
                n = (int)((ReliableProgramUniterMo)objectArray[i]).getRpuId(coordinator);
                arrayList.add(new UnsignedIntParameter("rpuId", (long)n));
                this.sendNotification("rpuId", objectArray[i], coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("allocationMode")) {
                if (objectArray[i] == null || !(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("allocationMode", "Aal2Ap");
                }
                n = (Integer)objectArray[i];
                MoGenUtil.checkEnumAttribute((String)"allocationMode", (int)n, (int[])EnumAal2AllocationMode.VALUES_ARRAY, (String)"Aal2Ap");
                object = (ManagedObject)this.getAttribute("sigLinkId", coordinator);
                Aal2ApMoImpl.checkAllocationMode(n, (ManagedObject)object);
                arrayList.add(new UnsignedIntParameter("allocationMode", (long)n));
                this.sendNotification("allocationMode", objectArray[i], coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("secondarySigLinkId")) {
                object = (UniSaalTpBuildIF)this.getAttribute("secondarySigLinkId", coordinator);
                if (objectArray[i] == null) {
                    if (object != null) {
                        n = 0;
                        arrayList.add(new UnsignedIntParameter("secondarySigLinkId", (long)n));
                        object.release((ManagedObject)this, coordinator);
                    }
                } else {
                    if (!(objectArray[i] instanceof UniSaalTpBuildIF)) {
                        throw new WrongAttributeTypeException("secondarySigLinkId", "Aal2Ap");
                    }
                    if (object == null) {
                        n = ((UniSaalTpBuildIF)objectArray[i]).getFroId(coordinator);
                        arrayList.add(new UnsignedIntParameter("secondarySigLinkId", (long)n));
                        ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                    } else if (!((UniSaalTpBuildIF)objectArray[i]).equals(object)) {
                        n = ((UniSaalTpBuildIF)objectArray[i]).getFroId(coordinator);
                        arrayList.add(new UnsignedIntParameter("secondarySigLinkId", (long)n));
                        object.release((ManagedObject)this, coordinator);
                        ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                    }
                }
                this.sendNotification("secondarySigLinkId", objectArray[i], coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Aal2Ap");
        }
        if (arrayList.size() > 0) {
            this.aal2ApProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    public int getNrOfConfiguredAal2Paths(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject managedObject = null;
        ManagedObject[] managedObjectArray = null;
        int n = 0;
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getType().equals("Aal2PathDistributionUnit") || (managedObjectArray = (ManagedObject[])((Aal2PathDistributionUnitMoImpl)managedObject).getAttribute("aal2PathVccTpList", coordinator)) == null) continue;
            n += ((ManagedObject[])((Aal2PathDistributionUnitMoImpl)managedObject).getAttribute("aal2PathVccTpList", coordinator)).length;
        }
        return n;
    }

    public int getNrOfUnavailableAal2Paths(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject managedObject = null;
        ManagedObject[] managedObjectArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getType().equals("Aal2PathDistributionUnit") || (managedObjectArray = (ManagedObject[])((Aal2PathDistributionUnitMoImpl)managedObject).getAttribute("aal2PathVccTpList", coordinator)) == null) continue;
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!managedObjectArray[i].getType().equals("Aal2PathVccTp")) continue;
                n = (Integer)managedObjectArray[i].getAttribute("administrativeState", coordinator);
                n2 = (Integer)managedObjectArray[i].getAttribute("operationalState", coordinator);
                if (n != 0 && n2 != 0) continue;
                ++n3;
            }
        }
        return n3;
    }

    public int getNrOfRemotelyBlockedAal2Paths(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject managedObject = null;
        ManagedObject[] managedObjectArray = null;
        int n = 0;
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getType().equals("Aal2PathDistributionUnit")) continue;
            managedObjectArray = (ManagedObject[])((Aal2PathDistributionUnitMoImpl)managedObject).getAttribute("aal2PathVccTpList", coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!managedObjectArray[i].getType().equals("Aal2PathVccTp") || (Integer)((Aal2PathVccTpMoImpl)managedObjectArray[i]).getAttribute("remoteBlockingState", coordinator) != 2) continue;
                ++n;
            }
        }
        return n;
    }

    public int getAal2ApFroId(Coordinator coordinator) throws MoAccessException {
        return this.getFroId(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public String getIdentity(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getNamingAttributeValue();
    }

    public String getType() {
        return "Aal2Ap";
    }

    public Aal2ApMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.aal2ApProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("sigLinkId");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        froIdTable.put(((IntegerAttribute)this.data.getAttribute("froId")).getValue(null), (ManagedObject)this);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    private static ManagedObject checkAndGetAal2QosCppId(AttrList attrList) throws WrongAttributeTypeException, MoNotFoundException, ValueOutOfRangeException, MoAccessException {
        ManagedObject managedObject = null;
        int n = attrList.indexOf("aal2QoSCodePointProfileId");
        if (n == -1) {
            return null;
        }
        if (attrList.getValue(n) != null) {
            Class[] classArray = new Class[]{Aal2QosCodePointProfileMo.class};
            managedObject = MoAttributeValidator.checkAndGetReferenceAttribute((String)"aal2QoSCodePointProfileId", (AttrList)attrList, (boolean)false, (Class[])classArray, (String)"Aal2Ap");
        } else {
            attrList.removeElementAt(n);
        }
        return managedObject;
    }

    private static void checkAllocationMode(int n, ManagedObject managedObject) throws ConfigurationMismatchException {
        if (n == 1 && managedObject instanceof Mtp3bApBuildIF) {
            throw new ConfigurationMismatchException("Automatic allocation is not allowed when sigLinkId is an Mtp3bAp MO");
        }
    }

    private static void checkRpu(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, MoCanNotBeCreatedException {
        if (!((ReliableProgramUniterMoInternal)managedObject).checkRpuUsage(coordinator)) {
            MessageLog.info((Class)Aal2ApMoImpl.class, (String)"Aal2ApMo not possible to create - The RPU is not used");
            throw new MoCanNotBeCreatedException("Aal2Ap");
        }
    }

    private ManagedObject[] getAal2ApArray(ArrayParameter arrayParameter, Coordinator coordinator) throws MoAccessException, ConfigurationMismatchException {
        if (arrayParameter != null) {
            ManagedObject[] managedObjectArray = null;
            ArrayList<Aal2ApMoImpl> arrayList = new ArrayList<Aal2ApMoImpl>();
            Aal2ApMoImpl aal2ApMoImpl = null;
            for (int i = 0; i < arrayParameter.size(); ++i) {
                aal2ApMoImpl = Aal2ApMoImpl.lookupInstance((int)((UnsignedIntParameter)arrayParameter.get(i)).getValue(), coordinator);
                arrayList.add(aal2ApMoImpl);
            }
            managedObjectArray = new ManagedObject[arrayList.size()];
            arrayList.toArray(managedObjectArray);
            return managedObjectArray;
        }
        return null;
    }

    public void checkAllPathId(int[] nArray, Coordinator coordinator) throws Aal2PathIdNotUniqueException, MoAccessException {
        MoIterator moIterator = this.getChildren();
        ManagedObject managedObject = null;
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getType().equals("Aal2PathDistributionUnit")) continue;
            ((Aal2PathDistributionUnitMoImpl)managedObject).checkPathId(nArray, coordinator);
        }
    }

    public boolean isUniquePathId(int n, Coordinator coordinator) throws MoAccessException {
        int[] nArray = new int[]{n};
        boolean bl = true;
        try {
            this.checkAllPathId(nArray, coordinator);
        }
        catch (Aal2PathIdNotUniqueException aal2PathIdNotUniqueException) {
            bl = false;
        }
        return bl;
    }

    public void actionReallocate(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.aal2ApProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 1, null);
    }

    public void actionReallocateAll(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.aal2ApProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 3, null);
    }

    public ManagedObject[] actionAal2ApReservingRpu(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ArrayList<UnsignedIntParameter> arrayList = new ArrayList<UnsignedIntParameter>();
        arrayList.add(new UnsignedIntParameter("rpuId", (long)n));
        Map map = this.aal2ApProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 2, arrayList);
        ArrayParameter arrayParameter = (ArrayParameter)map.get("listOfApsReservingRpu");
        ManagedObject[] managedObjectArray = this.getAal2ApArray(arrayParameter, coordinator);
        return managedObjectArray;
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public static Aal2ApMoImpl lookupInstance(int n, Coordinator coordinator) throws MoAccessException {
        return (Aal2ApMoImpl)froIdTable.get(n, coordinator);
    }

    public void dependentAttributeValueChange(Coordinator coordinator) throws MoAccessException {
        this.sendNotification("nrOfConfiguredAal2Paths", new Integer(this.getNrOfConfiguredAal2Paths(coordinator)), coordinator);
    }
}

