/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.aal2;

import se.ericsson.cello.atm.aal2.Aal2ApMo;
import se.ericsson.cello.atm.aal2.Aal2QosCodePointProfileMo;
import se.ericsson.cello.atm.aal2.fropxy.AnsAal2QosCppMiCreateFroRsp;
import se.ericsson.cello.atm.aal2.fropxy.AnsAal2QosCppMiDeleteFroRsp;
import se.ericsson.cello.atm.aal2.fropxy.AnsAal2QosCppMiGetAttrRsp;
import se.ericsson.cello.atm.aal2.fropxy.AnsAal2QosCppMiProxy;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class Aal2QosCodePointProfileMoImpl
extends CelloMao
implements Aal2QosCodePointProfileMo,
FroInfo,
Reservable {
    private MoData data;
    private int[] qosCppArray = null;
    private IntegerAttribute aal2QosCppFroId;
    private StringAttribute userLabel;
    private SequenceAttribute reservedBy;
    private static final AnsAal2QosCppMiProxy aal2QosCppMiProxy = AnsAal2QosCppMiProxy.instance();
    private static TransactionalFroIdMap froIdTable = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private static final int MO_DATA_REVISION_42 = 4200;
    private static final int MO_DATA_REVISION_LATEST = 4200;
    private static final String AAL2_QOS_CPP_FRO_ID = "aal2QosCppFroId";
    private static final String AAL2_QOS_CPP_PARENT_TYPE_NAME = "TransportNetwork";
    private static final int MAX_NO_OF_AAL2_QOS_CPP = 20;
    private static final Class[] reservedClasses = new Class[]{Aal2ApMo.class};

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkIdentity((String)"Aal2QosCodePointProfile", (String)string);
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)AAL2_QOS_CPP_PARENT_TYPE_NAME);
        MoAttributeValidator.checkCardinality((String)"Aal2QosCodePointProfile", (int)20);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"qualityOfServiceCodePointA", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)255, (String)"Aal2QosCodePointProfile");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"qualityOfServiceCodePointB", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)255, (String)"Aal2QosCodePointProfile");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"qualityOfServiceCodePointC", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)255, (String)"Aal2QosCodePointProfile");
        int n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"qualityOfServiceCodePointD", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)255, (String)"Aal2QosCodePointProfile");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Aal2QosCodePointProfile", (int)128, (int)0);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Aal2QosCodePointProfile");
        return new Aal2QosCodePointProfileMoImpl(managedObject, string, string2, n, n2, n3, n4, coordinator);
    }

    private Aal2QosCodePointProfileMoImpl(ManagedObject managedObject, String string, String string2, int n, int n2, int n3, int n4, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Aal2QosCodePointProfile", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.aal2QosCppFroId = new IntegerAttribute(AAL2_QOS_CPP_FRO_ID, false);
        this.data.setRevision(4200);
        int n5 = this.createAal2QosCppFro(coordinator, n, n2, n3, n4);
        this.aal2QosCppFroId.setValue(n5);
        this.data.registerPersistentAttr((Attribute)this.aal2QosCppFroId);
        froIdTable.put(n5, (ManagedObject)this, coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public Aal2QosCodePointProfileMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(4200);
        moDataRecoveryHelper.assertAttribute(AAL2_QOS_CPP_FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.aal2QosCppFroId = (IntegerAttribute)moData.getAttribute(AAL2_QOS_CPP_FRO_ID);
        this.reservedBy = (SequenceAttribute)moData.getAttribute("reservedBy");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        froIdTable.put(((IntegerAttribute)this.data.getAttribute(AAL2_QOS_CPP_FRO_ID)).getValue(null), (ManagedObject)this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.reservedBy.isEmpty()) {
            throw new MoReservedNotDeletableException("Aal2QosCodePointProfile");
        }
        this.deleteAal2QosCppFro(coordinator, this.aal2QosCppFroId.getValue(coordinator));
        froIdTable.remove(this.getFroId(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getAal2QosCppFroId(Coordinator coordinator) throws MoAccessException {
        return this.getFroId(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.aal2QosCppFroId.getValue(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Aal2QosCodePointProfile", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getQualityOfServiceCodePointA(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.qosCppArray == null) {
            this.getQosCodePointArray(coordinator);
        }
        return this.qosCppArray[0];
    }

    public int getQualityOfServiceCodePointB(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.qosCppArray == null) {
            this.getQosCodePointArray(coordinator);
        }
        return this.qosCppArray[1];
    }

    public int getQualityOfServiceCodePointC(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.qosCppArray == null) {
            this.getQosCodePointArray(coordinator);
        }
        return this.qosCppArray[2];
    }

    public int getQualityOfServiceCodePointD(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.qosCppArray == null) {
            this.getQosCodePointArray(coordinator);
        }
        return this.qosCppArray[3];
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject[] managedObjectArray = Aal2QosCodePointProfileMoImpl.retrieveRefArrayFromSequence(this.reservedBy, coordinator);
        return managedObjectArray;
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Aal2QosCodePointProfile", (MoData)this.data, (SequenceAttribute)this.reservedBy, (Class[])reservedClasses);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Aal2QosCodePointProfile", (MoData)this.data, (SequenceAttribute)this.reservedBy, (Class[])reservedClasses);
    }

    public String getType() {
        return "Aal2QosCodePointProfile";
    }

    private int createAal2QosCppFro(Coordinator coordinator, int n, int n2, int n3, int n4) throws MoAccessException, FroRequestFailedException {
        int[] nArray = new int[]{n, n2, n3, n4};
        AnsAal2QosCppMiCreateFroRsp ansAal2QosCppMiCreateFroRsp = aal2QosCppMiProxy.sendCreateFroReq(coordinator.getTransactionID(), nArray);
        if (ansAal2QosCppMiCreateFroRsp == null) {
            FroNotAccessibleException froNotAccessibleException = new FroNotAccessibleException("Aal2QosCodePointProfile", "ANS_A2QOSCPMI_SERVICE_NAME");
            throw froNotAccessibleException;
        }
        if (ansAal2QosCppMiCreateFroRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal2QosCodePointProfile", "Aal2QosCppMi", "CreateFroRsp: " + aal2QosCppMiProxy.getResultMsg(ansAal2QosCppMiCreateFroRsp.getResult()), ansAal2QosCppMiCreateFroRsp.getResult());
        }
        return ansAal2QosCppMiCreateFroRsp.getFroId();
    }

    private void deleteAal2QosCppFro(Coordinator coordinator, int n) throws MoAccessException {
        AnsAal2QosCppMiDeleteFroRsp ansAal2QosCppMiDeleteFroRsp = aal2QosCppMiProxy.sendDeleteFroReq(coordinator.getTransactionID(), n);
        if (ansAal2QosCppMiDeleteFroRsp == null) {
            FroNotAccessibleException froNotAccessibleException = new FroNotAccessibleException("Aal2QosCodePointProfile", "ANS_A2QOSCPMI_SERVICE_NAME");
            throw froNotAccessibleException;
        }
        if (ansAal2QosCppMiDeleteFroRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal2QosCodePointProfile", "Aal2QosCppMi", "DeleteFroRsp: " + aal2QosCppMiProxy.getResultMsg(ansAal2QosCppMiDeleteFroRsp.getResult()), ansAal2QosCppMiDeleteFroRsp.getResult());
        }
    }

    private static ManagedObject[] retrieveRefArrayFromSequence(SequenceAttribute sequenceAttribute, Coordinator coordinator) throws MoRemovedException {
        ManagedObject[] managedObjectArray = new ManagedObject[]{};
        if (sequenceAttribute.size() != 0) {
            Attribute[] attributeArray = sequenceAttribute.getValue(coordinator);
            managedObjectArray = new ManagedObject[sequenceAttribute.size()];
            ReferenceAttribute referenceAttribute = null;
            for (int i = 0; i < sequenceAttribute.size(); ++i) {
                referenceAttribute = (ReferenceAttribute)attributeArray[i];
                managedObjectArray[i] = referenceAttribute.getValue(coordinator);
            }
        }
        return managedObjectArray;
    }

    private void getQosCodePointArray(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AnsAal2QosCppMiGetAttrRsp ansAal2QosCppMiGetAttrRsp = aal2QosCppMiProxy.sendGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.aal2QosCppFroId.getValue(coordinator));
        if (ansAal2QosCppMiGetAttrRsp == null) {
            throw new FroNotAccessibleException("Aal2QosCodePointProfile", "GetAttrReq");
        }
        if (ansAal2QosCppMiGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal2QosCodePointProfile", "Aal2QosCppMi", "GetAttrReq: " + aal2QosCppMiProxy.getResultMsg(ansAal2QosCppMiGetAttrRsp.getResult()), ansAal2QosCppMiGetAttrRsp.getResult());
        }
        this.qosCppArray = ansAal2QosCppMiGetAttrRsp.getQosCodePointProfile();
    }

    public static Aal2QosCodePointProfileMoImpl lookupInstance(int n, Coordinator coordinator) throws MoAccessException {
        return (Aal2QosCodePointProfileMoImpl)froIdTable.get(n, coordinator);
    }
}

