/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.atm;

import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Map;
import se.ericsson.cello.atm.aal2.Aal2ApMoImpl;
import se.ericsson.cello.atm.aal2.Aal2PathVccTpMo;
import se.ericsson.cello.atm.aal2.Aal2PathVccTpMoImpl;
import se.ericsson.cello.atm.atm.AtmConfServiceMo;
import se.ericsson.cello.atm.atm.AtmCrossConnectionMo;
import se.ericsson.cello.atm.atm.AtmCrossConnectionMoImpl;
import se.ericsson.cello.atm.atm.AtmPortMoImpl;
import se.ericsson.cello.atm.atm.AtmTrafficDescriptorMo;
import se.ericsson.cello.atm.atm.ImaGroupMo;
import se.ericsson.cello.atm.atm.ImaGroupMoImpl;
import se.ericsson.cello.atm.atm.ImaLinkMo;
import se.ericsson.cello.atm.atm.ImaLinkMoImpl;
import se.ericsson.cello.atm.atm.VclTpMo;
import se.ericsson.cello.atm.atm.VclTpMoImpl;
import se.ericsson.cello.atm.atm.VpcTpMo;
import se.ericsson.cello.atm.atm.VpcTpMoImpl;
import se.ericsson.cello.atm.atm.VplTpMo;
import se.ericsson.cello.atm.atm.VplTpMoImpl;
import se.ericsson.cello.atm.terminations.Aal5TpVccTpMo;
import se.ericsson.cello.atm.terminations.Aal5TpVccTpMoImpl;
import se.ericsson.cello.atm.terminations.Ds0BundleMo;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.pdhsdhtrans.E1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.E1TtpMo;
import se.ericsson.cello.pdhsdhtrans.E3PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.J1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.Os155SpiTtpMo;
import se.ericsson.cello.pdhsdhtrans.Sts3CspeTtpMo;
import se.ericsson.cello.pdhsdhtrans.T1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.T1TtpMo;
import se.ericsson.cello.pdhsdhtrans.T3PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.pdhsdhtrans.Vc4TtpMo;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class AtmConfServiceMoImpl
extends CelloMao
implements AtmConfServiceMo {
    private static AtmConfServiceMoImpl instance = null;
    private ManagedObject transportNetworkMoParent = null;
    private MoData data;
    private static final String MGW_DEFAULT_ID = "MgwDefault";
    private static final int MO_DATA_REVISION_60 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"AtmConfService", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        MoAttributeValidator.checkCardinality((String)"AtmConfService", (int)1);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"AtmConfService", (int)128, (int)0);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"AtmConfService");
        return new AtmConfServiceMoImpl(managedObject, string, string2, coordinator, initialMaoContext);
    }

    private AtmConfServiceMoImpl(ManagedObject managedObject, String string, String string2, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, "AtmConfService", string, coordinator, initialMaoContext);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.setRevision(6000);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.setRevision(6000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.transportNetworkMoParent = ((SingletonMoFactory)this.getMaoContext().getMoAccessor().lookupFactory("TransportNetwork")).getMo();
    }

    public AtmConfServiceMoImpl(MoData moData, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.transportNetworkMoParent = ((SingletonMoFactory)this.getMaoContext().getMoAccessor().lookupFactory("TransportNetwork")).getMo();
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getType() {
        return "AtmConfService";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"AtmConfService", (int)128, (int)0);
        ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string);
    }

    public ManagedObject[] actionAddAal2PathVccTp(String string, String string2, ManagedObject managedObject, int n, int n2, ManagedObject managedObject2, boolean bl, int n3, ManagedObject managedObject3, ManagedObject managedObject4, boolean bl2, Coordinator coordinator) throws MoAccessException {
        MessageLog.trace((int)4, this.getClass(), (String)("actionAddAal2PathVccTp(" + AtmConfServiceMoImpl.listToString(new Object[]{string, string2, managedObject, new Integer(n), new Integer(n2), managedObject2, bl, new Integer(n3), managedObject3, managedObject4, bl2, coordinator}) + ")"));
        Map map = this.createAtmStack(managedObject, n, (AtmTrafficDescriptorMo)managedObject3, n2, (AtmTrafficDescriptorMo)managedObject4, coordinator);
        AtmPortMoImpl atmPortMoImpl = (AtmPortMoImpl)map.get("AtmPort");
        String string3 = string;
        if (string.equalsIgnoreCase(MGW_DEFAULT_ID)) {
            string3 = this.generateAtmPortId((ManagedObject)atmPortMoImpl.getAttribute("uses", coordinator), coordinator) + "-vp" + n + "-vc" + n2;
        }
        AttrListImpl attrListImpl = new AttrListImpl(6);
        attrListImpl.addElement("aal2PathId", (Object)new Integer(n3));
        attrListImpl.addElement("aal2PathOwner", (Object)bl2);
        attrListImpl.addElement("aal2QoSProfileId", (Object)managedObject2);
        attrListImpl.addElement("continuityCheck", (Object)bl);
        attrListImpl.addElement("vclTpId", map.get("VclTp"));
        attrListImpl.addElement("userLabel", (Object)string2);
        Aal2PathVccTpMoImpl aal2PathVccTpMoImpl = (Aal2PathVccTpMoImpl)this.createMo("Aal2PathVccTp", string3, this.transportNetworkMoParent, (AttrList)attrListImpl, coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[]{aal2PathVccTpMoImpl, (ManagedObject)map.get("AtmPort"), (ManagedObject)map.get("VplTp"), (ManagedObject)map.get("VpcTp"), (ManagedObject)map.get("VclTp")};
        MessageLog.trace((int)4, this.getClass(), (String)("actionAddAal2PathVccTp returns with " + AtmConfServiceMoImpl.toString(managedObjectArray)));
        return managedObjectArray;
    }

    public ManagedObject[] actionAddAal5TpVccTp(String string, String string2, ManagedObject managedObject, int n, int n2, int n3, int n4, boolean bl, ManagedObject managedObject2, ManagedObject managedObject3, ManagedObject managedObject4, Coordinator coordinator) throws MoAccessException {
        MessageLog.trace((int)4, this.getClass(), (String)("actionAddAal5TpVccTp(" + AtmConfServiceMoImpl.listToString(new Object[]{string, string2, managedObject, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), bl, managedObject2, managedObject3, managedObject4, coordinator}) + ")"));
        Map map = this.createAtmStack(managedObject, n, (AtmTrafficDescriptorMo)managedObject3, n2, (AtmTrafficDescriptorMo)managedObject4, coordinator);
        AtmPortMoImpl atmPortMoImpl = (AtmPortMoImpl)map.get("AtmPort");
        String string3 = string;
        if (string.equalsIgnoreCase(MGW_DEFAULT_ID)) {
            string3 = this.generateAtmPortId((ManagedObject)atmPortMoImpl.getAttribute("uses", coordinator), coordinator) + "-vp" + n + "-vc" + n2;
        }
        AttrListImpl attrListImpl = null;
        if (managedObject2 == null) {
            attrListImpl = new AttrListImpl(5);
        } else {
            attrListImpl = new AttrListImpl(6);
            attrListImpl.addElement("processorId", (Object)managedObject2);
        }
        attrListImpl.addElement("fromUserMaxSduSize", (Object)new Integer(n3));
        attrListImpl.addElement("toUserMaxSduSize", (Object)new Integer(n4));
        attrListImpl.addElement("continuityCheck", (Object)bl);
        attrListImpl.addElement("vclTpId", map.get("VclTp"));
        attrListImpl.addElement("userLabel", (Object)string2);
        Aal5TpVccTpMoImpl aal5TpVccTpMoImpl = (Aal5TpVccTpMoImpl)this.createMo("Aal5TpVccTp", string3, this.transportNetworkMoParent, (AttrList)attrListImpl, coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[]{aal5TpVccTpMoImpl, (ManagedObject)map.get("AtmPort"), (ManagedObject)map.get("VplTp"), (ManagedObject)map.get("VpcTp"), (ManagedObject)map.get("VclTp")};
        MessageLog.trace((int)4, this.getClass(), (String)("actionAddAal5TpVccTp returns with " + AtmConfServiceMoImpl.toString(managedObjectArray)));
        return managedObjectArray;
    }

    public ManagedObject[] actionAddAtmCrossConnection(String string, String string2, ManagedObject managedObject, ManagedObject managedObject2, int n, int n2, int n3, int n4, ManagedObject managedObject3, ManagedObject managedObject4, ManagedObject managedObject5, ManagedObject managedObject6, Coordinator coordinator) throws MoAccessException {
        MessageLog.trace((int)4, this.getClass(), (String)("actionAddAtmCrossConnection(" + AtmConfServiceMoImpl.listToString(new Object[]{string, string2, managedObject, managedObject2, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), managedObject3, managedObject4, managedObject5, managedObject6, coordinator}) + ")"));
        if (managedObject == managedObject2 && n == n2 && managedObject3 == managedObject4 && n3 == n4 && managedObject5 == managedObject6) {
            MessageLog.trace((int)2, this.getClass(), (String)"actionAddAtmCrossConnection(): Warning: Side A and B are identical");
            throw new ActionNotAllowedException(this.getType(), "Side A and B are identical");
        }
        Map map = this.createAtmStack(managedObject, n, (AtmTrafficDescriptorMo)managedObject3, n3, (AtmTrafficDescriptorMo)managedObject5, coordinator);
        Map map2 = this.createAtmStack(managedObject2, n2, (AtmTrafficDescriptorMo)managedObject4, n4, (AtmTrafficDescriptorMo)managedObject6, coordinator);
        AtmPortMoImpl atmPortMoImpl = (AtmPortMoImpl)map.get("AtmPort");
        AtmPortMoImpl atmPortMoImpl2 = (AtmPortMoImpl)map2.get("AtmPort");
        String string3 = string;
        if (string.equalsIgnoreCase(MGW_DEFAULT_ID)) {
            string3 = this.generateAtmPortId((ManagedObject)atmPortMoImpl.getAttribute("uses", coordinator), coordinator) + "-vp" + n + "-vc" + n3 + "_" + this.generateAtmPortId((ManagedObject)atmPortMoImpl2.getAttribute("uses", coordinator), coordinator) + "-vp" + n2 + "-vc" + n4;
        }
        AttrListImpl attrListImpl = new AttrListImpl(3);
        attrListImpl.addElement("vclTpAId", map.get("VclTp"));
        attrListImpl.addElement("vclTpBId", map2.get("VclTp"));
        attrListImpl.addElement("userLabel", (Object)string2);
        AtmCrossConnectionMoImpl atmCrossConnectionMoImpl = (AtmCrossConnectionMoImpl)this.createMo("AtmCrossConnection", string3, this.transportNetworkMoParent, (AttrList)attrListImpl, coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[]{atmCrossConnectionMoImpl, (ManagedObject)map.get("AtmPort"), (ManagedObject)map.get("VplTp"), (ManagedObject)map.get("VpcTp"), (ManagedObject)map.get("VclTp"), (ManagedObject)map2.get("AtmPort"), (ManagedObject)map2.get("VplTp"), (ManagedObject)map2.get("VpcTp"), (ManagedObject)map2.get("VclTp")};
        MessageLog.trace((int)4, this.getClass(), (String)("actionAddAtmCrossConnection returns with " + AtmConfServiceMoImpl.toString(managedObjectArray)));
        return managedObjectArray;
    }

    public void actionDeleteAal2PathVccTp(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        Aal2PathVccTpMo aal2PathVccTpMo = (Aal2PathVccTpMo)managedObject;
        MessageLog.trace((int)4, this.getClass(), (String)("actionDeleteAal2PathVccTp(" + AtmConfServiceMoImpl.listToString(new Object[]{aal2PathVccTpMo, coordinator}) + ")"));
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)aal2PathVccTpMo.getAttribute("vclTpId", coordinator);
        aal2PathVccTpMo.delete(coordinator);
        this.deleteAtmStack(vclTpMoImpl, coordinator);
        MessageLog.trace((int)4, this.getClass(), (String)"exit actionDeleteAal2PathVccTp");
    }

    public void actionDeleteAal5TpVccTp(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        Aal5TpVccTpMo aal5TpVccTpMo = (Aal5TpVccTpMo)managedObject;
        MessageLog.trace((int)4, this.getClass(), (String)("actionDeleteAal5TpVccTp(" + AtmConfServiceMoImpl.listToString(new Object[]{aal5TpVccTpMo, coordinator}) + ")"));
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)aal5TpVccTpMo.getAttribute("vclTpId", coordinator);
        aal5TpVccTpMo.delete(coordinator);
        this.deleteAtmStack(vclTpMoImpl, coordinator);
        MessageLog.trace((int)4, this.getClass(), (String)"exit actionDeleteAal5TpVccTp");
    }

    public void actionDeleteAtmCrossConnection(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        AtmCrossConnectionMo atmCrossConnectionMo = (AtmCrossConnectionMo)managedObject;
        MessageLog.trace((int)4, this.getClass(), (String)("actionDeleteAtmCrossConnection(" + AtmConfServiceMoImpl.listToString(new Object[]{atmCrossConnectionMo, coordinator}) + ")"));
        VclTpMoImpl vclTpMoImpl = this.getVclTpFromAtmCC((AtmCrossConnectionMoImpl)atmCrossConnectionMo, "vclTpAId", coordinator);
        VclTpMoImpl vclTpMoImpl2 = this.getVclTpFromAtmCC((AtmCrossConnectionMoImpl)atmCrossConnectionMo, "vclTpBId", coordinator);
        atmCrossConnectionMo.delete(coordinator);
        this.deleteAtmStack(vclTpMoImpl, coordinator);
        this.deleteAtmStack(vclTpMoImpl2, coordinator);
        MessageLog.trace((int)4, this.getClass(), (String)"exit actionDeleteAtmCrossConnection");
    }

    public void actionReallocateAllAal2Aps(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = MoRepository.instance().lookupType("Aal2Ap");
        Aal2ApMoImpl aal2ApMoImpl = (Aal2ApMoImpl)moIterator.nextMo();
        aal2ApMoImpl.actionReallocateAll(coordinator);
    }

    public String getAtmConfServiceId(Coordinator coordinator) {
        return this.getNamingAttributeValue();
    }

    private Map createAtmStack(ManagedObject managedObject, int n, AtmTrafficDescriptorMo atmTrafficDescriptorMo, int n2, AtmTrafficDescriptorMo atmTrafficDescriptorMo2, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2;
        Object object;
        ManagedObject managedObject3;
        Object object2;
        MessageLog.trace((int)6, this.getClass(), (String)("createAtmStack(" + AtmConfServiceMoImpl.listToString(new Object[]{managedObject, new Integer(n), atmTrafficDescriptorMo, new Integer(n2), atmTrafficDescriptorMo2, coordinator}) + ")"));
        if (!(managedObject instanceof ImaGroupMo)) {
            object2 = MoRepository.instance().lookupType("ImaGroup");
            block0: while (object2.hasMoreElements()) {
                managedObject3 = object2.nextMo();
                if (!(managedObject3 instanceof ImaGroupMo)) continue;
                object = managedObject3.getChildren();
                while (object.hasMoreElements()) {
                    managedObject2 = object.nextMo();
                    if (!(managedObject2 instanceof ImaLinkMo) || managedObject != ((ImaLinkMoImpl)managedObject2).getUses(coordinator)) continue;
                    managedObject = managedObject3;
                    break block0;
                }
            }
        }
        object2 = this.createAtmPort(managedObject, coordinator);
        managedObject3 = this.createVplTp((AtmPortMoImpl)object2, n, atmTrafficDescriptorMo, coordinator);
        object = this.createVpcTp((VplTpMoImpl)managedObject3, coordinator);
        managedObject2 = this.createVclTp((VpcTpMoImpl)object, n2, atmTrafficDescriptorMo2, coordinator);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("AtmPort", object2);
        hashtable.put("VplTp", managedObject3);
        hashtable.put("VpcTp", object);
        hashtable.put("VclTp", managedObject2);
        return hashtable;
    }

    private AtmPortMoImpl createAtmPort(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        MessageLog.trace((int)6, this.getClass(), (String)("createAtmPort(" + AtmConfServiceMoImpl.listToString(new Object[]{managedObject, coordinator}) + ")"));
        if (!(managedObject instanceof TrafficReservable)) {
            MessageLog.trace((int)2, this.getClass(), (String)("createAtmPort(): Warning: Unsupported termination point " + (managedObject == null ? null : managedObject.getClass())));
            throw new ActionNotAllowedException(this.getType(), "Unsupported termination point");
        }
        TrafficReservable trafficReservable = (TrafficReservable)managedObject;
        AtmPortMoImpl atmPortMoImpl = (AtmPortMoImpl)trafficReservable.getReservedByTraffic(coordinator);
        if (atmPortMoImpl == null) {
            String string = this.generateAtmPortId(managedObject, coordinator);
            AttrListImpl attrListImpl = new AttrListImpl(2);
            attrListImpl.addElement("uses", (Object)managedObject);
            attrListImpl.addElement("userLabel", (Object)string);
            atmPortMoImpl = (AtmPortMoImpl)this.createMo("AtmPort", string, this.transportNetworkMoParent, (AttrList)attrListImpl, coordinator);
        }
        return atmPortMoImpl;
    }

    private VplTpMoImpl createVplTp(AtmPortMoImpl atmPortMoImpl, int n, AtmTrafficDescriptorMo atmTrafficDescriptorMo, Coordinator coordinator) throws MoAccessException {
        Object object;
        MessageLog.trace((int)6, this.getClass(), (String)("createVplTp(" + AtmConfServiceMoImpl.listToString(new Object[]{atmPortMoImpl, new Integer(n), atmTrafficDescriptorMo, coordinator}) + ")"));
        VplTpMoImpl vplTpMoImpl = null;
        MoIterator moIterator = atmPortMoImpl.getChildren();
        while (moIterator.hasMoreElements()) {
            object = moIterator.nextMo();
            if (!(object instanceof VplTpMo) || n != ((VplTpMoImpl)object).getExternalVpi(coordinator)) continue;
            vplTpMoImpl = (VplTpMoImpl)object;
            if (atmTrafficDescriptorMo == null || vplTpMoImpl.getAtmTrafficDescriptor(coordinator) == atmTrafficDescriptorMo) break;
            MessageLog.trace((int)2, this.getClass(), (String)("createVplTp(): Warning: An incompatible ATM traffic descriptor is declared: " + AtmConfServiceMoImpl.toString(atmTrafficDescriptorMo) + " != " + AtmConfServiceMoImpl.toString(vplTpMoImpl.getAtmTrafficDescriptor(coordinator))));
            throw new ActionNotAllowedException(this.getType(), "Incompatible ATM traffic descriptors declared for " + AtmConfServiceMoImpl.toString(vplTpMoImpl));
        }
        if (vplTpMoImpl == null) {
            object = "vp" + n;
            AttrListImpl attrListImpl = new AttrListImpl(3);
            attrListImpl.addElement("externalVpi", (Object)new Integer(n));
            attrListImpl.addElement("atmTrafficDescriptor", (Object)atmTrafficDescriptorMo);
            attrListImpl.addElement("userLabel", object);
            vplTpMoImpl = (VplTpMoImpl)this.createMo("VplTp", (String)object, atmPortMoImpl, (AttrList)attrListImpl, coordinator);
        }
        return vplTpMoImpl;
    }

    private VpcTpMoImpl createVpcTp(VplTpMoImpl vplTpMoImpl, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject;
        MessageLog.trace((int)6, this.getClass(), (String)("createVpcTp(" + AtmConfServiceMoImpl.listToString(new Object[]{vplTpMoImpl, coordinator}) + ")"));
        VpcTpMoImpl vpcTpMoImpl = null;
        MoIterator moIterator = vplTpMoImpl.getChildren();
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!(managedObject instanceof VpcTpMo)) continue;
            vpcTpMoImpl = (VpcTpMoImpl)managedObject;
        }
        if (vpcTpMoImpl == null) {
            managedObject = new AttrListImpl(0);
            vpcTpMoImpl = (VpcTpMoImpl)this.createMo("VpcTp", "1", vplTpMoImpl, (AttrList)managedObject, coordinator);
        }
        return vpcTpMoImpl;
    }

    private VclTpMoImpl createVclTp(VpcTpMoImpl vpcTpMoImpl, int n, AtmTrafficDescriptorMo atmTrafficDescriptorMo, Coordinator coordinator) throws MoAccessException {
        Object object;
        MessageLog.trace((int)6, this.getClass(), (String)("createVclTp(" + AtmConfServiceMoImpl.listToString(new Object[]{vpcTpMoImpl, new Integer(n), atmTrafficDescriptorMo, coordinator}) + ")"));
        VclTpMoImpl vclTpMoImpl = null;
        MoIterator moIterator = vpcTpMoImpl.getChildren();
        while (moIterator.hasMoreElements()) {
            object = moIterator.nextMo();
            if (!(object instanceof VclTpMo) || n != (Integer)((VclTpMoImpl)object).getAttribute("externalVci", coordinator)) continue;
            vclTpMoImpl = (VclTpMoImpl)object;
            if (atmTrafficDescriptorMo == null || vclTpMoImpl.getAttribute("atmTrafficDescriptorId", coordinator) == atmTrafficDescriptorMo) break;
            MessageLog.trace((int)2, this.getClass(), (String)("createVclTp(): Warning: An incompatible ATM traffic descriptor is declared: " + AtmConfServiceMoImpl.toString(atmTrafficDescriptorMo) + " != " + AtmConfServiceMoImpl.toString(vclTpMoImpl.getAttribute("atmTrafficDescriptorId", coordinator))));
            throw new ActionNotAllowedException(this.getType(), "Incompatible ATM traffic descriptors declared for " + AtmConfServiceMoImpl.toString(vclTpMoImpl));
        }
        if (vclTpMoImpl == null) {
            object = "vc" + n;
            AttrListImpl attrListImpl = new AttrListImpl(3);
            attrListImpl.addElement("externalVci", (Object)new Integer(n));
            attrListImpl.addElement("atmTrafficDescriptorId", (Object)atmTrafficDescriptorMo);
            attrListImpl.addElement("userLabel", object);
            vclTpMoImpl = (VclTpMoImpl)this.createMo("VclTp", (String)object, vpcTpMoImpl, (AttrList)attrListImpl, coordinator);
        }
        return vclTpMoImpl;
    }

    private void deleteAtmStack(VclTpMoImpl vclTpMoImpl, Coordinator coordinator) throws MoAccessException {
        MessageLog.trace((int)6, this.getClass(), (String)("deleteAtmStack(" + AtmConfServiceMoImpl.listToString(new Object[]{vclTpMoImpl, coordinator}) + ")"));
        VpcTpMoImpl vpcTpMoImpl = (VpcTpMoImpl)vclTpMoImpl.getParent();
        VplTpMoImpl vplTpMoImpl = (VplTpMoImpl)vpcTpMoImpl.getParent();
        AtmPortMoImpl atmPortMoImpl = (AtmPortMoImpl)vplTpMoImpl.getParent();
        this.deleteMo(vclTpMoImpl, coordinator);
        MoIterator moIterator = vpcTpMoImpl.getChildren();
        if (moIterator != null && moIterator.size() > 0) {
            return;
        }
        this.deleteMo(vpcTpMoImpl, coordinator);
        this.deleteMo(vplTpMoImpl, coordinator);
        moIterator = atmPortMoImpl.getChildren();
        if (moIterator == null || moIterator.size() == 0) {
            this.deleteMo(atmPortMoImpl, coordinator);
        }
    }

    private ManagedObject createMo(String string, String string2, ManagedObject managedObject, AttrList attrList, Coordinator coordinator) throws MoAccessException {
        String string3 = (managedObject == null ? null : managedObject.getLocalDistinguishedName()) + "," + string + "=" + string2;
        MessageLog.trace((int)8, this.getClass(), (String)("createMo(): Creating " + string3));
        MoFactory moFactory = MoFactoryMgr.instance().lookup(string);
        if (moFactory == null) {
            MessageLog.traceError(this.getClass(), (String)("createMo(): No factory is found for MO type " + string));
            throw new MoCanNotBeCreatedException(string);
        }
        try {
            return moFactory.createMo(managedObject, attrList, string2, null, coordinator);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.trace((int)2, this.getClass(), (String)("createMo(): Warning: Failed to create " + string3 + " (" + (Object)((Object)moAccessException) + ")"));
            throw moAccessException;
        }
    }

    private void deleteMo(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        MessageLog.trace((int)8, this.getClass(), (String)("deleteMo(): Deleting " + AtmConfServiceMoImpl.toString(managedObject)));
        try {
            managedObject.delete(coordinator);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.trace((int)2, this.getClass(), (String)("deleteMo(): Warning: Failed to delete " + AtmConfServiceMoImpl.toString(managedObject) + " (" + (Object)((Object)moAccessException) + ")"));
            throw moAccessException;
        }
    }

    private String generateAtmPortId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2 = managedObject instanceof ImaGroupMo ? ((ImaGroupMoImpl)managedObject).getPhysicalPortList(coordinator)[0] : managedObject;
        SlotMo slotMo = (SlotMo)AtmConfServiceMoImpl.findParent(managedObject2, "Slot");
        SubrackMo subrackMo = (SubrackMo)slotMo.getParent();
        String string = this.generateLineNo(managedObject, coordinator);
        return subrackMo.getNamingAttributeValue() + "-" + slotMo.getNamingAttributeValue() + "-" + string;
    }

    private String generateLineNo(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof E1PhysPathTermMo) {
            E1PhysPathTermMo e1PhysPathTermMo = (E1PhysPathTermMo)managedObject;
            return e1PhysPathTermMo.getLineNo(coordinator) + "";
        }
        if (managedObject instanceof J1PhysPathTermMo) {
            J1PhysPathTermMo j1PhysPathTermMo = (J1PhysPathTermMo)managedObject;
            return j1PhysPathTermMo.getLineNo(coordinator) + "";
        }
        if (managedObject instanceof T1PhysPathTermMo) {
            T1PhysPathTermMo t1PhysPathTermMo = (T1PhysPathTermMo)managedObject;
            return t1PhysPathTermMo.getLineNo(coordinator) + "";
        }
        if (managedObject instanceof E3PhysPathTermMo) {
            E3PhysPathTermMo e3PhysPathTermMo = (E3PhysPathTermMo)managedObject;
            return e3PhysPathTermMo.getLineNo(coordinator) + "";
        }
        if (managedObject instanceof T3PhysPathTermMo) {
            T3PhysPathTermMo t3PhysPathTermMo = (T3PhysPathTermMo)managedObject;
            return t3PhysPathTermMo.getLineNo(coordinator) + "";
        }
        if (managedObject instanceof E1TtpMo) {
            E1TtpMo e1TtpMo = (E1TtpMo)managedObject;
            Os155SpiTtpMo os155SpiTtpMo = (Os155SpiTtpMo)AtmConfServiceMoImpl.findParent(managedObject, "Os155SpiTtp");
            return os155SpiTtpMo.getLineNo(coordinator) + "-" + managedObject.getParent().getNamingAttributeValue();
        }
        if (managedObject instanceof T1TtpMo) {
            T1TtpMo t1TtpMo = (T1TtpMo)managedObject;
            Os155SpiTtpMo os155SpiTtpMo = (Os155SpiTtpMo)AtmConfServiceMoImpl.findParent(managedObject, "Os155SpiTtp");
            return os155SpiTtpMo.getLineNo(coordinator) + "-" + managedObject.getParent().getParent().getNamingAttributeValue() + "-" + managedObject.getParent().getNamingAttributeValue();
        }
        if (managedObject instanceof Vc4TtpMo) {
            Vc4TtpMo vc4TtpMo = (Vc4TtpMo)managedObject;
            Os155SpiTtpMo os155SpiTtpMo = (Os155SpiTtpMo)AtmConfServiceMoImpl.findParent(managedObject, "Os155SpiTtp");
            return os155SpiTtpMo.getLineNo(coordinator) + "";
        }
        if (managedObject instanceof Sts3CspeTtpMo) {
            Sts3CspeTtpMo sts3CspeTtpMo = (Sts3CspeTtpMo)managedObject;
            Os155SpiTtpMo os155SpiTtpMo = (Os155SpiTtpMo)AtmConfServiceMoImpl.findParent(managedObject, "Os155SpiTtp");
            return os155SpiTtpMo.getLineNo(coordinator) + "";
        }
        if (managedObject instanceof ImaGroupMo) {
            ImaGroupMo imaGroupMo = (ImaGroupMo)managedObject;
            return "ima" + managedObject.getNamingAttributeValue();
        }
        if (managedObject instanceof Ds0BundleMo) {
            return this.generateLineNo(managedObject.getParent(), coordinator) + "-" + managedObject.getNamingAttributeValue();
        }
        MessageLog.trace((int)2, this.getClass(), (String)("generateLineNo(): Warning: Unsupported termination point " + (managedObject == null ? null : managedObject.getClass())));
        throw new ActionNotAllowedException(this.getType(), "Unsupported termination point");
    }

    private static ManagedObject findParent(ManagedObject managedObject, String string) {
        while (managedObject != null && !managedObject.getType().equals(string)) {
            managedObject = managedObject.getParent();
        }
        return managedObject;
    }

    private static String listToString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(AtmConfServiceMoImpl.toString(objectArray[i]));
            if (i + 1 >= objectArray.length) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        if (object instanceof ManagedObject) {
            return ((ManagedObject)object).getLocalDistinguishedName();
        }
        if (object instanceof Coordinator) {
            return "TID<" + ((Coordinator)object).getTransactionID() + ">";
        }
        if (object.getClass().getComponentType() != null) {
            StringBuffer stringBuffer = new StringBuffer("[");
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(AtmConfServiceMoImpl.toString(Array.get(object, i)));
                if (i + 1 >= n) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        return object.toString();
    }

    private VclTpMoImpl getVclTpFromAtmCC(AtmCrossConnectionMoImpl atmCrossConnectionMoImpl, String string, Coordinator coordinator) throws MoAccessException {
        return (VclTpMoImpl)atmCrossConnectionMoImpl.getAttribute(string, coordinator);
    }
}

