/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.atm;

import enea.ose.system.Signal;
import se.ericsson.cello.atm.atm.AtmTrafficDescriptorMo;
import se.ericsson.cello.atm.atm.fropxy.AetAtmTdMiCreateFroRsp;
import se.ericsson.cello.atm.atm.fropxy.AetAtmTdMiDeleteFroRsp;
import se.ericsson.cello.atm.atm.fropxy.AetAtmTdMiGetAttrRsp;
import se.ericsson.cello.atm.atm.fropxy.AetAtmTdMiProxy;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.DynamicReserver;
import se.ericsson.cello.mao.DynamicallyReservable;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.QualityOfService;
import se.ericsson.cello.mao.StrictTransactionHandler;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.mao.TransactionalList;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class AtmTrafficDescriptorMoImpl
extends CelloMao
implements AtmTrafficDescriptorMo,
DynamicallyReservable {
    private MoData data;
    private StringAttribute userLabel;
    private IntegerAttribute atmTdFroId;
    private static AetAtmTdMiProxy atmTdFroProxy = AetAtmTdMiProxy.instance();
    private static final String ATM_TD_FRO_ID = "atmTrafficDescriptorFroId";
    private static final String USER_LABEL_DEFAULT = "";
    private TransactionalList reservedBy = new TransactionalList((TransactionHandler)new StrictTransactionHandler());
    private static TransactionalFroIdMap froIdTable = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private static final boolean PACKET_DISCARD_DEFAULT = false;
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_33 = 3300;
    private static final int MO_DATA_REVISION_LATEST = 3300;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        MoAttributeValidator.checkIdentity((String)"AtmTrafficDescriptor", (String)string);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"serviceCategory", (AttrList)attrList, (boolean)true, (int)1, (int)1, (int)3, (String)"AtmTrafficDescriptor");
        QualityOfService qualityOfService = AtmTrafficDescriptorMoImpl.checkAndGetQosAttribute(attrList, "egressAtmQos", n);
        QualityOfService qualityOfService2 = AtmTrafficDescriptorMoImpl.checkAndGetQosAttribute(attrList, "ingressAtmQos", n);
        int n2 = AtmTrafficDescriptorMoImpl.checkAndGetIntegerAttribute(attrList, "ingressAtmPcr", n);
        int n3 = AtmTrafficDescriptorMoImpl.checkAndGetIntegerAttribute(attrList, "ingressAtmMcr", n);
        int n4 = AtmTrafficDescriptorMoImpl.checkAndGetIntegerAttribute(attrList, "egressAtmPcr", n);
        int n5 = AtmTrafficDescriptorMoImpl.checkAndGetIntegerAttribute(attrList, "egressAtmMcr", n);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)USER_LABEL_DEFAULT, (String)"AtmTrafficDescriptor", (int)128, (int)0);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"packetDiscard", (AttrList)attrList, (boolean)false, (boolean)false, (String)"AtmTrafficDescriptor");
        int n6 = MaoFroTypeConverter.boolean2int((boolean)bl);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"AtmTrafficDescriptor");
        AtmTrafficDescriptorMoImpl atmTrafficDescriptorMoImpl = new AtmTrafficDescriptorMoImpl(managedObject, string2, n2, n3, qualityOfService2, n4, n5, qualityOfService, n, n6, string, coordinator);
        return atmTrafficDescriptorMoImpl;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.reservedBy.size(coordinator) > 0) {
            throw new MoReservedNotDeletableException("AtmTrafficDescriptor");
        }
        this.deleteAtmTdFro(coordinator);
        froIdTable.remove(this.getFroId(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"AtmTrafficDescriptor", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getIngressAtmPcr(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetAtmTdMiGetAttrRsp aetAtmTdMiGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return aetAtmTdMiGetAttrRsp.getIngressAtmPcr();
    }

    public int getIngressAtmMcr(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetAtmTdMiGetAttrRsp aetAtmTdMiGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return aetAtmTdMiGetAttrRsp.getIngressAtmMcr();
    }

    public int getIngressAtmQos(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetAtmTdMiGetAttrRsp aetAtmTdMiGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return aetAtmTdMiGetAttrRsp.getIngressAtmQoS();
    }

    public int getEgressAtmPcr(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetAtmTdMiGetAttrRsp aetAtmTdMiGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return aetAtmTdMiGetAttrRsp.getEgressAtmPcr();
    }

    public int getEgressAtmMcr(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetAtmTdMiGetAttrRsp aetAtmTdMiGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return aetAtmTdMiGetAttrRsp.getEgressAtmMcr();
    }

    public int getEgressAtmQos(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetAtmTdMiGetAttrRsp aetAtmTdMiGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return aetAtmTdMiGetAttrRsp.getEgressAtmQoS();
    }

    public int getServiceCategory(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetAtmTdMiGetAttrRsp aetAtmTdMiGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return aetAtmTdMiGetAttrRsp.getServiceCategory();
    }

    public boolean getPacketDiscard(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetAtmTdMiGetAttrRsp aetAtmTdMiGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return MaoFroTypeConverter.int2boolean((int)aetAtmTdMiGetAttrRsp.getPacketDiscard());
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return (ManagedObject[])this.reservedBy.toArray(coordinator, (Object[])new ManagedObject[0]);
    }

    public int getFroId(Coordinator coordinator) throws TransactionRequiredException, MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.atmTdFroId.getValue(coordinator);
    }

    public String getIdentity(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getNamingAttributeValue();
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.validateReserver(managedObject);
        if (!this.reservedBy.contains((Object)managedObject, coordinator)) {
            this.reservedBy.add((Object)managedObject, coordinator);
        }
    }

    public void recoverReservation(ManagedObject managedObject) throws InvalidReferenceException {
        this.validateReserver(managedObject);
        this.reservedBy.add((Object)managedObject);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.validateReserver(managedObject);
        this.reservedBy.remove((Object)managedObject, coordinator);
    }

    private void validateReserver(ManagedObject managedObject) throws InvalidReferenceException {
        if (managedObject == null || !(managedObject instanceof DynamicReserver)) {
            throw new InvalidReferenceException("AtmTrafficDescriptor", (Object)managedObject);
        }
    }

    public String getType() {
        return "AtmTrafficDescriptor";
    }

    public AtmTrafficDescriptorMoImpl(MoData moData) throws MoAccessException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3300);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(ATM_TD_FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.atmTdFroId = (IntegerAttribute)moData.getAttribute(ATM_TD_FRO_ID);
        froIdTable.put(this.atmTdFroId.getValue(null), (ManagedObject)this);
    }

    private AtmTrafficDescriptorMoImpl(ManagedObject managedObject, String string, int n, int n2, QualityOfService qualityOfService, int n3, int n4, QualityOfService qualityOfService2, int n5, int n6, String string2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "AtmTrafficDescriptor", string2, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.atmTdFroId = new IntegerAttribute(ATM_TD_FRO_ID, false);
        this.data.registerPersistentAttr((Attribute)this.atmTdFroId);
        int n7 = this.createAtmTdFro(coordinator, n, n2, qualityOfService, n3, n4, qualityOfService2, n5, n6);
        this.atmTdFroId.setValue(n7);
        froIdTable.put(n7, (ManagedObject)this, coordinator);
        this.data.setRevision(3300);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private int createAtmTdFro(Coordinator coordinator, int n, int n2, QualityOfService qualityOfService, int n3, int n4, QualityOfService qualityOfService2, int n5, int n6) throws MoAccessException {
        AetAtmTdMiCreateFroRsp aetAtmTdMiCreateFroRsp = atmTdFroProxy.sendCreateFroReq(coordinator.getTransactionID(), n5, n6, n, n2, qualityOfService.getValue(), n3, n4, qualityOfService2.getValue());
        if (aetAtmTdMiCreateFroRsp == null) {
            throw new FroNotAccessibleException("AtmTrafficDescriptor", "AET_ATMTDMI_SERVICE_NAME");
        }
        if (aetAtmTdMiCreateFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("AtmTrafficDescriptor", "AtmTraffDesc", "CreateFroReq: " + atmTdFroProxy.getResultMsg(aetAtmTdMiCreateFroRsp.getResult()), aetAtmTdMiCreateFroRsp.getResult());
        }
        return aetAtmTdMiCreateFroRsp.getFroId();
    }

    private void deleteAtmTdFro(Coordinator coordinator) throws MoAccessException {
        AetAtmTdMiDeleteFroRsp aetAtmTdMiDeleteFroRsp = atmTdFroProxy.sendDeleteFroReq(this.getFroId(coordinator), coordinator.getTransactionID());
        if (aetAtmTdMiDeleteFroRsp == null) {
            throw new FroNotAccessibleException("AtmTrafficDescriptor", "AET_ATMTDMI_SERVICE_NAME");
        }
        int n = aetAtmTdMiDeleteFroRsp.getResult();
        if (n != 0) {
            throw new FroRequestFailedException("AtmTrafficDescriptor", "AtmTraffDesc", "DeleteFroReq: " + atmTdFroProxy.getResultMsg(aetAtmTdMiDeleteFroRsp.getResult()), aetAtmTdMiDeleteFroRsp.getResult());
        }
    }

    private AetAtmTdMiGetAttrRsp retrieveFroAttributes(Coordinator coordinator) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException, TransactionRequiredException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetAtmTdMiGetAttrRsp aetAtmTdMiGetAttrRsp = atmTdFroProxy.sendGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.atmTdFroId.getValue(coordinator));
        AtmTrafficDescriptorMoImpl.checkSignal((Signal)aetAtmTdMiGetAttrRsp);
        int n = aetAtmTdMiGetAttrRsp.getResult();
        if (n != 0) {
            throw new FroRequestFailedException("AtmTrafficDescriptor", "AtmTraffDesc", "GetAttrReq: " + atmTdFroProxy.getResultMsg(aetAtmTdMiGetAttrRsp.getResult()), aetAtmTdMiGetAttrRsp.getResult());
        }
        return aetAtmTdMiGetAttrRsp;
    }

    public static void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal == null) {
            FroNotAccessibleException froNotAccessibleException = new FroNotAccessibleException("AtmTrafficDescriptor", "AET_ATMTDMI_SERVICE_NAME");
            throw froNotAccessibleException;
        }
    }

    private static int checkAndGetIntegerAttribute(AttrList attrList, String string, int n) throws AttrMissingAtCreateException, ValueOutOfRangeException, WrongAttributeTypeException, NotHandledAttributeTypeException, MoNotFoundException {
        int n2 = 0;
        int n3 = attrList.indexOf(string);
        if (string.equals("egressAtmPcr") || string.equals("ingressAtmPcr")) {
            if (n == 1) {
                if (n3 == -1) {
                    throw new AttrMissingAtCreateException(string, "AtmTrafficDescriptor");
                }
            } else if (n3 == -1) {
                return n2;
            }
        } else if (string.equals("egressAtmMcr") || string.equals("ingressAtmMcr")) {
            if (n == 3) {
                if (n3 == -1) {
                    throw new AttrMissingAtCreateException(string, "AtmTrafficDescriptor");
                }
            } else if (n3 == -1) {
                return n2;
            }
        } else {
            throw new WrongAttributeTypeException(string, "AtmTrafficDescriptor");
        }
        if (!(attrList.getValue(n3) instanceof Integer)) {
            throw new WrongAttributeTypeException(string, "AtmTrafficDescriptor");
        }
        n2 = (Integer)attrList.getValue(n3);
        if (n2 < 0) {
            throw new ValueOutOfRangeException(string, "AtmTrafficDescriptor");
        }
        attrList.removeElementAt(n3);
        return n2;
    }

    private static QualityOfService checkAndGetQosAttribute(AttrList attrList, String string, int n) throws AttrMissingAtCreateException, ValueOutOfRangeException, WrongAttributeTypeException, NotHandledAttributeTypeException, MoNotFoundException {
        int n2 = attrList.indexOf(string);
        if (n2 == -1) {
            throw new AttrMissingAtCreateException(string, "AtmTrafficDescriptor");
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException(string, "AtmTrafficDescriptor");
        }
        int n3 = (Integer)attrList.getValue(n2);
        QualityOfService qualityOfService = QualityOfService.getQualityOfService((int)n3);
        if (qualityOfService == null) {
            throw new ValueOutOfRangeException(string, "AtmTrafficDescriptor");
        }
        if (n == 2 ? qualityOfService.getValue() != 4 : (n == 3 ? qualityOfService.getValue() != 3 : n == 1 && (qualityOfService.getValue() < 1 || qualityOfService.getValue() > 2))) {
            throw new ValueOutOfRangeException(string, "AtmTrafficDescriptor");
        }
        attrList.removeElementAt(n2);
        return qualityOfService;
    }

    public static AtmTrafficDescriptorMoImpl lookupInstance(int n, Coordinator coordinator) throws MoAccessException {
        return (AtmTrafficDescriptorMoImpl)froIdTable.get(n, coordinator);
    }
}

