/*
 * Decompiled with CFR 0.152.
 */
package com.prismtech.corba.jacorb;

import com.prismtech.corba.jacorb.ConfigurableSSLSocketFactory;
import com.prismtech.corba.jacorb.KeyMaterialProvider;
import com.prismtech.corba.jacorb.SSLServerSocketFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;

public class PropKsSSLServerSocketFactory
extends SSLServerSocketFactory
implements KeyMaterialProvider,
Configurable {
    private KeyStore keyStore;
    private char[] keyPass;

    public PropKsSSLServerSocketFactory(ORB oRB) throws Exception {
        super(oRB);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        String string = configuration.getAttribute("jacorb.security.keystore");
        String string2 = configuration.getAttribute("jacorb.security.keystore_password");
        this.keyPass = string2.toCharArray();
        String string3 = configuration.getAttribute("jacorb.security.keystore_type", "JKS");
        try {
            this.keyStore = KeyStoreUtil.getKeyStore(string, this.keyPass, string3, this.keystore_provider, this.keystore_provider_impl);
        }
        catch (IOException iOException) {
            throw new ConfigurationException("unable to access keystore", iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ConfigurationException("unable to access keystore", generalSecurityException);
        }
        this.setKeyMaterialProvider(this);
    }

    public void connectTo(ConfigurableSSLSocketFactory configurableSSLSocketFactory) {
    }

    public char[] getKeyPassPhrase() {
        return this.keyPass;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public SecureRandom getSecureRandom() {
        return null;
    }

    public X509Certificate[] getTrustees() {
        return null;
    }

    public X509TrustManager[] getTrustManagers() {
        return null;
    }

    public void setInitialConfigurationDone() {
    }
}

