/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.iiop.IIOPListener;
import org.jacorb.orb.listener.AcceptorExceptionEvent;
import org.jacorb.orb.listener.AcceptorExceptionListener;
import org.jacorb.util.ObjectUtil;

public class DefaultAcceptorExceptionListener
implements AcceptorExceptionListener,
Configurable {
    private Class sslException;
    private Logger logger;

    public void configure(Configuration configuration) {
        try {
            String exceptionClass = configuration.getAttribute("javax.net.ssl.SSLException");
            this.sslException = ObjectUtil.classForName(exceptionClass);
        }
        catch (ClassNotFoundException e2) {
        }
        catch (ConfigurationException e3) {
            this.sslException = null;
        }
        this.sslException = null;
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.orb.iiop");
    }

    public void exceptionCaught(AcceptorExceptionEvent e2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Caught acceptor event", e2.getException());
        }
        if (e2.getException() instanceof Error || !((IIOPListener.Acceptor)e2.getSource()).getAcceptorSocketLoop() && this.sslException != null && this.sslException.isInstance(e2.getException())) {
            this.logger.fatalError("fatal exception. will shutdown orb", e2.getException());
            e2.getORB().shutdown(true);
        }
    }
}

