/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.batterybackup;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.supsys.batterybackup.BatteryTestNotOngoingException;
import se.ericsson.crbs.supsys.batterybackup.BatteryTestOngoingException;
import se.ericsson.crbs.supsys.batterybackup.EqualizeChargingIsNotActiveException;
import se.ericsson.crbs.supsys.batterybackup.NoBatteryBackupException;
import se.ericsson.crbs.supsys.batterybackup.NoBatteryTestPerformedException;
import se.ericsson.crbs.supsys.batterybackup.NoMainsPowerException;
import se.ericsson.crbs.supsys.batterybackup.NoSupportSystemControlException;
import se.ericsson.crbs.supsys.batterybackup.NotPossibleToStartEqualizeChargingException;
import se.ericsson.crbs.supsys.batterybackup.PowerSystemAlarmRaisedException;
import se.ericsson.crbs.supsys.batterybackup.RunningOnBatteryException;
import se.ericsson.crbs.supsys.commonifu.NoConnectionWithHwUnitException;
import se.ericsson.crbs.supsys.equipmentsupportfunction.EquipmentSupportFunctionMaoImpl;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.FunctionalMoHelper;

public class BatteryBackupMaoImpl
extends GenericMao {
    private static final Class THIS_CLASS = BatteryBackupMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String MO_TYPE = "BatteryBackup";
    public static final String SUPPORT_SYSTEM_CONTROL = "supportSystemControl";
    private static final String EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";
    private static final String MO_TYPE_CABINET = "Cabinet";
    private static final String ACTION_STOP_EQUALIZE_CHARGING = "stopEqualizeCharging";
    private static final String ACTION_STOP_BATTERY_TEST = "stopBatteryTest";
    private static final String ACTION_START_EQUALIZE_CHARGING = "startEqualizeCharging";
    private static final String ACTION_START_BATTERY_TEST = "startBatteryTest";
    private static final String ACTION_READ_BATTERY_TEST_STATUS = "readBatteryTestStatus";
    private static final String ACTION_READ_BATTERY_TEST_RESULT = "readBatteryTestResult";
    private static final String ARGUMENT_FORCED = "forced";
    private static final String ARGUMENT_TEST_TYPE = "testType";
    private static final String ATTRIBUTE_TEST_START_TIME = "testStartTime";
    private static final String ATTRIBUTE_TEST_START_DAY = "testStartDay";
    private static final String ATTRIBUTE_TEST_START_MONTHS = "testStartMonths";
    private static final String ATTRIBUTE_CONTROL_DOMAIN_REF = "controlDomainRef";
    private static final String ATTRIBUTE_RESERVED_BY = "reservedBy";
    protected static final String RESULT_NO_CONNECTION_WITH_HW_UNIT = Integer.toString(17039362);
    protected static final String RESULT_EQUALIZE_CHARGING_IS_NOT_ACTIVE = Integer.toString(17039363);
    protected static final String RESULT_NOT_POSSIBLE_TO_START_EQUALIZE_CHARGING = Integer.toString(0x1040004);
    protected static final String RESULT_NO_SUPPORT_SYSTEM_CONTROL = Integer.toString(17039365);
    protected static final String RESULT_NO_MAINS_POWER = Integer.toString(17039366);
    protected static final String RESULT_NO_BATTERY_BACKUP = Integer.toString(17039367);
    protected static final String RESULT_BATTERY_TEST_ONGOING = Integer.toString(17039368);
    protected static final String RESULT_BATTERY_TEST_NOT_ONGOING = Integer.toString(17039369);
    protected static final String RESULT_NO_BATTERY_TEST_PERFORMED = Integer.toString(17039370);
    protected static final String RESULT_RUNNING_ON_BATTERY = Integer.toString(17039371);
    protected static final String RESULT_POWER_SYSTEM_ALARM_RAISED = Integer.toString(17039372);
    protected static final int TEST_TYPE_MIN = 0;
    protected static final int TEST_TYPE_MAX = 1;

    public BatteryBackupMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        ManagedObject[] managedObjectArray;
        logger.traceEnter(THIS_CLASS, "BatteryBackupMaoImpl() - constructor");
        EquipmentSupportFunctionMaoImpl equipmentSupportFunctionMaoImpl = (EquipmentSupportFunctionMaoImpl)this.getParent();
        Boolean bl = (Boolean)equipmentSupportFunctionMaoImpl.getAttribute(SUPPORT_SYSTEM_CONTROL, coordinator);
        if (!bl.booleanValue()) {
            throw new ProcessingFailureException("MO cannot be created unless EquipmentSupportFunction.supportSystemControl is set to true");
        }
        int n2 = attrList.indexOf(ATTRIBUTE_CONTROL_DOMAIN_REF);
        if (n2 >= 0) {
            logger.traceGeneral(THIS_CLASS, "Handle attribute controlDomainRef at BatteryBackup MO creation.");
            managedObjectArray = (ManagedObject[])attrList.getValue(n2);
            this.validateControlDomainRef(managedObjectArray, coordinator);
        }
        if ((managedObjectArray = this.getMaoContext().getMoAccessor().lookupType(MO_TYPE)).size() > 3) {
            throw new ProcessingFailureException("Up to three instances of MO BatteryBackup is currently allowed.");
        }
        logger.traceReturn(THIS_CLASS, "BatteryBackupMaoImpl() - constructor");
    }

    public BatteryBackupMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "Constructor used at restore");
    }

    public Struct actionReadBatteryTestResult(int n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionReadBatteryTestResult()");
        if (n < 0 || n > 1) {
            throw new ValueOutOfRangeException(ACTION_READ_BATTERY_TEST_RESULT, MO_TYPE, "Arguments name: testType & value: " + n);
        }
        if (null != coordinator) {
            this.handleTransactionWrite(coordinator);
        }
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        treeMap.put(ARGUMENT_TEST_TYPE, new Integer(n));
        StructImpl structImpl = new StructImpl();
        try {
            Map map = this.sendActionWithCfm(ACTION_READ_BATTERY_TEST_RESULT, coordinator, treeMap);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                structImpl.addElement(string, map.get(string));
            }
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(RESULT_NO_BATTERY_TEST_PERFORMED)) {
                String string3 = "Read battery test result failed because no test have been performed. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string3);
                throw new NoBatteryTestPerformedException(MO_TYPE, string3);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)froRequestFailedException));
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionReadBatteryTestResult()");
        return structImpl;
    }

    public Struct actionReadBatteryTestStatus(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionReadBatteryTestStatus()");
        if (null != coordinator) {
            this.handleTransactionWrite(coordinator);
        }
        TreeMap treeMap = new TreeMap();
        StructImpl structImpl = new StructImpl();
        try {
            Map map = this.sendActionWithCfm(ACTION_READ_BATTERY_TEST_STATUS, coordinator, treeMap);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                structImpl.addElement(string, map.get(string));
            }
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(RESULT_BATTERY_TEST_NOT_ONGOING)) {
                String string3 = "Read battery test status failed because it is not ongoing. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string3);
                throw new BatteryTestNotOngoingException(MO_TYPE, string3);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)froRequestFailedException));
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionReadBatteryTestStatus()");
        return structImpl;
    }

    public void actionStartBatteryTest(boolean bl, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionStartBatteryTest()");
        if (null != coordinator) {
            this.handleTransactionWrite(coordinator);
        }
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put(ARGUMENT_FORCED, bl);
        try {
            this.sendActionWithCfm(ACTION_START_BATTERY_TEST, coordinator, treeMap);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(RESULT_BATTERY_TEST_ONGOING)) {
                String string3 = "Start battery test failed because it is already ongoing. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string3);
                throw new BatteryTestOngoingException(MO_TYPE, string3);
            }
            if (string2.equals(RESULT_NO_BATTERY_BACKUP)) {
                String string4 = "Start battery test failed because there is no battery backup. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string4);
                throw new NoBatteryBackupException(MO_TYPE, string4);
            }
            if (string2.equals(RESULT_NO_CONNECTION_WITH_HW_UNIT)) {
                String string5 = "Start battery test failed because there is no connection with HW unit. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string5);
                throw new NoConnectionWithHwUnitException(MO_TYPE, string5);
            }
            if (string2.equals(RESULT_NO_MAINS_POWER)) {
                String string6 = "Start battery test failed because there is no main power. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string6);
                throw new NoMainsPowerException(MO_TYPE, string6);
            }
            if (string2.equals(RESULT_NO_SUPPORT_SYSTEM_CONTROL)) {
                String string7 = "Start battery test failed because there is no support system control. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string7);
                throw new NoSupportSystemControlException(MO_TYPE, string7);
            }
            if (string2.equals(RESULT_POWER_SYSTEM_ALARM_RAISED)) {
                String string8 = "Start battery test failed because there is a power system alarm raised. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string8);
                throw new PowerSystemAlarmRaisedException(MO_TYPE, string8);
            }
            if (string2.equals(RESULT_RUNNING_ON_BATTERY)) {
                String string9 = "Start Battery Test failed because the CRBS is running on battery. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string9);
                throw new RunningOnBatteryException(MO_TYPE, string9);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)froRequestFailedException));
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionStartBatteryTest()");
    }

    public void actionStartEqualizeCharging(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionStartEqualizeCharging()");
        if (null != coordinator) {
            this.handleTransactionWrite(coordinator);
        }
        TreeMap treeMap = new TreeMap();
        try {
            this.sendActionWithCfm(ACTION_START_EQUALIZE_CHARGING, coordinator, treeMap);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(RESULT_NOT_POSSIBLE_TO_START_EQUALIZE_CHARGING)) {
                String string3 = "Start equalize charging failed. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string3);
                throw new NotPossibleToStartEqualizeChargingException(MO_TYPE, string3);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)froRequestFailedException));
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionStartEqualizeCharging()");
    }

    public void actionStopBatteryTest(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionStopBatteryTest()");
        if (null != coordinator) {
            this.handleTransactionWrite(coordinator);
        }
        TreeMap treeMap = new TreeMap();
        try {
            this.sendActionWithCfm(ACTION_STOP_BATTERY_TEST, coordinator, treeMap);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(RESULT_BATTERY_TEST_NOT_ONGOING)) {
                String string3 = "Stop battery test failed because no battery test started via action startBatteryTest is ongoing. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string3);
                throw new BatteryTestNotOngoingException(MO_TYPE, string3);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)froRequestFailedException));
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionStopBatteryTest()");
    }

    public void actionStopEqualizeCharging(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionStopEqualizeCharging()");
        if (null != coordinator) {
            this.handleTransactionWrite(coordinator);
        }
        TreeMap treeMap = new TreeMap();
        try {
            this.sendActionWithCfm(ACTION_STOP_EQUALIZE_CHARGING, coordinator, treeMap);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(RESULT_EQUALIZE_CHARGING_IS_NOT_ACTIVE)) {
                String string3 = "Stop equalize charging failed because it is not active. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string3);
                throw new EqualizeChargingIsNotActiveException(MO_TYPE, string3);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)froRequestFailedException));
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionStopEqualizeCharging()");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        logger.traceEnter(THIS_CLASS, "preSet()");
        if (string.equals(ATTRIBUTE_TEST_START_TIME)) {
            this.assertValidTime(string, object);
        } else if (string.equals(ATTRIBUTE_TEST_START_DAY)) {
            this.assertValidDay(map, object, coordinator);
        } else if (string.equals(ATTRIBUTE_TEST_START_MONTHS)) {
            this.assertValidMonths(map, object, coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_CONTROL_DOMAIN_REF)) {
            this.validateControlDomainRef((ManagedObject[])object, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return object;
    }

    private void assertValidTime(String string, Object object) throws ValueOutOfRangeException {
        int n;
        int n2;
        logger.traceEnter(THIS_CLASS, "assertValidTime()");
        String string2 = "Parameter " + string + " = " + object + " is incorrectly formatted (HH:MM).";
        String string3 = ((String)object).substring(0, 2);
        String string4 = ((String)object).substring(2, 3);
        String string5 = ((String)object).substring(3, 5);
        if (!":".equals(string4)) {
            logger.traceGeneral(THIS_CLASS, string2);
            throw new ValueOutOfRangeException(string, MO_TYPE, string2);
        }
        try {
            n2 = Integer.valueOf(string3);
            n = Integer.valueOf(string5);
            logger.traceGeneral(THIS_CLASS, "Received time: Hours = " + n2 + ", Minutes = " + n + ".");
        }
        catch (NumberFormatException numberFormatException) {
            logger.traceGeneral(THIS_CLASS, string2);
            throw new ValueOutOfRangeException(string, MO_TYPE, string2);
        }
        if (n2 < 0 || n2 > 23 || string3.charAt(0) == '-') {
            String string6 = "Hour part (" + string3 + ") of parameter " + string + " = " + object + " is out of range [00-23].";
            logger.traceGeneral(THIS_CLASS, string6);
            throw new ValueOutOfRangeException(string, MO_TYPE, string6);
        }
        if (n < 0 || n > 59 || string5.charAt(0) == '-') {
            String string7 = "Minute part (" + string5 + ") of parameter " + string + " = " + object + " is out of range [00-59].";
            logger.traceGeneral(THIS_CLASS, string7);
            throw new ValueOutOfRangeException(string, MO_TYPE, string7);
        }
        logger.traceReturn(THIS_CLASS, "assertValidTime()");
    }

    private void assertValidDay(Map map, Object object, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        logger.traceEnter(THIS_CLASS, "assertValidDay()");
        int[] nArray = null;
        if (map.containsKey(ATTRIBUTE_TEST_START_MONTHS)) {
            logger.traceDebug(THIS_CLASS, "Reference months retrieved from current transaction.");
            Object v = map.get(ATTRIBUTE_TEST_START_MONTHS);
            if (v instanceof int[]) {
                nArray = (int[])v;
            } else if (v instanceof Integer[]) {
                nArray = this.convertIntegerArray((Integer[])v);
            }
        } else {
            logger.traceDebug(THIS_CLASS, "Reference months retrieved from MO.");
            Integer[] integerArray = (Integer[])this.getAttribute(ATTRIBUTE_TEST_START_MONTHS, coordinator);
            nArray = this.convertIntegerArray(integerArray);
        }
        this.assertValidDayMonthsCombination((Integer)object, nArray);
        logger.traceReturn(THIS_CLASS, "assertValidDay()");
    }

    private void assertValidMonths(Map map, Object object, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        Integer n;
        logger.traceEnter(THIS_CLASS, "assertValidMonths()");
        if (map.containsKey(ATTRIBUTE_TEST_START_DAY)) {
            logger.traceDebug(THIS_CLASS, "Reference day retrieved from current transaction.");
            n = (Integer)map.get(ATTRIBUTE_TEST_START_DAY);
        } else {
            logger.traceDebug(THIS_CLASS, "Reference day retrieved from MO.");
            n = (Integer)this.getAttribute(ATTRIBUTE_TEST_START_DAY, coordinator);
        }
        if (object instanceof int[]) {
            this.assertValidDayMonthsCombination(n, (int[])object);
        } else if (object instanceof Integer[]) {
            this.assertValidDayMonthsCombination(n, this.convertIntegerArray((Integer[])object));
        }
        logger.traceReturn(THIS_CLASS, "assertValidMonths()");
    }

    private void assertValidDayMonthsCombination(Integer n, int[] nArray) throws ValueOutOfRangeException {
        int[] nArray2;
        int[] nArray3;
        logger.traceEnter(THIS_CLASS, "assertValidDayMonthCombination()");
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string.concat(nArray[i] + " ");
        }
        String string2 = "Invalid combination of testStartDay = " + n + " and testStartMonths = [ " + string + "].";
        logger.traceDebug(THIS_CLASS, "assertValidDayMonthCombination(): day = " + n.toString() + ", months  = " + string);
        if (n == 29 || n == 30 ? this.containsForbiddenMonths(nArray, nArray3 = new int[]{2}) : n == 31 && this.containsForbiddenMonths(nArray, nArray2 = new int[]{2, 4, 6, 9, 11})) {
            throw new ValueOutOfRangeException("testStartDay,testStartMonths", MO_TYPE, string2);
        }
        logger.traceReturn(THIS_CLASS, "assertValidDayMonthCombination()");
    }

    private boolean containsForbiddenMonths(int[] nArray, int[] nArray2) {
        logger.traceEnter(THIS_CLASS, "containsForbiddenMonths()");
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] != nArray2[j]) continue;
                bl = true;
            }
        }
        logger.traceReturn(THIS_CLASS, "containsForbiddenMonths()");
        return bl;
    }

    private int[] convertIntegerArray(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    private void validateControlDomainRef(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateControlDomainRef");
        if (managedObjectArray.length > 1) {
            logger.traceGeneral(THIS_CLASS, "Attribute controlDomainRef cannot refer to more than one MO.");
            throw new ValueOutOfRangeException(ATTRIBUTE_CONTROL_DOMAIN_REF, MO_TYPE, "Attribute controlDomainRef cannot refer to more than one MO.");
        }
        if (managedObjectArray.length == 1) {
            if (managedObjectArray[0].getType().equals(MO_TYPE_CABINET)) {
                FunctionalMoHelper functionalMoHelper = new FunctionalMoHelper();
                functionalMoHelper.validateFunctionalMOWhenPreSetControlDomainRef((ManagedObject)this, managedObjectArray[0], coordinator, this.genericMaoContext);
                ManagedObject[] managedObjectArray2 = (ManagedObject[])managedObjectArray[0].getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
                for (int i = 0; i < managedObjectArray2.length; ++i) {
                    if (!managedObjectArray2[i].getType().equals(MO_TYPE) || managedObjectArray2[i].getLocalDistinguishedName().equals(this.getLocalDistinguishedName())) continue;
                    logger.traceGeneral(THIS_CLASS, "The Cabinet MO cannot be referred to since it is already referred to from another BatteryBackup MO.");
                    throw new ValueOutOfRangeException(ATTRIBUTE_CONTROL_DOMAIN_REF, MO_TYPE, "The Cabinet MO cannot be referred to since it is already referred to from another BatteryBackup MO.");
                }
                functionalMoHelper.validateEsfRefChain(this.getParent(), managedObjectArray[0], coordinator);
            } else {
                logger.traceGeneral(THIS_CLASS, "Attribute controlDomainRef can only refer to MO of type Cabinet");
                throw new ValueOutOfRangeException(ATTRIBUTE_CONTROL_DOMAIN_REF, MO_TYPE, "Attribute controlDomainRef can only refer to MO of type Cabinet");
            }
        }
        logger.traceEnter(THIS_CLASS, "validateControlDomainRef");
    }
}

