/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.ecport;

import java.util.Arrays;
import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.supsys.externalnode.ExternalNodeMaoImpl;
import se.ericsson.crbs.supsys.hwunit.HwUnitMaoImpl;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;

public class EcPortMaoImpl
extends GenericMao {
    private static final String ATTRIBUTE_EC_BUS_REF = "ecBusRef";
    private static final String ATTRIBUTE_SUPPORT_SYSTEM_CONTROL = "supportSystemControl";
    private static final String ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF = "equipmentSupportFunctionRef";
    private static final String ATTRIBUTE_POSITION_REF = "positionRef";
    private static final String ATTRIBUTE_RESERVED_BY = "reservedBy";
    private static final String ATTRIBUTE_HUBPOSITION = "hubPosition";
    private static final String ATTRIBUTE_INCI_CONNECTOR_REF = "inciConnectorRef";
    private static final Class THIS_CLASS = EcPortMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";
    private static final String MO_TYPE = "EcPort";
    private static final String MO_TYPE_CABINET = "Cabinet";
    private static final String MO_TYPE_HW_UNIT = "HwUnit";
    private static final String MO_TYPE_EC_BUS = "EcBus";
    private static final String MO_TYPE_EXTERNAL_NODE = "ExternalNode";
    private static final String MO_TYPE_AUX_PLUG_IN_UNIT = "AuxPlugInUnit";
    public static final String[] VALID_HUBPOSITIONS = new String[]{"", "Ain", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "Bin", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "A", "B", "C", "D", "E", "X", "Y", "SAU", "CLU", "NA"};

    public EcPortMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EcPortMaoImpl() - constructor");
        ManagedObject managedObject2 = (ManagedObject)this.getAttribute(ATTRIBUTE_EC_BUS_REF, coordinator);
        if (managedObject2 != null) {
            Boolean bl;
            this.validateEsfRefChain(managedObject2, coordinator);
            ManagedObject managedObject3 = (ManagedObject)managedObject2.getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator);
            if (managedObject3 != null && managedObject.getType().equals(MO_TYPE_HW_UNIT) && (bl = (Boolean)managedObject3.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator)) != null && bl.booleanValue()) {
                HwUnitMaoImpl hwUnitMaoImpl = (HwUnitMaoImpl)managedObject;
                hwUnitMaoImpl.createChildren(coordinator);
            }
            this.updateExternalNodeInciConnectorRef(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "EcPortMaoImpl() - constructor");
    }

    public EcPortMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EcPortMaoImpl() - Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "EcPortMaoImpl() - Constructor used at restore");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSet() -- " + string);
        if (string.equalsIgnoreCase(ATTRIBUTE_EC_BUS_REF)) {
            this.preSetEcBusRef((ManagedObject)object, coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_HUBPOSITION)) {
            this.preSetHubPosition(object, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return object;
    }

    private void preSetEcBusRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetEcBusRef()");
        this.validateEcBusRef(managedObject);
        this.validateEsfRefChain(managedObject, coordinator);
        logger.traceReturn(THIS_CLASS, "preSetEcBusRef()");
    }

    private void validateEcBusRef(ManagedObject managedObject) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateEcBusRef()");
        if (!managedObject.getType().equalsIgnoreCase(MO_TYPE_EC_BUS)) {
            logger.traceGeneral(THIS_CLASS, "Attribute ecBusRef can only refer to MO of type EcBus.");
            throw new ValueOutOfRangeException(ATTRIBUTE_EC_BUS_REF, MO_TYPE, "Attribute ecBusRef can only refer to MO of type EcBus.");
        }
        logger.traceReturn(THIS_CLASS, "validateEcBusRef()");
    }

    private void validateEsfRefChain(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        Object object;
        logger.traceEnter(THIS_CLASS, "validateEsfRefChain()");
        ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator);
        if (managedObject2 != null && this.getParent().getType().equals(MO_TYPE_AUX_PLUG_IN_UNIT) && ((Boolean)(object = (Boolean)managedObject2.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator))).equals(Boolean.TRUE)) {
            throw new SupportSystemConfigurationFailedException("Faulty EquipmentSupportFunction ref to AuxPlugInUnit ", "EcPort under AuxPlugInUnit should refer an EquipmentSupportFunction with supportSystemControl false");
        }
        object = this.getMaoContext().getMoAccessor().lookupType(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
        if (object.size() == 2) {
            if (managedObject2 != null && this.getParent().getType().equals(MO_TYPE_HW_UNIT) && this.getParent().getAttribute(ATTRIBUTE_POSITION_REF, coordinator) != null) {
                ManagedObject managedObject3 = (ManagedObject)this.getParent().getAttribute(ATTRIBUTE_POSITION_REF, coordinator);
                if (managedObject3 != null && managedObject3.getType().equals(MO_TYPE_CABINET)) {
                    ManagedObject[] managedObjectArray = (ManagedObject[])managedObject3.getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
                    for (int i = 0; i < managedObjectArray.length; ++i) {
                        if (!managedObjectArray[i].getParent().getType().equals(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION) || managedObjectArray[i].getParent() == managedObject2) continue;
                        throw new SupportSystemConfigurationFailedException("ecBusRef is faulty", "There is a conflicting reference chain to EquipmentSupportFunction.");
                    }
                }
            } else if (managedObject2 != null && this.getParent().getType().equals(MO_TYPE_EXTERNAL_NODE) && managedObject2 != this.getParent().getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator)) {
                throw new SupportSystemConfigurationFailedException("EcBusRef is faulty", "There is a conflicting reference chain to EquipmentsupportFunction for ExternalNode.");
            }
        }
        logger.traceReturn(THIS_CLASS, "validateEsfRefChain()");
    }

    private void preSetHubPosition(Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetHubPosition()");
        this.validateHubPosition(object);
        logger.traceReturn(THIS_CLASS, "preSetHubPosition()");
    }

    private void validateHubPosition(Object object) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateHubPosition() " + object);
        if (!Arrays.asList(VALID_HUBPOSITIONS).contains(object)) {
            String string = "Parameter hubPosition=" + object + " is not valid";
            logger.traceAbnormal(THIS_CLASS, string);
            throw new ValueOutOfRangeException(ATTRIBUTE_HUBPOSITION, MO_TYPE, string);
        }
        logger.traceReturn(THIS_CLASS, "validateHubPosition()");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet() -- parameter: " + string);
        if (string.equalsIgnoreCase(ATTRIBUTE_EC_BUS_REF)) {
            this.updateExternalNodeInciConnectorRef(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    private void updateExternalNodeInciConnectorRef(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject;
        Boolean bl;
        ManagedObject managedObject2;
        logger.traceEnter(THIS_CLASS, "updateExternalNodeInciConnectorRef()");
        ManagedObject managedObject3 = this.getParent();
        if (managedObject3.getType().equals(MO_TYPE_EXTERNAL_NODE) && (managedObject2 = (ManagedObject)managedObject3.getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator)) != null && (bl = (Boolean)managedObject2.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator)) != null && bl.booleanValue() && ((managedObject = (ManagedObject)managedObject3.getAttribute(ATTRIBUTE_INCI_CONNECTOR_REF, coordinator)) == null || managedObject.getType().equals(MO_TYPE_EC_BUS))) {
            ManagedObject managedObject4 = (ManagedObject)this.getAttribute(ATTRIBUTE_EC_BUS_REF, coordinator);
            managedObject3.setAttribute(ATTRIBUTE_INCI_CONNECTOR_REF, (Object)managedObject4, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "updateExternalNodeInciConnectorRef()");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "delete()");
        ManagedObject managedObject = this.getParent();
        if (managedObject.getType().equals(MO_TYPE_EXTERNAL_NODE)) {
            ExternalNodeMaoImpl externalNodeMaoImpl = (ExternalNodeMaoImpl)managedObject;
            externalNodeMaoImpl.onEcPortDeleted(coordinator);
        }
        super.delete(coordinator);
        logger.traceReturn(THIS_CLASS, "delete()");
    }
}

