/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.equipmentsupportfunction;

import java.util.Map;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.EquipmentSupportFunctionHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.ExternalNodeHelper;

public class EquipmentSupportFunctionMaoImpl
extends GenericMao
implements AvcSubscriber {
    private static final String ENERGY_MEASUREMENT = "energyMeasurement";
    private static final String HWUNIT = "HwUnit";
    protected static final String ATTRIBUTE_CABINET_PARAMETERS = "cabinetParameters";
    protected static final String ATTRIBUTE_CABINET_PARAMETERS_PROFILE_STANDARD = "cabinetParametersProfileStandard";
    protected static final String ATTRIBUTE_CABINET_PARAMETERS_PROFILE_EXTENDED = "cabinetParametersProfileExtended";
    protected static final String ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF = "equipmentSupportFunctionRef";
    protected static final int STANDARD_CLIMATE_SYSTEM = 0;
    protected static final int EXTENDED_CLIMATE_SYSTEM = 1;
    protected static final String ATTRIBUTE_CLIMATE_SYSTEM = "climateSystem";
    protected static final String ATTRIBUTE_LOGICAL_NAME = "logicalName";
    protected static final String ATTRIBUTE_PRODUCT_NAME = "productName";
    protected static final String ATTRIBUTE_PRODUCT_NAME_ME = "productNameME";
    protected static final String ATTRIBUTE_FULL_DISTINGUISHED_NAME = "fullDistinguishedName";
    protected static final String ATTRIBUTE_RADIO_ACCESS_TECHNOLOGY = "radioAccessTechnology";
    private static final String MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";
    private static final String MO_TYPE_FAN_GROUP = "FanGroup";
    private static final String MO_TYPE_CABINET = "Cabinet";
    private static final String MO_TYPE_CLIMATE = "Climate";
    private static final String MO_TYPE_EXTERNAL_NODE = "ExternalNode";
    private static final String MO_TYPE_EXTERNAL_POWER = "ExternalPower";
    protected static final String ATTRIBUTE_SUPPORT_SYSTEM_CONTROL = "supportSystemControl";
    private static final Class THIS_CLASS = EquipmentSupportFunctionMaoImpl.class;
    private static final Integer RAT_NOT_AVAILABLE = new Integer(0);
    private static final Integer RAT_WCDMA = new Integer(2);
    private static final Integer RAT_LTE = new Integer(3);
    private static final AbstractLogger logger = LoggingService.getLogger((String)EquipmentSupportFunctionMaoImpl.class.getName());
    private static final String MANAGED_ELEMENT_TYPE = "ManagedElement";

    public EquipmentSupportFunctionMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EquipmentSupportFunctionMaoImpl() - constructor");
        if (!"TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_LOGICAL_NAME);
            genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_PRODUCT_NAME);
        }
        logger.traceReturn(THIS_CLASS, "EquipmentSupportFunctionMaoImpl() - constructor");
    }

    public EquipmentSupportFunctionMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EquipmentSupportFunctionMaoImpl() - reconstructor");
        if (!"TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_LOGICAL_NAME);
            genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_PRODUCT_NAME);
        }
        logger.traceReturn(THIS_CLASS, "EquipmentSupportFunctionMaoImpl() - reconstructor");
    }

    public AttrList addFroParametersAtCreate(AttrList attrList, AttrList attrList2, Coordinator coordinator) throws MoAccessException {
        ((AttrListImpl)attrList).addAttribute(ATTRIBUTE_LOGICAL_NAME, (Object)((ManagedElementMo)this.getParent()).getLogicalName(coordinator));
        ((AttrListImpl)attrList).addAttribute(ATTRIBUTE_PRODUCT_NAME_ME, (Object)((ManagedElementMo)this.getParent()).getProductName(coordinator));
        ((AttrListImpl)attrList).addAttribute(ATTRIBUTE_FULL_DISTINGUISHED_NAME, (Object)"");
        ((AttrListImpl)attrList).addAttribute(ATTRIBUTE_RADIO_ACCESS_TECHNOLOGY, (Object)RAT_NOT_AVAILABLE);
        return attrList;
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "delete");
        if (this.getRdnId(coordinator).equals("1")) {
            throw new ProcessingFailureException("Not possible to delete EquipmentSupportFunction=1");
        }
        if (!"TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_LOGICAL_NAME);
            this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, MANAGED_ELEMENT_TYPE, ATTRIBUTE_PRODUCT_NAME);
        }
        super.delete(coordinator);
        logger.traceReturn(THIS_CLASS, "delete");
    }

    public void preCreateValidation(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "preCreateValidation");
        int n = attrList.indexOf(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL);
        if (n >= 0 && n < attrList.size()) {
            Object object = attrList.getValue(n);
            this.validateSupportSystemControl(object, coordinator);
        }
        logger.traceReturn(((Object)((Object)this)).getClass(), "preCreateValidation");
    }

    public void postCreate(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        int n;
        logger.traceEnter(((Object)((Object)this)).getClass(), "postCreate");
        super.postCreate(attrList, coordinator);
        if (this.updateRAT(coordinator)) {
            this.updateFDN(coordinator);
        }
        if (!EquipmentSupportFunctionHelper.isDoubleRole(this.genericMaoContext) && (n = attrList.indexOf(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL)) >= 0) {
            boolean bl = (Boolean)attrList.getValue(n);
            ExternalNodeHelper.supportSystemControlChanged(bl, this.genericMaoContext, coordinator);
        }
        logger.traceReturn(((Object)((Object)this)).getClass(), "postCreate");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSet() -- " + string);
        if (string.equalsIgnoreCase(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL)) {
            this.validateSupportSystemControl(object, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return object;
    }

    private void validateSupportSystemControl(Object object, Coordinator coordinator) throws MoAccessException, SupportSystemConfigurationFailedException {
        MoIterator moIterator;
        boolean bl = (Boolean)object;
        logger.traceEnter(THIS_CLASS, "validateSupportSystemControl (" + bl + ")");
        if (EquipmentSupportFunctionHelper.isDoubleRole(this.genericMaoContext) && (moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION)) != null) {
            while (moIterator.hasMoreElements()) {
                boolean bl2;
                ManagedObject managedObject = moIterator.nextMo();
                if (managedObject == null || managedObject == this || (bl2 = ((Boolean)managedObject.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator)).booleanValue()) != bl) continue;
                logger.traceDebug(THIS_CLASS, "supportSystemControl validation failed!");
                throw new SupportSystemConfigurationFailedException("Double primary or secondary roles", "EquipmentSupportFunction is configured with double primary or secondary roles.");
            }
        }
        logger.traceReturn(THIS_CLASS, "validateSupportSystemControl");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        if (string.equalsIgnoreCase(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL) && !EquipmentSupportFunctionHelper.isDoubleRole(this.genericMaoContext)) {
            this.postSetSupportSystemControlSingleRole(coordinator);
            this.postSetSupportSystemControlCabinet(coordinator);
        }
    }

    private void postSetSupportSystemControlSingleRole(Coordinator coordinator) throws MoAccessException, NoSuchAttributeException, MoHasChildrenException {
        boolean bl = EquipmentSupportFunctionHelper.isSupportSystemControl(this.genericMaoContext, coordinator);
        if (!bl) {
            ManagedObject managedObject;
            MoIterator moIterator;
            MoIterator moIterator2 = this.genericMaoContext.getMoRepositoryWrapper().lookupType(ENERGY_MEASUREMENT);
            if (moIterator2 != null) {
                while (moIterator2.hasMoreElements()) {
                    moIterator = moIterator2.nextMo();
                    moIterator.delete(coordinator);
                }
            }
            moIterator = this.getChildren();
            MoIterator moIterator3 = this.genericMaoContext.getMoRepositoryWrapper().lookupType(HWUNIT);
            if (moIterator3 != null) {
                while (moIterator3.hasMoreElements()) {
                    managedObject = moIterator3.nextMo();
                    managedObject.delete(coordinator);
                }
            }
            while (moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                if (!managedObject.getType().equals(MO_TYPE_CLIMATE) && !managedObject.getType().equals(MO_TYPE_EXTERNAL_POWER)) {
                    logger.traceDebug(THIS_CLASS, "Delete EquipmentSupportFunction child MO of type: " + managedObject.getType());
                    managedObject.delete(coordinator);
                    continue;
                }
                logger.traceDebug(THIS_CLASS, "Skip delete EquipmentSupportFunction child MO of type: " + managedObject.getType());
            }
        }
        ExternalNodeHelper.supportSystemControlChanged(bl, this.genericMaoContext, coordinator);
    }

    private void postSetSupportSystemControlCabinet(Coordinator coordinator) throws MoAccessException, MoHasChildrenException {
        logger.traceEnter(THIS_CLASS, "postSetSupportSystemControlCabinet()");
        if (!EquipmentSupportFunctionHelper.isSupportSystemControl(this.genericMaoContext, coordinator)) {
            this.deleteFanGroupFromCabinets(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "postSetSupportSystemControlCabinet()");
    }

    private void deleteFanGroupFromCabinets(Coordinator coordinator) throws MoAccessException, MoHasChildrenException {
        logger.traceEnter(THIS_CLASS, "deleteFanGroupFromCabinets()");
        ManagedObject managedObject = null;
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(MO_TYPE_CABINET);
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            MoIterator moIterator2 = managedObject.getChildren();
            while (moIterator2 != null && moIterator2.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator2.nextMo();
                if (!managedObject2.getType().equals(MO_TYPE_FAN_GROUP)) continue;
                managedObject2.delete(coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "deleteFanGroupFromCabinets()");
    }

    public static Thread startUpdateRATandFDNthread(MoRepositoryWrapper moRepositoryWrapper) {
        UpdateRATAndFDNthread updateRATAndFDNthread = new UpdateRATAndFDNthread(moRepositoryWrapper);
        updateRATAndFDNthread.start();
        return updateRATAndFDNthread;
    }

    public boolean updateRAT(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "updateRAT");
        boolean bl = false;
        Integer n = RAT_NOT_AVAILABLE;
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("NodeBFunction");
        if (moIterator != null && moIterator.size() > 0) {
            n = RAT_WCDMA;
        } else {
            MoIterator moIterator2 = this.genericMaoContext.getMoRepositoryWrapper().lookupType("ENodeBFunction");
            if (moIterator2 != null && moIterator2.size() > 0) {
                n = RAT_LTE;
            }
        }
        if (n != RAT_NOT_AVAILABLE) {
            bl = this.updateEquipmentSupportFunction(coordinator, ATTRIBUTE_RADIO_ACCESS_TECHNOLOGY, n);
        } else {
            logger.traceDebug(THIS_CLASS, "(E)NodeBFunction not found yet, RAT not updated");
        }
        logger.traceReturn(THIS_CLASS, "updateRAT");
        return bl;
    }

    public boolean updateFDN(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "updateFDN");
        boolean bl = false;
        ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1");
        if (managedObject != null) {
            String string = managedObject.getFullDistinguishedName();
            bl = this.updateEquipmentSupportFunction(coordinator, ATTRIBUTE_FULL_DISTINGUISHED_NAME, string);
        }
        logger.traceReturn(THIS_CLASS, "updateFDN");
        return bl;
    }

    private boolean updateEquipmentSupportFunction(Coordinator coordinator, String string, Object object) {
        boolean bl = false;
        try {
            Control control = null;
            if (coordinator == null) {
                control = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory().create(59);
                coordinator = control.getCoordinator();
            }
            try {
                Object object2 = this.getAttribute(string, coordinator);
                if (object2 == null && object == null || object2 != null && object2.equals(object)) {
                    logger.traceDebug(THIS_CLASS, "No need to update " + string + " with value " + object);
                } else {
                    this.setReadOnlyAttribute(string, object, coordinator);
                    logger.traceDebug(THIS_CLASS, "Updated " + string + " with value " + object);
                }
                if (control != null) {
                    control.getTerminator().commit();
                }
                bl = true;
            }
            catch (Exception exception) {
                if (control != null) {
                    try {
                        control.getTerminator().rollback();
                    }
                    catch (InactiveTransactionException inactiveTransactionException) {
                        logger.traceDebug(THIS_CLASS, "Inactive transaction exception caught for transaction: " + control.getCoordinator().getTransactionID());
                    }
                }
                logger.traceAbnormal(THIS_CLASS, "Failed to update " + string + ", reason: " + exception);
            }
        }
        catch (Exception exception) {
            logger.traceAbnormal(THIS_CLASS, "Failed to update " + string + ", reason: " + exception);
        }
        return bl;
    }

    private ManagedObject getManagedElement() {
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(MANAGED_ELEMENT_TYPE);
        return (ManagedObject)moIterator.nextElement();
    }

    public void reportAvc(String string, String string2, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceDebug(THIS_CLASS, "reportAvc " + string2 + " with value " + object);
        if (string2.equals(ATTRIBUTE_PRODUCT_NAME)) {
            this.setReadOnlyAttribute(ATTRIBUTE_PRODUCT_NAME_ME, object, coordinator);
        } else {
            this.setReadOnlyAttribute(string2, object, coordinator);
        }
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        Object object = this.getAttribute(ATTRIBUTE_LOGICAL_NAME, coordinator);
        Object object2 = this.getManagedElement().getAttribute(ATTRIBUTE_LOGICAL_NAME, null);
        if (object != null && !object.equals(object2)) {
            this.setReadOnlyAttribute(ATTRIBUTE_LOGICAL_NAME, object2, coordinator);
        }
        Object object3 = this.getAttribute(ATTRIBUTE_PRODUCT_NAME_ME, coordinator);
        String string = ((ManagedElementMo)this.getParent()).getProductName(coordinator);
        if (object3 != null && !object3.equals(string)) {
            this.setReadOnlyAttribute(ATTRIBUTE_PRODUCT_NAME_ME, string, coordinator);
        }
    }

    public void actionCollectEnergyMeasurementLogs(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "collectEnergyMeasurementLogs() - Deprecated action");
        logger.traceReturn(THIS_CLASS, "collectEnergyMeasurementLogs() - Deprecated action");
    }

    public static class UpdateRATAndFDNthread
    extends Thread {
        private final int ONE_HOUR = 3600000;
        private final int ONE_MINUTE = 60000;
        private final int TEN_SECONDS = 10000;
        private final MoRepositoryWrapper moRepositoryWrapper;
        private volatile boolean forever = true;

        UpdateRATAndFDNthread(MoRepositoryWrapper moRepositoryWrapper) {
            this.moRepositoryWrapper = moRepositoryWrapper;
            this.setName("UpdateRATAndFDNthread");
        }

        public void run() {
            boolean bl = false;
            while (this.forever) {
                try {
                    MoIterator moIterator = this.moRepositoryWrapper.lookupType(EquipmentSupportFunctionMaoImpl.MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
                    if (moIterator != null) {
                        if (bl) {
                            if (this.updateFDN(moIterator)) {
                                this.mywait(3600000);
                                continue;
                            }
                            this.mywait(10000);
                            continue;
                        }
                        bl = this.updateRAT(moIterator);
                        if (bl) continue;
                        this.mywait(10000);
                        continue;
                    }
                    this.mywait(10000);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    this.mywait(60000);
                }
            }
        }

        private boolean updateFDN(MoIterator moIterator) {
            return this.updateAllAndAtLeastOne(moIterator, new EsfUpdater(){

                public boolean update(EquipmentSupportFunctionMaoImpl equipmentSupportFunctionMaoImpl) {
                    return equipmentSupportFunctionMaoImpl.updateFDN(null);
                }
            });
        }

        private boolean updateRAT(MoIterator moIterator) {
            return this.updateAllAndAtLeastOne(moIterator, new EsfUpdater(){

                public boolean update(EquipmentSupportFunctionMaoImpl equipmentSupportFunctionMaoImpl) {
                    return equipmentSupportFunctionMaoImpl.updateRAT(null);
                }
            });
        }

        private boolean updateAllAndAtLeastOne(MoIterator moIterator, EsfUpdater esfUpdater) {
            boolean bl = true;
            boolean bl2 = false;
            while (moIterator.hasMoreElements()) {
                EquipmentSupportFunctionMaoImpl equipmentSupportFunctionMaoImpl = (EquipmentSupportFunctionMaoImpl)moIterator.nextMo();
                boolean bl3 = esfUpdater.update(equipmentSupportFunctionMaoImpl);
                bl2 |= bl3;
                bl &= bl3;
            }
            return bl && bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mywait(int n) {
            UpdateRATAndFDNthread updateRATAndFDNthread = this;
            synchronized (updateRATAndFDNthread) {
                try {
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void killOnlyFroTest() {
            this.forever = false;
            UpdateRATAndFDNthread updateRATAndFDNthread = this;
            synchronized (updateRATAndFDNthread) {
                this.notifyAll();
            }
        }

        private static interface EsfUpdater {
            public boolean update(EquipmentSupportFunctionMaoImpl var1);
        }
    }
}

