/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.powerdistribution;

import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.supsys.equipmentsupportfunction.EquipmentSupportFunctionMaoImpl;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.FunctionalMoHelper;

public class PowerDistributionMaoImpl
extends GenericMao {
    private static final Class THIS_CLASS = PowerDistributionMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "PowerDistribution";
    private static final String MO_TYPE_CABINET = "Cabinet";
    private static final String EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";
    public static final String SUPPORT_SYSTEM_CONTROL = "supportSystemControl";
    private static final String ATTRIBUTE_CONTROL_DOMAIN_REF = "controlDomainRef";
    private static final String ATTRIBUTE_RESERVED_BY = "reservedBy";

    public PowerDistributionMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "PowerDistributionMaoImpl() - constructor");
        EquipmentSupportFunctionMaoImpl equipmentSupportFunctionMaoImpl = (EquipmentSupportFunctionMaoImpl)this.getParent();
        Boolean bl = (Boolean)equipmentSupportFunctionMaoImpl.getAttribute(SUPPORT_SYSTEM_CONTROL, coordinator);
        if (!bl.booleanValue()) {
            throw new ProcessingFailureException("MO cannot be created unless EquipmentSupportFunction.supportSystemControl is set to true");
        }
        int n2 = attrList.indexOf(ATTRIBUTE_CONTROL_DOMAIN_REF);
        if (n2 >= 0) {
            logger.traceGeneral(THIS_CLASS, "Handle attribute controlDomainRef at PowerDistribution MO creation.");
            ManagedObject[] managedObjectArray = (ManagedObject[])attrList.getValue(n2);
            this.validateControlDomainRef(managedObjectArray, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "PowerDistributionMaoImpl() - constructor");
    }

    public PowerDistributionMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "Constructor used at restore");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        logger.traceEnter(THIS_CLASS, "preSet()");
        if (string.equalsIgnoreCase(ATTRIBUTE_CONTROL_DOMAIN_REF)) {
            this.validateControlDomainRef((ManagedObject[])object, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return object;
    }

    private void validateControlDomainRef(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateControlDomainRef");
        if (managedObjectArray.length > 1) {
            logger.traceGeneral(THIS_CLASS, "Attribute controlDomainRef cannot refer to more than one MO.");
            throw new ValueOutOfRangeException(ATTRIBUTE_CONTROL_DOMAIN_REF, MO_TYPE, "Attribute controlDomainRef cannot refer to more than one MO.");
        }
        if (managedObjectArray.length == 1) {
            if (managedObjectArray[0].getType().equals(MO_TYPE_CABINET)) {
                FunctionalMoHelper functionalMoHelper = new FunctionalMoHelper();
                functionalMoHelper.validateFunctionalMOWhenPreSetControlDomainRef((ManagedObject)this, managedObjectArray[0], coordinator, this.genericMaoContext);
                ManagedObject[] managedObjectArray2 = (ManagedObject[])managedObjectArray[0].getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
                for (int i = 0; i < managedObjectArray2.length; ++i) {
                    if (!managedObjectArray2[i].getType().equals(MO_TYPE) || managedObjectArray2[i].getLocalDistinguishedName().equals(this.getLocalDistinguishedName())) continue;
                    logger.traceGeneral(THIS_CLASS, "The Cabinet MO cannot be referred to since it is already referred to from another PowerDistribution MO.");
                    throw new ValueOutOfRangeException(ATTRIBUTE_CONTROL_DOMAIN_REF, MO_TYPE, "The Cabinet MO cannot be referred to since it is already referred to from another PowerDistribution MO.");
                }
                functionalMoHelper.validateEsfRefChain(this.getParent(), managedObjectArray[0], coordinator);
            } else {
                logger.traceGeneral(THIS_CLASS, "Attribute controlDomainRef can only refer to MO of type Cabinet");
                throw new ValueOutOfRangeException(ATTRIBUTE_CONTROL_DOMAIN_REF, MO_TYPE, "Attribute controlDomainRef can only refer to MO of type Cabinet");
            }
        }
        logger.traceEnter(THIS_CLASS, "validateControlDomainRef");
    }
}

