/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.CabinetData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.SupportSystemData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.EquipmentSupportFunctionHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.ReportLoggerHelper;

public class CabinetHelper {
    private static final Class THIS_CLASS = CabinetHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient MoRepositoryWrapper aMoRepository;
    private final transient MoFactoryMgrWrapper aFactoryMgr;
    private static final String ATTRIBUTE_CLIMATE_CONTROL_MODE = "climateControlMode";
    private static final String ATTRIBUTE_RESERVED_BY = "reservedBy";
    private static final String ATTRIBUTE_CONTROL_DOMAIN_REF = "controlDomainRef";
    private static final String UNIT_TYPE = "unitType";
    private static final String HWUNIT = "HwUnit";

    public CabinetHelper(GenericMaoContext genericMaoContext) {
        logger.traceEnter(THIS_CLASS, "CabinetHelper() - Constructor");
        this.aMoRepository = genericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = genericMaoContext.getMoFactoryMgrWrapper();
        logger.traceReturn(THIS_CLASS, "CabinetHelper() - Constructor");
    }

    public void createAndConfigureCabinet(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigureCabinet()");
        if (supportSystemData.xmlVersion > 2 && supportSystemData.cabinetDataList != null) {
            if (this.areDuplicatesInCabinetDataList(supportSystemData.cabinetDataList)) {
                throw new SupportSystemConfigurationFailedException("Cabinets are duplicated", "There are two or more cabinets with the same id.");
            }
            logger.traceDebug(THIS_CLASS, "cabinetMO - create for version > 2");
            for (int i = 0; i < supportSystemData.cabinetDataList.length; ++i) {
                ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=" + this.makeId(supportSystemData.cabinetDataList[i].cabinetId));
                if (managedObject == null) {
                    this.createCabinetMultiCabinet(i, supportSystemData, coordinator);
                    continue;
                }
                this.setCabinetMultiCabinet(i, supportSystemData, managedObject, coordinator);
            }
        } else {
            ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=1");
            if (managedObject == null) {
                this.createCabinet(supportSystemData, coordinator);
            } else {
                this.setCabinet(supportSystemData, managedObject, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "createAndConfigureCabinet()");
    }

    public void createAndConfigureClimate(Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigureClimate()");
        MoIterator moIterator = this.aMoRepository.lookupType("Cabinet");
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            ManagedObject managedObject2 = this.getClimateForCabinet(managedObject, coordinator);
            if (managedObject2 != null) continue;
            this.createClimate(managedObject, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createAndConfigureClimate()");
    }

    public void createAndConfigureClimateMultiCabinet(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigureClimateMultiCabinet()");
        for (int i = 0; i < supportSystemData.cabinetDataList.length; ++i) {
            if (supportSystemData.climateSystemDataList[i].controlDomainRef == null) {
                throw new SupportSystemConfigurationFailedException("Climate MO.", "For Multi Cabinet configuration controlDomainRef is mandatory.");
            }
            ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=" + this.makeId(supportSystemData.climateSystemDataList[i].controlDomainRef));
            if (managedObject == null) {
                throw new SupportSystemConfigurationFailedException("Cabinet MO. ", "Failed to get Cabinet.");
            }
            ManagedObject managedObject2 = EquipmentSupportFunctionHelper.getEquipmentSupportFunctionMo(this.aMoRepository, this.aFactoryMgr, supportSystemData.climateSystemDataList[i].parentEsf, coordinator);
            MoFactory moFactory = this.aFactoryMgr.lookup("Climate");
            if (moFactory == null) {
                throw new SupportSystemConfigurationFailedException("climateFactory MoFactory. ", "Failed to get climateFactory.");
            }
            AttrListImpl attrListImpl = new AttrListImpl();
            attrListImpl.addElement(ATTRIBUTE_CLIMATE_CONTROL_MODE, (Object)new Integer(supportSystemData.climateSystemDataList[i].climateControlMode));
            attrListImpl.addElement(ATTRIBUTE_CONTROL_DOMAIN_REF, (Object)new ManagedObject[]{managedObject});
            try {
                moFactory.createMo(managedObject2, (AttrList)attrListImpl, this.makeId(supportSystemData.climateSystemDataList[i].climateSystemId), null, coordinator);
                continue;
            }
            catch (MoAccessException moAccessException) {
                throw new SupportSystemConfigurationFailedException("Climate MO. ", "Failed to create MO. Unable to create the Climate MO.");
            }
        }
        logger.traceReturn(THIS_CLASS, "createAndConfigureClimateMultiCabinet()");
    }

    public ManagedObject getCabinet(Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getCabinet()");
        try {
            ManagedObject managedObject = this.getFreeCabinet(coordinator);
            if (managedObject == null) {
                managedObject = this.createCabinet(coordinator);
            }
            return managedObject;
        }
        catch (MoAccessException moAccessException) {
            logger.traceDebug(THIS_CLASS, "Failed to get Cabinet, " + moAccessException.getMessage());
            throw new SupportSystemConfigurationFailedException("Cabinet MO. ", "Failed to get Cabinet.");
        }
    }

    public ManagedObject getBatteryBackupForCabinet(ManagedObject managedObject, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "getBatteryBackupForCabinet()");
        MoIterator moIterator = this.aMoRepository.lookupType("BatteryBackup");
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            try {
                ManagedObject[] managedObjectArray = (ManagedObject[])managedObject2.getAttribute(ATTRIBUTE_CONTROL_DOMAIN_REF, coordinator);
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    if (!managedObject.getLocalDistinguishedName().equalsIgnoreCase(managedObjectArray[i].getLocalDistinguishedName())) continue;
                    return managedObject2;
                }
            }
            catch (MoAccessException moAccessException) {
                logger.traceDebug(THIS_CLASS, "Problem to get attribute controlDomainRef, " + moAccessException.getMessage());
            }
            catch (Exception exception) {
                logger.traceDebug(THIS_CLASS, "Problem to get attribute controlDomainRef, " + exception.getMessage());
            }
        }
        logger.traceReturn(THIS_CLASS, "getBatteryBackupForCabinet()");
        return null;
    }

    public ManagedObject getClimateForCabinet(ManagedObject managedObject, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "getClimateForCabinet()");
        MoIterator moIterator = this.aMoRepository.lookupType("Climate");
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            try {
                ManagedObject[] managedObjectArray = (ManagedObject[])managedObject2.getAttribute(ATTRIBUTE_CONTROL_DOMAIN_REF, coordinator);
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    if (!managedObject.getLocalDistinguishedName().equalsIgnoreCase(managedObjectArray[i].getLocalDistinguishedName())) continue;
                    return managedObject2;
                }
            }
            catch (MoAccessException moAccessException) {
                logger.traceDebug(THIS_CLASS, "Problem to get attribute controlDomainRef, " + moAccessException.getMessage());
            }
            catch (Exception exception) {
                logger.traceDebug(THIS_CLASS, "Problem to get attribute controlDomainRef, " + exception.getMessage());
            }
        }
        logger.traceReturn(THIS_CLASS, "getClimateForCabinet()");
        return null;
    }

    private ManagedObject createClimate(ManagedObject managedObject, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        Object object;
        logger.traceEnter(THIS_CLASS, "createClimate()");
        ManagedObject managedObject2 = this.aMoRepository.lookup("ManagedElement=1,EquipmentSupportFunction=1");
        if (managedObject2 == null) {
            throw new SupportSystemConfigurationFailedException("Parent not found", "Unable to find the parent for Climate.");
        }
        ManagedObject managedObject3 = null;
        MoFactory moFactory = this.aFactoryMgr.lookup("Climate");
        AttrListImpl attrListImpl = new AttrListImpl();
        try {
            object = managedObject.getAttribute(ATTRIBUTE_CLIMATE_CONTROL_MODE, coordinator);
            if (object == null) {
                object = new Integer(0);
            }
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            logger.traceDebug(THIS_CLASS, "Failed to get climateControlMode from Cabinet, " + noSuchAttributeException.getMessage());
            throw new SupportSystemConfigurationFailedException("Cabinet MO. ", "Failed to get climateControlMode from Cabinet.");
        }
        catch (MoAccessException moAccessException) {
            logger.traceDebug(THIS_CLASS, "Failed to get climateControlMode from Cabinet, " + moAccessException.getMessage());
            throw new SupportSystemConfigurationFailedException("Cabinet MO. ", "Failed to get climateControlMode from Cabinet.");
        }
        attrListImpl.addElement(ATTRIBUTE_CLIMATE_CONTROL_MODE, object);
        ManagedObject[] managedObjectArray = new ManagedObject[]{managedObject};
        attrListImpl.addElement(ATTRIBUTE_CONTROL_DOMAIN_REF, (Object)managedObjectArray);
        try {
            managedObject3 = moFactory.createMo(managedObject2, (AttrList)attrListImpl, this.getNextClimateId(), null, coordinator);
            ReportLoggerHelper.getInstance().logAction("Climate", "create", new String[]{ATTRIBUTE_CLIMATE_CONTROL_MODE, ATTRIBUTE_CONTROL_DOMAIN_REF}, new Object[]{object, managedObjectArray});
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException("Climate MO. ", "Failed to create MO. Unable to create the Climate MO.");
        }
        logger.traceReturn(THIS_CLASS, "createClimate()");
        return managedObject3;
    }

    private ManagedObject getFreeCabinet(Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getFreeCabinet()");
        MoIterator moIterator = this.aMoRepository.lookupType("Cabinet");
        ManagedObject managedObject = null;
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            try {
                boolean bl = true;
                ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    boolean bl2;
                    ManagedObject managedObject3;
                    block9: {
                        if (managedObjectArray[i].getType().equals(HWUNIT)) {
                            try {
                                if (managedObjectArray[i].getAttribute(UNIT_TYPE, coordinator).equals("SCU") || managedObjectArray[i].getAttribute(UNIT_TYPE, coordinator).equals("SUP")) {
                                    bl = false;
                                }
                                break block9;
                            }
                            catch (MoAccessException moAccessException) {
                                logger.traceDebug(THIS_CLASS, "Problem to get attribute reservedBy, " + moAccessException.getMessage());
                                bl = false;
                            }
                            catch (Exception exception) {
                                logger.traceDebug(THIS_CLASS, "Problem to get attribute reservedBy, " + exception.getMessage());
                                bl = false;
                            }
                            break;
                        }
                    }
                    if ((managedObject3 = managedObjectArray[i].getParent()) == null || !managedObject3.getType().equals("EquipmentSupportFunction") || (bl2 = ((Boolean)managedObject3.getAttribute("supportSystemControl", coordinator)).booleanValue())) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                managedObject2 = managedObject;
                break;
            }
            catch (MoAccessException moAccessException) {
                logger.traceDebug(THIS_CLASS, "Cabinet MO: Failed to get attribute reservedBy");
                throw new SupportSystemConfigurationFailedException("Cabinet MO. ", "Failed to get attribute reservedBy");
            }
        }
        logger.traceReturn(THIS_CLASS, "getFreeCabinet()");
        return managedObject2;
    }

    private ManagedObject createCabinet(Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createCabinet()");
        ManagedObject managedObject = null;
        ManagedObject managedObject2 = this.aMoRepository.lookup("ManagedElement=1,Equipment=1");
        if (managedObject2 == null) {
            throw new SupportSystemConfigurationFailedException("Parent not found", "Unable to find the parent for Cabinet.");
        }
        MoFactory moFactory = this.aFactoryMgr.lookup("Cabinet");
        if (moFactory == null) {
            throw new SupportSystemConfigurationFailedException("MO factory not found", "Unable to find the MO factory for Cabinet.");
        }
        AttrListImpl attrListImpl = new AttrListImpl();
        attrListImpl.addElement(ATTRIBUTE_CLIMATE_CONTROL_MODE, (Object)new Integer(0));
        attrListImpl.addElement("climateSystem", (Object)new Integer(0));
        attrListImpl.addElement("climateRegulationSystem", (Object)new Integer(0));
        try {
            managedObject = moFactory.createMo(managedObject2, (AttrList)attrListImpl, this.getNextCabinetId(), null, coordinator);
            ReportLoggerHelper.getInstance().logAction("Cabinet", "create", new String[]{ATTRIBUTE_CLIMATE_CONTROL_MODE, "climateSystem", "climateRegulationSystem"}, new Object[]{new Integer(0), new Integer(0), new Integer(0)});
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException("Cabinet MO. ", "Failed to create MO. Unable to create the Cabinet MO.");
        }
        logger.traceReturn(THIS_CLASS, "createCabinet()");
        return managedObject;
    }

    private String getNextCabinetId() throws SupportSystemConfigurationFailedException {
        int n = 1;
        logger.traceEnter(THIS_CLASS, "getNextCabinetId()");
        while (this.isCabinetIdInUse(n)) {
            ++n;
        }
        Integer n2 = new Integer(n);
        logger.traceReturn(THIS_CLASS, "getNextCabinetId()");
        return n2.toString();
    }

    private String getNextClimateId() throws SupportSystemConfigurationFailedException {
        int n = 1;
        logger.traceEnter(THIS_CLASS, "getNextClimateId()");
        while (this.isClimateIdInUse(n)) {
            ++n;
        }
        Integer n2 = new Integer(n);
        logger.traceReturn(THIS_CLASS, "getNextClimateId()");
        return n2.toString();
    }

    private boolean isCabinetIdInUse(int n) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "isCabinetIdInUse()");
        MoIterator moIterator = this.aMoRepository.lookupType("Cabinet");
        boolean bl = false;
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!managedObject.getNamingAttributeValue().equals(Integer.toString(n))) continue;
            bl = true;
        }
        logger.traceReturn(THIS_CLASS, "isCabinetIdInUse()");
        return bl;
    }

    private boolean isClimateIdInUse(int n) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "isClimateIdInUse()");
        MoIterator moIterator = this.aMoRepository.lookupType("Climate");
        boolean bl = false;
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!managedObject.getNamingAttributeValue().equals(Integer.toString(n))) continue;
            bl = true;
        }
        logger.traceReturn(THIS_CLASS, "isClimateIdInUse()");
        return bl;
    }

    private void createCabinet(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createCabinet()");
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1");
        if (managedObject == null) {
            throw new SupportSystemConfigurationFailedException("Parent not found", "Unable to find the parent for Cabinet.");
        }
        MoFactory moFactory = this.aFactoryMgr.lookup("Cabinet");
        if (moFactory == null) {
            throw new SupportSystemConfigurationFailedException("MO factory not found", "Unable to find the MO factory for Cabinet.");
        }
        AttrListImpl attrListImpl = new AttrListImpl();
        attrListImpl.addElement(ATTRIBUTE_CLIMATE_CONTROL_MODE, (Object)new Integer(supportSystemData.climateControlMode));
        attrListImpl.addElement("climateSystem", (Object)new Integer(supportSystemData.climateSystem));
        attrListImpl.addElement("climateRegulationSystem", (Object)new Integer(supportSystemData.climateRegulationSystem));
        attrListImpl.addElement("smokeDetector", (Object)supportSystemData.smokeDetector);
        attrListImpl.addElement("sharedCabinetIdentifier", (Object)"");
        try {
            moFactory.createMo(managedObject, (AttrList)attrListImpl, "1", null, coordinator);
            ReportLoggerHelper.getInstance().logAction("Cabinet", "create", new String[]{ATTRIBUTE_CLIMATE_CONTROL_MODE, "climateSystem", "climateRegulationSystem"}, new Object[]{new Integer(supportSystemData.climateSystem), new Integer(supportSystemData.climateControlMode), new Integer(supportSystemData.climateRegulationSystem)});
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException("Failed to create MO", "Unable to create the Cabinet MO.", (Exception)((Object)moAccessException));
        }
        logger.traceReturn(THIS_CLASS, "createCabinet()");
    }

    private void createCabinetMultiCabinet(int n, SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createCabinetMultiCabinet()");
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1");
        if (managedObject == null) {
            throw new SupportSystemConfigurationFailedException("Parent not found", "Unable to find the parent for Cabinet.");
        }
        MoFactory moFactory = this.aFactoryMgr.lookup("Cabinet");
        if (moFactory == null) {
            throw new SupportSystemConfigurationFailedException("MO factory not found", "Unable to find the MO factory for Cabinet.");
        }
        AttrListImpl attrListImpl = new AttrListImpl();
        attrListImpl.addElement("climateRegulationSystem", (Object)new Integer(supportSystemData.cabinetDataList[n].climateRegulationSystem));
        attrListImpl.addElement("climateSystem", (Object)new Integer(supportSystemData.cabinetDataList[n].climateSystem));
        attrListImpl.addElement("smokeDetector", (Object)supportSystemData.cabinetDataList[n].smokeDetector);
        if (supportSystemData.cabinetDataList[n].sharedCabinetIdentifier != null) {
            attrListImpl.addElement("sharedCabinetIdentifier", (Object)new String(supportSystemData.cabinetDataList[n].sharedCabinetIdentifier));
        }
        if (supportSystemData.cabinetDataList[n].userLabel != null) {
            attrListImpl.addElement("userLabel", (Object)new String(supportSystemData.cabinetDataList[n].userLabel));
        }
        try {
            moFactory.createMo(managedObject, (AttrList)attrListImpl, this.makeId(supportSystemData.cabinetDataList[n].cabinetId), null, coordinator);
            ReportLoggerHelper.getInstance().logAction("Cabinet", "create", new String[]{ATTRIBUTE_CLIMATE_CONTROL_MODE, "climateSystem"}, new Object[]{new Integer(supportSystemData.cabinetDataList[n].climateSystem), new Integer(supportSystemData.cabinetDataList[n].climateRegulationSystem)});
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException("Failed to create MO", "Unable to create the Cabinet MO.", (Exception)((Object)moAccessException));
        }
        logger.traceReturn(THIS_CLASS, "createCabinetMultiCabinet()");
    }

    private void setCabinet(SupportSystemData supportSystemData, ManagedObject managedObject, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setCabinet()");
        String[] stringArray = new String[]{ATTRIBUTE_CLIMATE_CONTROL_MODE, "climateSystem", "smokeDetector", "climateRegulationSystem"};
        try {
            Object[] objectArray = new Object[]{new Integer(supportSystemData.climateControlMode), new Integer(supportSystemData.climateSystem), supportSystemData.smokeDetector, new Integer(supportSystemData.climateRegulationSystem)};
            managedObject.setAttributes(stringArray, objectArray, coordinator);
            ReportLoggerHelper.getInstance().logAttribute("Cabinet", ATTRIBUTE_CLIMATE_CONTROL_MODE, Integer.toString(supportSystemData.climateControlMode));
            ReportLoggerHelper.getInstance().logAttribute("Cabinet", "climateSystem", Integer.toString(supportSystemData.climateSystem));
            ReportLoggerHelper.getInstance().logAttribute("Cabinet", "smokeDetector", Boolean.toString(supportSystemData.smokeDetector));
            ReportLoggerHelper.getInstance().logAttribute("Cabinet", "climateRegulationSystem", Integer.toString(supportSystemData.climateRegulationSystem));
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException("Failed to set attributes", "Unable to update attributes on the Cabinet MO.", (Exception)((Object)moAccessException));
        }
        logger.traceReturn(THIS_CLASS, "setCabinet()");
    }

    private void setCabinetMultiCabinet(int n, SupportSystemData supportSystemData, ManagedObject managedObject, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setCabinetMultiCabinet()");
        String[] stringArray = new String[]{ATTRIBUTE_CLIMATE_CONTROL_MODE, "climateSystem", "smokeDetector", "sharedCabinetIdentifier"};
        try {
            Object[] objectArray = new Object[]{new Integer(supportSystemData.climateControlMode), new Integer(supportSystemData.climateSystem), supportSystemData.smokeDetector, new String(supportSystemData.cabinetDataList[n].sharedCabinetIdentifier)};
            managedObject.setAttributes(stringArray, objectArray, coordinator);
            ReportLoggerHelper.getInstance().logAttribute("Cabinet", ATTRIBUTE_CLIMATE_CONTROL_MODE, Integer.toString(supportSystemData.climateControlMode));
            ReportLoggerHelper.getInstance().logAttribute("Cabinet", "climateSystem", Integer.toString(supportSystemData.climateSystem));
            ReportLoggerHelper.getInstance().logAttribute("Cabinet", "smokeDetector", Boolean.toString(supportSystemData.smokeDetector));
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException("Failed to set attributes", "Unable to update attributes on the Cabinet MO.", (Exception)((Object)moAccessException));
        }
        logger.traceReturn(THIS_CLASS, "setCabinetMultiCabinet()");
    }

    private String makeId(String string) {
        return string.substring(string.length() - 1);
    }

    private boolean areDuplicatesInCabinetDataList(CabinetData[] cabinetDataArray) {
        logger.traceEnter(THIS_CLASS, "areDuplicatesInCabinetDataList()");
        boolean bl = false;
        for (int i = 0; i < cabinetDataArray.length; ++i) {
            for (int j = i + 1; j < cabinetDataArray.length; ++j) {
                if (!cabinetDataArray[i].cabinetId.equalsIgnoreCase(cabinetDataArray[j].cabinetId)) continue;
                bl = true;
            }
        }
        logger.traceReturn(THIS_CLASS, "areDuplicatesInCabinetDataList()");
        return bl;
    }
}

