/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.SupportSystemData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.EquipmentSupportFunctionHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.ReferenceHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.ReportLoggerHelper;

public class EcBusHelper {
    private static final Class THIS_CLASS = EcBusHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient MoRepositoryWrapper aMoRepository;
    private final transient MoFactoryMgrWrapper aFactoryMgr;

    public EcBusHelper(GenericMaoContext genericMaoContext) {
        logger.traceEnter(THIS_CLASS, "EcBusHelper() - Constructor");
        this.aMoRepository = genericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = genericMaoContext.getMoFactoryMgrWrapper();
        logger.traceReturn(THIS_CLASS, "EcBusHelper() - Constructor");
    }

    public ManagedObject getEcBus(Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getEcBus()");
        MoIterator moIterator = this.aMoRepository.lookupType("EcBus");
        ManagedObject managedObject = null;
        if (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            return managedObject;
        }
        ManagedObject managedObject2 = this.aMoRepository.lookup("ManagedElement=1,Equipment=1");
        if (managedObject2 == null) {
            throw new SupportSystemConfigurationFailedException("Parent not found", "Unable to find the parent for EcBus.");
        }
        MoFactory moFactory = this.aFactoryMgr.lookup("EcBus");
        if (moFactory == null) {
            throw new SupportSystemConfigurationFailedException("MO factory not found", "Unable to find the MO factory for EcBus.");
        }
        AttrListImpl attrListImpl = new AttrListImpl();
        attrListImpl.addElement("connectionType", (Object)new String(""));
        ManagedObject managedObject3 = this.getPlugInUnit(coordinator);
        attrListImpl.addElement("ecBusConnectorRef", (Object)managedObject3);
        try {
            managedObject = moFactory.createMo(managedObject2, (AttrList)attrListImpl, String.valueOf(this.getTopEcBusId() + 1), null, coordinator);
            ReportLoggerHelper.getInstance().logAction("EcBus", "create", new String[]{"connectionType", "ecBusConnectorRef"}, new Object[]{new String(""), managedObject3});
        }
        catch (MoAccessException moAccessException) {
            String string = "Failed to create MO. Unable to create the EcBus MO." + moAccessException.toString();
            throw new SupportSystemConfigurationFailedException("EcBus MO. ", string);
        }
        logger.traceReturn(THIS_CLASS, "getEcBus()");
        return managedObject;
    }

    public ManagedObject getPlugInUnit(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "getPlugInUnit()");
        MoIterator moIterator = this.aMoRepository.lookupType("PlugInUnit");
        ManagedObject managedObject = moIterator != null && moIterator.hasMoreElements() ? (ManagedObject)moIterator.nextElement() : null;
        logger.traceReturn(THIS_CLASS, "getPlugInUnit()");
        return managedObject;
    }

    public void createAndConfigureEcBusMultiCabinet(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigureEcBusMultiCabinet()");
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1");
        if (managedObject == null) {
            throw new SupportSystemConfigurationFailedException("Parent not found", "Unable to find the parent for EcBus.");
        }
        MoFactory moFactory = this.aFactoryMgr.lookup("EcBus");
        for (int i = 0; i < supportSystemData.ecBusDataList.length; ++i) {
            AttrListImpl attrListImpl = new AttrListImpl();
            logger.traceDebug(THIS_CLASS, "createAndConfigureEcBusMultiCabinet() supportSystemData.ecBusDataList[i].ecBusConnectorRef=" + supportSystemData.ecBusDataList[i].ecBusConnectorRef);
            ManagedObject managedObject2 = new ReferenceHelper(this.aMoRepository).tryDu().tryXmu().tryIru().get(supportSystemData.ecBusDataList[i].ecBusConnectorRef);
            logger.traceDebug(THIS_CLASS, "createAndConfigureEcBusMultiCabinet() plugInUnitMo=" + managedObject2);
            if (managedObject2 == null) {
                String string = "Unable to find PlugInUnit/AuxPlugInUnit with id = " + supportSystemData.ecBusDataList[i].ecBusConnectorRef + ".";
                throw new SupportSystemConfigurationFailedException("Object with reference given not found", string);
            }
            attrListImpl.addElement("ecBusConnectorRef", (Object)managedObject2);
            attrListImpl.addElement("connectionType", (Object)new String(supportSystemData.ecBusDataList[i].connectionType));
            ManagedObject managedObject3 = EquipmentSupportFunctionHelper.getEquipmentSupportFunctionMo(this.aMoRepository, this.aFactoryMgr, supportSystemData.ecBusDataList[i].equipmentSupportFunctionRef, coordinator);
            attrListImpl.addElement("equipmentSupportFunctionRef", (Object)managedObject3);
            try {
                moFactory.createMo(managedObject, (AttrList)attrListImpl, this.makeId(supportSystemData.ecBusDataList[i].ecBusId), null, coordinator);
                continue;
            }
            catch (MoAccessException moAccessException) {
                String string = "Failed to create MO. Unable to create the EcBus MO." + moAccessException.toString();
                throw new SupportSystemConfigurationFailedException("EcBus MO. ", string);
            }
        }
        logger.traceReturn(THIS_CLASS, "createAndConfigureEcBusMultiCabinet()");
    }

    private String makeId(String string) {
        return string.substring(string.length() - 1);
    }

    private int getTopEcBusId() {
        logger.traceEnter(THIS_CLASS, "getTopEcBusId()");
        int n = 0;
        MoIterator moIterator = this.aMoRepository.lookupType("EcBus");
        if (moIterator != null) {
            ManagedObject managedObject = null;
            while (moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
            }
            n = managedObject == null ? 0 : Integer.parseInt(this.makeId(managedObject.getFullDistinguishedName()));
        }
        logger.traceReturn(THIS_CLASS, "getTopEcBusId()");
        return n;
    }
}

