/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;

public class EquipmentSupportFunctionHelper {
    private static final Class THIS_CLASS = EquipmentSupportFunctionHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";
    private static final String ATTRIBUTE_SUPPORT_SYSTEM_CONTROL = "supportSystemControl";

    public static boolean isSupportSystemControl(GenericMaoContext genericMaoContext, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "isSupportSystemControl()");
        boolean bl = true;
        MoIterator moIterator = genericMaoContext.getMoRepositoryWrapper().lookupType(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
        if (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator);
            logger.traceDebug(THIS_CLASS, "SupportSystemControl attribute found: " + bl);
        } else {
            logger.traceAbnormal(THIS_CLASS, "SupportSystemControl attribute was not found.");
        }
        logger.traceReturn(THIS_CLASS, "isSupportSystemControl(), attribute: " + bl);
        return bl;
    }

    public static boolean isDoubleRole(GenericMaoContext genericMaoContext) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "isDoubleRole()");
        boolean bl = false;
        MoIterator moIterator = genericMaoContext.getMoRepositoryWrapper().lookupType(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
        if (moIterator != null && moIterator.size() > 1) {
            logger.traceDebug(THIS_CLASS, "Two EquipmentSupportFunction configured.");
            return true;
        }
        logger.traceDebug(THIS_CLASS, "One EquipmentSupportFunction configured.");
        return false;
    }

    public static ManagedObject getEquipmentSupportFunctionMo(MoRepositoryWrapper moRepositoryWrapper, MoFactoryMgrWrapper moFactoryMgrWrapper, String string, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        String string2;
        logger.traceEnter(THIS_CLASS, "getEquipmentSupportFunctionMo()");
        MoIterator moIterator = moRepositoryWrapper.lookupType(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
        ManagedObject managedObject = null;
        if (moIterator.size() < 2 && string.equalsIgnoreCase("SECOND")) {
            MoFactory moFactory = moFactoryMgrWrapper.lookup(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
            ManagedObject managedObject2 = moRepositoryWrapper.lookup("ManagedElement=1");
            try {
                ManagedObject managedObject3 = moIterator.nextMo();
                boolean bl = (Boolean)managedObject3.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator);
                AttrListImpl attrListImpl = new AttrListImpl();
                attrListImpl.addElement(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, (Object)new Boolean(!bl));
                managedObject = moFactory.createMo(managedObject2, (AttrList)attrListImpl, "2", null, coordinator);
            }
            catch (MoAccessException moAccessException) {
                String string3 = "Failed to create MO";
                throw new SupportSystemConfigurationFailedException(string3, "Could not create the + EquipmentSupportFunction MO.", (Exception)((Object)moAccessException));
            }
            return managedObject;
        }
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject4 = moIterator.nextMo();
            string2 = managedObject4.getFullDistinguishedName();
            if (EquipmentSupportFunctionHelper.makeId(string2).equalsIgnoreCase(EquipmentSupportFunctionHelper.makeIdByEsfEnum(string))) {
                managedObject = managedObject4;
                break;
            }
            if (!string.equalsIgnoreCase("SECOND") || EquipmentSupportFunctionHelper.makeId(string2).equalsIgnoreCase("1")) continue;
            managedObject = managedObject4;
            break;
        }
        if (managedObject == null) {
            string2 = "Unable to find EquipmentSupportFunction with id = " + string + ".";
            throw new SupportSystemConfigurationFailedException("Object with reference given not found", string2);
        }
        return managedObject;
    }

    public static void checkAndConfigureDualRole(MoRepositoryWrapper moRepositoryWrapper, MoFactoryMgrWrapper moFactoryMgrWrapper, boolean bl, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "checkAndConfigureDualRole()");
        MoIterator moIterator = moRepositoryWrapper.lookupType(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
        ManagedObject managedObject = null;
        if (moIterator.size() < 2 && bl) {
            logger.traceDebug(THIS_CLASS, "create second EquipmentSupportFunction MO");
            MoFactory moFactory = moFactoryMgrWrapper.lookup(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
            ManagedObject managedObject2 = moRepositoryWrapper.lookup("ManagedElement=1");
            try {
                ManagedObject managedObject3 = moIterator.nextMo();
                boolean bl2 = (Boolean)managedObject3.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator);
                AttrListImpl attrListImpl = new AttrListImpl();
                attrListImpl.addElement(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, (Object)new Boolean(!bl2));
                managedObject = moFactory.createMo(managedObject2, (AttrList)attrListImpl, "2", null, coordinator);
            }
            catch (MoAccessException moAccessException) {
                String string = "Failed to create MO";
                throw new SupportSystemConfigurationFailedException(string, "Could not create the + EquipmentSupportFunction MO.", (Exception)((Object)moAccessException));
            }
        }
    }

    private static String makeId(String string) {
        return string.substring(string.length() - 1);
    }

    private static String makeIdByEsfEnum(String string) {
        if (string.equalsIgnoreCase("FIRST")) {
            return "1";
        }
        if (string.equalsIgnoreCase("SECOND")) {
            return "2";
        }
        return "";
    }
}

