/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.EquipmentSupportFunctionHelper;

public class FunctionalMoHelper {
    private static final Class THIS_CLASS = FunctionalMoHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ATTRIBUTE_RESERVED_BY = "reservedBy";
    private static final String PD_MO_TYPE = "PowerDistribution";
    private static final String PS_MO_TYPE = "PowerSupply";
    private static final String BB_MO_TYPE = "BatteryBackup";
    private static final String ECPORT_MO_TYPE = "EcPort";
    private static final String CLIMATE_MO_TYPE = "Climate";
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final String ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF = "equipmentSupportFunctionRef";
    private static final String ATTRIBUTE_ECBUSREF = "ecBusRef";

    public FunctionalMoHelper() {
        logger.traceEnter(THIS_CLASS, "FunctionalMoHelper() - Constructor");
        logger.traceReturn(THIS_CLASS, "FunctionalMoHelper() - Constructor");
    }

    public void validateFunctionalMOWhenPreSetControlDomainRef(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator, GenericMaoContext genericMaoContext) throws SupportSystemConfigurationFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateFunctionalMOWhenPreSetControlDomainRef()");
        if (EquipmentSupportFunctionHelper.isDoubleRole(genericMaoContext)) {
            ManagedObject managedObject3 = managedObject.getParent();
            ManagedObject[] managedObjectArray = (ManagedObject[])managedObject2.getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!managedObjectArray[i].getType().equals(PD_MO_TYPE) && !managedObjectArray[i].getType().equals(PS_MO_TYPE) && !managedObjectArray[i].getType().equals(BB_MO_TYPE) && !managedObjectArray[i].getType().equals(CLIMATE_MO_TYPE) || managedObject3 == managedObjectArray[i].getParent()) continue;
                throw new SupportSystemConfigurationFailedException("ControlDomainRef is wrong", "Functional MOs under each MO EquipmentSupportFunction refer to the same MO Cabinet");
            }
            logger.traceReturn(THIS_CLASS, "validateFunctionalMOWhenPreSetControlDomainRef()");
        }
    }

    public void validateEsfRefChain(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws SupportSystemConfigurationFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateEsfRefChain()");
        if (managedObject2 != null && managedObject2.getType().equals(CABINET_MO_TYPE)) {
            ManagedObject[] managedObjectArray = (ManagedObject[])managedObject2.getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                MoIterator moIterator = managedObjectArray[i].getChildren();
                while (moIterator.hasMoreElements()) {
                    ManagedObject managedObject3;
                    ManagedObject managedObject4;
                    ManagedObject managedObject5 = moIterator.nextMo();
                    if (!ECPORT_MO_TYPE.equals(managedObject5.getType()) || (managedObject4 = (ManagedObject)managedObject5.getAttribute(ATTRIBUTE_ECBUSREF, coordinator)) == null || (managedObject3 = (ManagedObject)managedObject4.getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator)) == null || managedObject == managedObject3) continue;
                    throw new SupportSystemConfigurationFailedException("controlDomainRef is faulty", "There is a conflicting reference chain to EquipmentSupportFunction.");
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "validateEsfRefChain()");
    }
}

