/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;

public class ReferenceHelper {
    private static final Class THIS_CLASS = ReferenceHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private boolean du;
    private boolean xmu;
    private boolean iru;
    private boolean ecbus;
    private boolean externalnode;
    private MoRepositoryWrapper moRepository;

    public ReferenceHelper(MoRepositoryWrapper moRepositoryWrapper) {
        this.moRepository = moRepositoryWrapper;
        this.reset();
    }

    public ReferenceHelper reset() {
        this.externalnode = false;
        this.ecbus = false;
        this.iru = false;
        this.xmu = false;
        this.du = false;
        return this;
    }

    public ReferenceHelper tryDu() {
        this.du = true;
        return this;
    }

    public ReferenceHelper tryXmu() {
        this.xmu = true;
        return this;
    }

    public ReferenceHelper tryIru() {
        this.iru = true;
        return this;
    }

    public ReferenceHelper tryEcBus() {
        this.ecbus = true;
        return this;
    }

    public ReferenceHelper tryExternalNode() {
        this.externalnode = true;
        return this;
    }

    public ManagedObject get(String string) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "ReferenceHelper.get()");
        ManagedObject managedObject = null;
        if (this.du) {
            managedObject = this.getPlugInUnit(string);
        }
        if (managedObject == null && this.xmu) {
            managedObject = this.getXmu(string);
        }
        if (managedObject == null && this.iru) {
            managedObject = this.getIru(string);
        }
        if (managedObject == null && this.ecbus) {
            managedObject = this.getEcBus(string);
        }
        if (managedObject == null && this.externalnode) {
            managedObject = this.getExternalNode(string);
        }
        logger.traceReturn(THIS_CLASS, "ReferenceHelper.get()");
        return managedObject;
    }

    public ManagedObject getPlugInUnit(String string) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getPlugInUnit()");
        ManagedObject managedObject = null;
        if (string != null && string.startsWith("DU")) {
            MoIterator moIterator = this.moRepository.lookupType("PlugInUnit");
            if (moIterator == null) {
                String string2 = "Failed to get DU: " + string;
                throw new SupportSystemConfigurationFailedException("Getting DU failure. ", string2);
            }
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                String string3 = managedObject2.getFullDistinguishedName();
                logger.traceDebug(THIS_CLASS, "ReferenceHelper 1 getPlugInUnit() name=" + string3);
                logger.traceDebug(THIS_CLASS, "ReferenceHelper 2 getPlugInUnit() makeId(name)=" + this.makeId(string3));
                logger.traceDebug(THIS_CLASS, "ReferenceHelper 2 getPlugInUnit() makeIdBySlot(name)=" + this.makeIdBySlot(string3));
                logger.traceDebug(THIS_CLASS, "ReferenceHelper 3 getPlugInUnit() id=" + string);
                logger.traceDebug(THIS_CLASS, "ReferenceHelper 4 getPlugInUnit() makeId(id)=" + string);
                if (this.makeId(string3).equalsIgnoreCase(this.makeId(string))) {
                    managedObject = managedObject2;
                    break;
                }
                if (!this.makeIdBySlot(string3).equalsIgnoreCase(this.makeId(string))) continue;
                managedObject = managedObject2;
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "getPlugInUnit()");
        return managedObject;
    }

    public ManagedObject getXmu(String string) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getXmu()");
        ManagedObject managedObject = null;
        if (string != null && string.startsWith("XMU")) {
            MoIterator moIterator = this.moRepository.lookupType("AuxPlugInUnit");
            if (moIterator == null) {
                String string2 = "Failed to get XMU: " + string;
                throw new SupportSystemConfigurationFailedException("Getting XMU failure. ", string2);
            }
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                String string3 = managedObject2.getFullDistinguishedName();
                if (!this.makeXmuId(string3).equalsIgnoreCase(this.makeXmuId(string))) continue;
                managedObject = managedObject2;
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "getXmu()");
        return managedObject;
    }

    public ManagedObject getIru(String string) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getIru()");
        ManagedObject managedObject = null;
        if (string != null && string.startsWith("IRU")) {
            MoIterator moIterator = this.moRepository.lookupType("AuxPlugInUnit");
            if (moIterator == null) {
                String string2 = "Failed to get IRU: " + string;
                throw new SupportSystemConfigurationFailedException("Getting IRU failure. ", string2);
            }
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                String string3 = managedObject2.getFullDistinguishedName();
                if (!this.makeIruId(string3).equalsIgnoreCase(this.makeIruId(string))) continue;
                managedObject = managedObject2;
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "getIru()");
        return managedObject;
    }

    public ManagedObject getExternalNode(String string) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getExternalNode()");
        ManagedObject managedObject = null;
        if (string != null && string.startsWith("ExternalNode")) {
            managedObject = this.moRepository.lookup("ManagedElement=1,Equipment=1,ExternalNode=" + this.makeId(string));
        }
        logger.traceReturn(THIS_CLASS, "getExternalNode()");
        return managedObject;
    }

    public ManagedObject getEcBus(String string) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getEcBus()");
        ManagedObject managedObject = null;
        if (string != null && string.startsWith("EcBus")) {
            managedObject = this.moRepository.lookup("ManagedElement=1,Equipment=1,EcBus=" + this.makeId(string));
        }
        logger.traceReturn(THIS_CLASS, "getEcBus()");
        return managedObject;
    }

    private String makeId(String string) {
        return string.substring(string.length() - 1);
    }

    private String makeIdBySlot(String string) {
        int n = string.lastIndexOf("Slot") + "Slot".length() + "=".length();
        int n2 = string.indexOf(",", n);
        return string.substring(n, n2);
    }

    private String makeXmuId(String string) {
        int n = string.lastIndexOf("XMU");
        return string.substring(n + "XMU".length());
    }

    private String makeIruId(String string) {
        int n = string.lastIndexOf("IRU");
        return string.substring(n + "IRU".length());
    }
}

