/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import ConfigExtended.NotificationProducer;
import ConfigExtended.NotificationProducerPackage.InvalidFilterConstraintsException;
import ConfigExtended.NotificationProducerPackage.MOTypeAndAttributes;
import ConfigExtended.NotificationProducerPackage.NotificationFilter;
import ConfigExtended.NotificationProducerPackage.NotificationFilterExt;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CmNotificationConsumerImpl;
import se.ericsson.cello.neal.cm.CmSubscription;
import se.ericsson.cello.neal.cm.CmSubscriptionMgr;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NotificationType;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.ServiceContext;

class CelloCmSubscription
implements CmSubscription {
    static final boolean DEBUG = false;
    static final int LEASE_PERIOD = 600;
    static final int TICK_PERIOD = 60000;
    private int _refCount;
    private int _subscriptionId;
    private NotificationType _notificationType;
    private String[] _moTypes;
    private Mo _baseMO;
    private Scope _scope;
    private CmNotificationConsumerImpl _notificationConsumer;
    private CmSubscriptionMgr _subscriptionMgr;
    private ServiceContext serviceContext;

    static void d(String string) {
    }

    static void d(Exception exception) {
        CelloCmSubscription.d(exception.toString());
    }

    CelloCmSubscription(CmSubscriptionMgr cmSubscriptionMgr, Mo mo, NotificationType notificationType, String[] stringArray, Scope scope, CmNotificationConsumerImpl cmNotificationConsumerImpl, ServiceContext serviceContext) {
        this._subscriptionMgr = cmSubscriptionMgr;
        this._notificationType = notificationType;
        this._moTypes = stringArray;
        this._scope = scope;
        this._notificationConsumer = cmNotificationConsumerImpl;
        this._baseMO = mo;
        this.serviceContext = serviceContext;
    }

    NotificationType getNotificationType() {
        return this._notificationType;
    }

    Scope getScope() {
        return this._scope;
    }

    String[] getMOTypes() {
        return this._moTypes;
    }

    Mo getBaseMO() {
        return this._baseMO;
    }

    public String toString() {
        return this.getClass().getName() + ":" + "CelloCmSubscriptionId=" + this._subscriptionId;
    }

    public boolean equals(Object object) {
        try {
            CelloCmSubscription celloCmSubscription;
            if (object != null && object.getClass().equals(this.getClass()) && this._notificationType.equals((celloCmSubscription = (CelloCmSubscription)object).getNotificationType()) && this._scope.equals(celloCmSubscription.getScope()) && ((Object)this._baseMO).equals(celloCmSubscription.getBaseMO()) && this._moTypes.length == celloCmSubscription.getMOTypes().length) {
                for (int i = 0; i < this._moTypes.length; ++i) {
                    boolean bl = false;
                    String string = this._moTypes[i];
                    for (int j = 0; j < celloCmSubscription.getMOTypes().length; ++j) {
                        if (!string.equals(celloCmSubscription.getMOTypes()[j]) && !celloCmSubscription.getMOTypes()[j].equals("")) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    return false;
                }
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public int hashCode() {
        return this._subscriptionId;
    }

    public void cancel() {
        --this._refCount;
        if (!this.hasSubscribers()) {
            this.unsubscribe();
            this._subscriptionMgr.remove(this);
        }
        this._notificationConsumer.cleanUpIfNoMoreSubscription();
    }

    void keepAlive() {
        if (this.hasSubscribers()) {
            this.renewLease();
        }
    }

    private void sendSubscriptionNotActive() {
        new Thread(new Runnable(){

            public void run() {
                CelloCmSubscription.this._subscriptionMgr.remove(CelloCmSubscription.this);
                CelloCmSubscription.this._notificationConsumer.getClientConsumer().subscriptionNotActive(CelloCmSubscription.this, CelloCmSubscription.this._baseMO.getNode());
            }
        }).start();
    }

    private void sendCommunicationFailed(final String string) {
        new Thread(new Runnable(){

            public void run() {
                CelloCmSubscription.this._notificationConsumer.getClientConsumer().communicationFailed(CelloCmSubscription.this, CelloCmSubscription.this._baseMO.getNode(), string);
            }
        }).start();
    }

    void renewLease() {
        try {
            boolean bl = this.getProducer().get_subscription_status(this._subscriptionId);
            if (bl) {
                return;
            }
            this.sendSubscriptionNotActive();
            return;
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            CelloCmSubscription.d((Exception)((Object)cOMM_FAILURE));
            this.sendCommunicationFailed(cOMM_FAILURE.toString());
            return;
        }
        catch (TRANSIENT tRANSIENT) {
            CelloCmSubscription.d((Exception)((Object)tRANSIENT));
            this.sendCommunicationFailed(tRANSIENT.toString());
            return;
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            CelloCmSubscription.d((Exception)((Object)oBJECT_NOT_EXIST));
            this.sendCommunicationFailed(oBJECT_NOT_EXIST.toString());
            return;
        }
        catch (SystemException systemException) {
            CelloCmSubscription.d((Exception)((Object)systemException));
            this.sendCommunicationFailed(systemException.toString());
            return;
        }
        catch (CmException cmException) {
            CelloCmSubscription.d(cmException);
            this.sendCommunicationFailed(cmException.toString());
            return;
        }
    }

    int getSubscriptionId() {
        return this._subscriptionId;
    }

    public boolean isAlive() {
        NealLog.fine("Get subscription status for ID = " + this._subscriptionId);
        boolean bl = this.getProducer().get_subscription_status(this._subscriptionId);
        NealLog.fine("Status for ID = " + this._subscriptionId + " is " + bl);
        return bl;
    }

    private boolean hasSubscribers() {
        return this._refCount > 0;
    }

    void subscribe() {
        try {
            if (!this.hasSubscribers()) {
                IntHolder intHolder = new IntHolder();
                if (this.isSDNSupported()) {
                    this.getProducer().subscribe_ext_v2(this._notificationConsumer.getReference(), this.constructFilterExt(), 600, intHolder);
                } else {
                    this.getProducer().subscribe(this._notificationConsumer.getReference(), this.constructFilter(), 600, intHolder);
                }
                this._subscriptionId = intHolder.value;
                ++this._refCount;
            } else {
                ++this._refCount;
            }
        }
        catch (InvalidFilterConstraintsException invalidFilterConstraintsException) {
            throw new CmException((UserException)((Object)invalidFilterConstraintsException));
        }
    }

    private boolean isSDNSupported() {
        boolean bl = false;
        String[] stringArray = this.serviceContext.getConfigurationExtended().get_CS_interface_version();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("1c4")) continue;
            bl = true;
        }
        return bl;
    }

    void unsubscribe() {
        try {
            if (this.isAlive()) {
                this.getProducer().unsubscribe(this._subscriptionId);
            }
        }
        catch (CmException cmException) {
            // empty catch block
        }
    }

    private NotificationProducer getProducer() {
        return this.serviceContext.getNotificationProducer();
    }

    private NotificationFilter constructFilter() {
        NotificationFilter notificationFilter = new NotificationFilter(this._moTypes, this._notificationType.isTopology(), this._notificationType.isAVC(), this._baseMO.getLdn(), this._scope.getScope());
        return notificationFilter;
    }

    private NotificationFilterExt constructFilterExt() {
        NotificationFilterExt notificationFilterExt = new NotificationFilterExt(this.convertToMoTypeAndAttr(this._moTypes), this._notificationType.isTopology(), this._notificationType.isAVC(), this._baseMO.getLdn(), this._scope.getScope());
        return notificationFilterExt;
    }

    private MOTypeAndAttributes[] convertToMoTypeAndAttr(String[] stringArray) {
        MOTypeAndAttributes[] mOTypeAndAttributesArray = new MOTypeAndAttributes[stringArray.length];
        for (int i = 0; i < mOTypeAndAttributesArray.length; ++i) {
            mOTypeAndAttributesArray[i] = new MOTypeAndAttributes(stringArray[i], new String[0]);
        }
        return mOTypeAndAttributesArray;
    }
}

