/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import BasicConfig.ProcessingFailure;
import BasicConfig.Session;
import BasicConfig.TransactionFailure;
import ConfigExtended.ConfigurationExtended;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.Transaction;

class CelloTransaction
implements Transaction {
    private Session _delegate;
    private String _txName;
    private boolean isNullTransaction = false;
    private static long nextIndex = 0L;
    private final long thisIndex = nextIndex++;

    CelloTransaction() {
        this.isNullTransaction = true;
    }

    CelloTransaction(ConfigurationExtended configurationExtended) {
        this(configurationExtended, -1, null);
    }

    CelloTransaction(ConfigurationExtended configurationExtended, int n) {
        this(configurationExtended, n, null);
    }

    private CelloTransaction(ConfigurationExtended configurationExtended, int n, String string) {
        this._txName = string == null ? this.generateSessionId() : string;
        int n2 = n < 0 ? -1 : n / 1000;
        n2 = n2 == 0 ? 1 : n2;
        try {
            this._delegate = configurationExtended.create_session(this._txName, n2);
        }
        catch (ProcessingFailure processingFailure) {
            throw new CmException((UserException)((Object)processingFailure));
        }
    }

    private final String generateSessionId() {
        String string = "NealSession_" + (this.isNullTransaction ? "null_" : "") + this.thisIndex;
        return string;
    }

    public void commit() {
        try {
            if (this._delegate != null) {
                this._delegate.commit();
            }
        }
        catch (TransactionFailure transactionFailure) {
            throw new CmException((UserException)((Object)transactionFailure));
        }
        finally {
            this.end();
        }
    }

    public void rollback() {
        try {
            if (this._delegate != null) {
                this._delegate.rollback();
            }
        }
        catch (TransactionFailure transactionFailure) {
            throw new CmException((UserException)((Object)transactionFailure));
        }
        finally {
            this.end();
        }
    }

    public void commitSessionPersists() {
        try {
            if (this._delegate != null) {
                this._delegate.commit();
            }
        }
        catch (TransactionFailure transactionFailure) {
            throw new CmException((UserException)((Object)transactionFailure));
        }
    }

    public void rollbackSessionPersists() {
        try {
            if (this._delegate != null) {
                this._delegate.rollback();
            }
        }
        catch (TransactionFailure transactionFailure) {
            throw new CmException((UserException)((Object)transactionFailure));
        }
    }

    public void restart() {
        try {
            if (this._delegate != null) {
                this._delegate.restart();
            } else if (!this.isNullTransaction) {
                throw new CmException("restart() despite session has been ended.");
            }
        }
        catch (ProcessingFailure processingFailure) {
            throw new CmException((UserException)((Object)processingFailure));
        }
    }

    public void end() {
        try {
            if (this._delegate != null) {
                this._delegate.end();
                this._delegate._release();
            }
            this._delegate = null;
        }
        catch (TransactionFailure transactionFailure) {
            this._delegate = null;
        }
        catch (SystemException systemException) {
            this._delegate = null;
        }
    }

    public String toString() {
        String string = "Transaction_";
        String string2 = "";
        string2 = this._delegate != null ? this._delegate.get_session_id() : this.generateSessionId();
        return string + string2;
    }

    public String getName() {
        return this._txName;
    }

    static Transaction startDefaultWriteTx(Transaction transaction, ConfigurationExtended configurationExtended) {
        if (transaction == null) {
            return new CelloTransaction(configurationExtended);
        }
        return transaction;
    }

    static Transaction startDefaultReadTx(Transaction transaction, ConfigurationExtended configurationExtended) {
        if (transaction == null) {
            return new CelloTransaction();
        }
        return transaction;
    }

    static void commitDefaultWriteTx(Transaction transaction, Transaction transaction2) {
        if (transaction2 == null) {
            transaction.commit();
        }
    }

    static void commitDefaultReadTx(Transaction transaction, Transaction transaction2) {
        if (transaction2 == null) {
            transaction.commit();
        }
    }

    static void rollbackDefaultWriteTx(Transaction transaction, Transaction transaction2) {
        if (transaction2 == null) {
            transaction.rollback();
        }
    }

    static void rollbackDefaultReadTx(Transaction transaction, Transaction transaction2) {
        if (transaction2 == null) {
            transaction.rollback();
        }
    }

    Session getBasicConfigSession() {
        return this._delegate;
    }
}

