/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.fm;

import se.ericsson.cello.neal.fm.AlarmIrpTranslator;
import se.ericsson.cello.neal.fm.FmException;

public class SeverityInfo {
    private static final int CRITICAL = 2;
    private static final int MAJOR = 3;
    private static final int MINOR = 4;
    private static final int WARNING = 5;
    private String specificProblem;
    private int severity;

    public SeverityInfo(String string, int n) throws FmException {
        if (n != 2 && n != 3 && n != 4 && n != 5) {
            throw new FmException("Invalid alarm severity specified");
        }
        this.severity = n;
        this.specificProblem = string;
    }

    public int getSeverityDef() {
        return this.severity;
    }

    public String getSeverity() {
        return AlarmIrpTranslator.getInstance().translatePerceivedSeverity(new Integer(this.severity));
    }

    public String getSpecificProblem() {
        return this.specificProblem;
    }
}

