/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.swmanagement.SwManagementAueConstants;
import se.ericsson.cello.transaction.Coordinator;

public class ConvertConnectedListAction
implements MoDataAction,
SwManagementAueConstants {
    private static final String PIU_INFO_DELIM = "<EndPiuInfo>";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        if (!moDataWrapper.getMoTypeName().equals("Repertoire")) {
            throw new AueException("Wrong type of MO " + moDataWrapper.getMoTypeName() + " Should be " + "Repertoire");
        }
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper.getAttribute("connectedList");
        if (sequenceAttribute == null) {
            throw new AueException("Attribute connectedList does not exist in " + moDataWrapper.getMoTypeName());
        }
        this.convertConnectedList(moDataWrapper, sequenceAttribute, coordinator);
    }

    private void convertConnectedList(MoDataWrapper moDataWrapper, SequenceAttribute sequenceAttribute, Coordinator coordinator) throws AueException {
        Collection collection = new HashSet(1);
        StringAttribute stringAttribute = null;
        Enumeration enumeration = sequenceAttribute.elements();
        while (enumeration.hasMoreElements()) {
            stringAttribute = (StringAttribute)enumeration.nextElement();
            collection = this.mergeConnectedListStrings(collection, stringAttribute.getValue(coordinator));
        }
        this.setNewDatabaseAttributes(moDataWrapper, collection);
    }

    private void setNewDatabaseAttributes(MoDataWrapper moDataWrapper, Collection collection) throws AueException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute("piuTypeRefs", false);
        SequenceAttribute sequenceAttribute2 = new SequenceAttribute("loadModuleRefs", false);
        String string = null;
        String string2 = null;
        String string3 = null;
        StringAttribute stringAttribute = null;
        int n = 1;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            int n2 = string.indexOf(PIU_INFO_DELIM);
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + PIU_INFO_DELIM.length());
            stringAttribute = this.convertToPiuTypeInfoStringAttribute(n, string2);
            if (stringAttribute != null) {
                sequenceAttribute.addElement((Attribute)stringAttribute);
            }
            if ((stringAttribute = this.convertToLoadModuleInfoStringAttribute(n, string3)) != null) {
                sequenceAttribute2.addElement((Attribute)stringAttribute);
            }
            ++n;
        }
        moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute);
        moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute2);
    }

    private StringAttribute convertToPiuTypeInfoStringAttribute(int n, String string) {
        if (string.length() == 0) {
            return null;
        }
        StringAttribute stringAttribute = null;
        String string2 = n + "#" + string;
        stringAttribute = new StringAttribute("", false, string2);
        return stringAttribute;
    }

    private StringAttribute convertToLoadModuleInfoStringAttribute(int n, String string) throws AueException {
        if (string.length() == 0) {
            return null;
        }
        StringAttribute stringAttribute = null;
        String string2 = "&\"\"&\"\"&\"\"";
        String string3 = n + "";
        HashSet hashSet = this.convertLoadModuleInfo(string);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            string3 = string3 + "#";
            string3 = string3 + (String)iterator.next() + string2;
        }
        stringAttribute = new StringAttribute("", false, string3);
        return stringAttribute;
    }

    private Collection mergeConnectedListStrings(Collection collection, String string) throws AueException {
        HashSet<String> hashSet = new HashSet<String>(1);
        int n = string.indexOf("&");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (collection.isEmpty()) {
            hashSet.add(string2 + PIU_INFO_DELIM + string3);
        } else {
            HashSet hashSet2 = this.convertLoadModuleInfo(string3);
            String string4 = null;
            Iterator iterator = collection.iterator();
            String string5 = null;
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                if (string5 != null) {
                    hashSet.add(string4);
                    continue;
                }
                if (this.matchingLoadModuleInfo(string4, hashSet2)) {
                    string5 = string4;
                    continue;
                }
                hashSet.add(string4);
            }
            if (string5 != null) {
                hashSet.add(string2 + "#" + string5);
            } else {
                hashSet.add(string2 + PIU_INFO_DELIM + string3);
            }
        }
        return hashSet;
    }

    private boolean matchingLoadModuleInfo(String string, HashSet hashSet) throws AueException {
        boolean bl = true;
        int n = string.indexOf(PIU_INFO_DELIM) + PIU_INFO_DELIM.length();
        String string2 = string.substring(n);
        HashSet hashSet2 = this.convertLoadModuleInfo(string2);
        if (hashSet2.size() != hashSet.size()) {
            bl = false;
        } else {
            String string3 = null;
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (hashSet.contains(string3)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private HashSet convertLoadModuleInfo(String string) throws AueException {
        HashSet<String> hashSet = new HashSet<String>(1);
        String string2 = null;
        String string3 = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                hashSet.add(string2 + "&" + string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new AueException(noSuchElementException.toString());
        }
        return hashSet;
    }
}

